/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;

public class GenRadioButtonField
extends LabelledField {
    private String[] translatableTags = null;
    private JRadioButton[] jRadioButton = null;

    public GenRadioButtonField(String translations, String tag, String[] buttonTags) {
        super(translations, tag);
        Log.trace("Constructor()");
        int numberOfTags = buttonTags.length;
        ButtonGroup group = new ButtonGroup();
        this.jRadioButton = new JRadioButton[numberOfTags];
        for (int i = 0; i < numberOfTags; ++i) {
            this.jRadioButton[i] = new JRadioButton(buttonTags[i]);
            this.add(this.jRadioButton[i]);
            group.add(this.jRadioButton[i]);
        }
        this.jRadioButton[0].setSelected(true);
        this.translatableTags = buttonTags;
        this.layoutComponent();
    }

    public GenRadioButtonField(String tag, String[] buttonTags) {
        super(tag);
        Log.trace("GenRadioButtonField()");
        int numberOfTags = buttonTags.length;
        ButtonGroup group = new ButtonGroup();
        this.jRadioButton = new JRadioButton[numberOfTags];
        for (int i = 0; i < numberOfTags; ++i) {
            this.jRadioButton[i] = new JRadioButton(buttonTags[i]);
            this.add(this.jRadioButton[i]);
            group.add(this.jRadioButton[i]);
        }
        this.jRadioButton[0].setSelected(true);
        this.translatableTags = buttonTags;
    }

    public void setEditable(boolean set) {
        Log.trace("setEditable()");
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            this.jRadioButton[i].setEnabled(set);
        }
    }

    public void setEnabled(boolean set) {
        Log.trace("setEnabled()");
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            this.jRadioButton[i].setEnabled(set);
        }
        this.getLabel().setEnabled(set);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        for (int i = 0; i < this.jRadioButton.length; ++i) {
            if (aListener != null) {
                this.jRadioButton[i].addActionListener(aListener);
            }
            this.jRadioButton[i].setActionCommand(aCommand);
        }
    }

    public void setValue(String buttonTag) throws SyntaxException {
        Log.trace("setValue()");
        boolean buttonNotDefined = true;
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.translatableTags[i].equals(buttonTag)) continue;
            buttonNotDefined = false;
            this.jRadioButton[i].setSelected(true);
        }
        if (buttonNotDefined) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        boolean noButtonSelected = true;
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.jRadioButton[i].isSelected()) continue;
            noButtonSelected = false;
            return this.translatableTags[i];
        }
        return null;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.jRadioButton;
    }

    public void setToolTip(String bundle, String tag) {
        Log.trace("setToolTip(" + tag + ")");
        this.toolTipBundle = bundle;
        this.toolTipTag = tag;
        if (this.myLocale != null) {
            this.translateTooltip(this.myLocale);
        }
    }

    public void setToolTip(String bundle, String tag, String additionalText) {
        Log.trace("setToolTip(" + tag + ")");
        this.toolTipAddition = additionalText;
        if (null == tag) {
            for (int j = 0; j < this.jRadioButton.length; ++j) {
                this.jRadioButton[j].setToolTipText(this.toolTipAddition);
            }
        } else {
            this.setToolTip(bundle, tag);
        }
    }

    void translateTooltip(Locale locale) {
        if (this.toolTipBundle != null) {
            ResourceBundle ttBundle = GuilibResourceBundle.getBundle(this.toolTipBundle, locale, this.getClass().getClassLoader());
            if (this.toolTipTag != null) {
                for (int j = 0; j < this.jRadioButton.length; ++j) {
                    try {
                        this.jRadioButton[j].setToolTipText(ttBundle.getString(this.toolTipTag) + this.toolTipAddition);
                        continue;
                    }
                    catch (MissingResourceException mre) {
                        this.jRadioButton[j].setToolTipText(this.toolTipTag + this.toolTipAddition);
                    }
                }
            }
        }
    }

    public void setToolTip(String tag) {
        Log.trace("setToolTip(" + tag + ")");
        for (int j = 0; j < this.jRadioButton.length; ++j) {
            this.jRadioButton[j].setToolTipText(tag);
        }
    }

    public void updateLocale(Locale locale) {
        Log.traceFlow();
        super.updateLocale(locale);
        for (int i = 0; i < this.translatableTags.length; ++i) {
            this.jRadioButton[i].setText(this.translateString(this.translatableTags[i]));
        }
        this.translateTooltip(locale);
    }
}

