/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractComponent;
import se.ericsson.cello.support.gui.guilib.infra.AbstractComponentController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ComponentPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ComponentSniffer;
import se.ericsson.cello.support.gui.guilib.infra.DialogModalPresenter;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.HelpManager;
import se.ericsson.cello.support.gui.guilib.infra.LanguageManager;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.cello.support.gui.guilib.infra.Resources;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.WizardModalPresenter;

abstract class AbstractPresenter {
    private static Vector disabledComponents = new Vector();
    private static DisableMouseListener disableMouseListener = new DisableMouseListener();
    private AbstractPresenter parentPresenter;
    private AbstractApplication application;
    private boolean visible = true;
    private boolean enabled = true;
    private Class viewClass;
    private Class controllerClass;
    private Object creationParameter = null;
    private AbstractView view;
    private AbstractController controller;
    private ComponentSniffer sniffer;
    private LanguageManager languageManager;
    private HelpManager helpManager;
    private Vector childPresenters = new Vector();
    private ViewContainer viewContainer;
    private String title;
    private String titleKey;
    private Object[] titleArgs;
    private String status;
    private String statusKey;
    private Object[] statusArgs;
    private Vector localeChangeListeners = new Vector();
    private boolean beenVisible;
    private static final String PROPERTY_ADDRESS = "address";
    private boolean isDisposed = false;
    private static String prefix = "";

    static AbstractPresenter createPresenter(AbstractPresenter parentPresenter, AbstractApplication application, Class presenterClass, Class viewClass, Class controllerClass, Object creationParameter) {
        AbstractPresenter presenter = null;
        try {
            presenter = (AbstractPresenter)presenterClass.newInstance();
            Log.logNotify("Presenter created: " + presenter + " Parent presenter: " + parentPresenter);
            if (parentPresenter != null) {
                parentPresenter.addChildPresenter(presenter);
            }
            presenter.init(parentPresenter, application, viewClass, controllerClass, creationParameter);
        }
        catch (Throwable t) {
            String msg = "Could not create presenter: " + presenterClass;
            Log.logError(msg, t);
            if (parentPresenter != null && presenter != null) {
                parentPresenter.removeChildPresenter(presenter);
            }
            Log.assertion(false, msg);
        }
        return presenter;
    }

    AbstractPresenter() {
    }

    abstract void init();

    abstract ViewContainer createViewContainer();

    void setLocation(int x, int y) {
        this.viewContainer.setLocation(x, y);
    }

    Point getLocation() {
        return ((Component)((Object)this.viewContainer)).getLocation();
    }

    void addChildPresenter(AbstractPresenter presenter) {
        this.childPresenters.addElement(presenter);
        Log.logNotify("Child presenter added: (" + this.childPresenters.size() + ") " + presenter);
    }

    private void addDisabledComponent(Component component) {
        disabledComponents.add(component);
    }

    void addLocaleChangeListener(LocaleChangeListener listener) {
        if (this.localeChangeListeners.indexOf(listener) != -1) {
            Log.logWarning("Language listener already added " + listener.getClass());
            return;
        }
        this.localeChangeListeners.addElement(listener);
    }

    boolean canStop() {
        return this.canStopChildPresenters() && this.controller.canStop();
    }

    private boolean canStopChildPresenters() {
        boolean canStop = true;
        Enumeration enume = this.childPresenters.elements();
        while (enume.hasMoreElements()) {
            if (((AbstractPresenter)enume.nextElement()).canStop()) continue;
            canStop = false;
            break;
        }
        return canStop;
    }

    AbstractHandler createHandler(Class className) {
        AbstractHandler handler = null;
        try {
            handler = (AbstractHandler)className.newInstance();
            handler.init(this);
            handler.init();
        }
        catch (Throwable t) {
            String msg = "Could not create handler: " + className;
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return handler;
    }

    AbstractController createController(Class controllerClass) {
        AbstractController controller = null;
        try {
            controller = (AbstractController)controllerClass.newInstance();
            controller.init(this);
        }
        catch (Throwable t) {
            String msg = "Could not create controller: " + controllerClass;
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return controller;
    }

    AbstractView createView(Class viewClass) {
        AbstractView view = null;
        try {
            view = (AbstractView)viewClass.newInstance();
            view.init(this);
        }
        catch (Throwable t) {
            String msg = "Could not create view: " + viewClass;
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return view;
    }

    void dispose() {
        if (this.sniffer != null) {
            this.sniffer.dispose();
            this.sniffer = null;
        }
        this.localeChangeListeners.clear();
        if (this.viewContainer != null) {
            Component component = this.viewContainer.getComponent();
            if (component instanceof RootPaneContainer) {
                JComponent Pane = (JComponent)((RootPaneContainer)((Object)component)).getGlassPane();
                Pane.removeMouseListener(disableMouseListener);
            }
            this.viewContainer.dispose();
            this.viewContainer = null;
        }
        if (this.view != null) {
            this.view.dispose();
        }
        this.view = null;
        if (this.controller != null) {
            this.controller.dispose();
        }
        this.controller = null;
        if (this.languageManager != null) {
            this.languageManager.dispose();
        }
        this.languageManager = null;
        disableMouseListener = null;
        this.helpManager = null;
        this.parentPresenter = null;
        this.application = null;
    }

    AbstractApplication getApplication() {
        return this.application;
    }

    Vector getChildPresenters() {
        return (Vector)this.childPresenters.clone();
    }

    Class getClassForName(String className) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        }
        catch (Throwable t) {
            String msg = "Could not create class: " + className;
            Log.logError(msg, t);
            Log.assertion(false, msg);
        }
        return aClass;
    }

    ComponentSniffer getComponentSniffer() {
        return this.sniffer;
    }

    AbstractController getController() {
        return this.controller;
    }

    Class getControllerClass() {
        return this.controllerClass;
    }

    Object getCreationParameter() {
        return this.creationParameter;
    }

    AbstractHelp getHelp() {
        return this.helpManager.getHelpHandler();
    }

    LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    Object getParameter(String key) {
        if (this.controller instanceof AbstractComponentController) {
            return null;
        }
        Object value = null;
        if (this.creationParameter instanceof JApplet) {
            value = ((JApplet)this.creationParameter).getParameter(key);
        } else {
            Object[][] parameters = (Object[][])this.creationParameter;
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    try {
                        if (key.equals((String)parameters[i][0])) {
                            value = parameters[i][1];
                            return value;
                        }
                        continue;
                    }
                    catch (ClassCastException cce) {
                        String msg = "Parameter key not instance of java.lang.String";
                        Log.logError(msg, cce);
                        Log.assertion(false, msg);
                    }
                }
            }
        }
        return value;
    }

    AbstractPresenter getParentPresenter() {
        return this.parentPresenter;
    }

    AbstractPresenter getResourcePresenter() {
        if (this instanceof ComponentPresenter || this instanceof ApplicationPresenter) {
            return this;
        }
        AbstractPresenter parent = this.getParentPresenter();
        while (!(parent instanceof ComponentPresenter) && !(parent instanceof ApplicationPresenter)) {
            parent = parent.getParentPresenter();
        }
        return parent;
    }

    Resources getResources() {
        return this.getApplication();
    }

    String getStatus() {
        return this.status;
    }

    private String getString(String key, boolean strip) {
        String str = "";
        if (this.languageManager != null) {
            str = this.languageManager.getString(key, strip);
        }
        return str;
    }

    String getTitle() {
        return this.title;
    }

    AbstractView getView() {
        return this.view;
    }

    Class getViewClass() {
        return this.viewClass;
    }

    ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    private void init(AbstractPresenter parentPresenter, AbstractApplication application, Class viewClass, Class controllerClass, Object creationParameter) {
        this.parentPresenter = parentPresenter;
        this.application = application;
        this.viewClass = viewClass;
        this.controllerClass = controllerClass;
        this.creationParameter = creationParameter;
        if (creationParameter instanceof AbstractComponent) {
            ((ComponentPresenter)this).setComponent((AbstractComponent)creationParameter);
        }
        this.viewContainer = this.createViewContainer();
        this.view = this.createView(viewClass);
        this.controller = this.createController(controllerClass);
        this.sniffer = new ComponentSniffer(this);
        this.languageManager = (LanguageManager)this.createHandler(LanguageManager.class);
        this.sniffer.addComponentHandler(this.languageManager);
        String helpClass = application.getEnvironment().getProperty("gsl.help.helphandler.class");
        if (helpClass != null && !helpClass.equals("")) {
            this.helpManager = (HelpManager)this.createHandler(HelpManager.class);
            this.sniffer.addComponentHandler(this.helpManager);
        }
        this.init();
        if (!this.isDisposed) {
            this.sniffer.sniff();
            this.updateLocale(application.getLocale());
            this.sniffer.updateLocale(application.getLocale());
            this.updateLocaleTitleAndStatus(application.getLocale());
        }
    }

    final void setIsDisposed(boolean isDisposed) {
        this.isDisposed = isDisposed;
    }

    final boolean isDisposed() {
        return this.isDisposed;
    }

    boolean isDefaultEnabling() {
        return false;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private boolean isModal() {
        return this instanceof DialogModalPresenter || this instanceof WizardModalPresenter;
    }

    boolean isVisible() {
        return this.visible;
    }

    void removeChildPresenter(AbstractPresenter presenter) {
        Log.logNotify("Child presenter removed (" + this.childPresenters.size() + ") " + presenter);
        Log.assertion(this.childPresenters.removeElement(presenter), "Could not remove child presenter: " + presenter);
    }

    private void removeDisabledComponent(Component component) {
        Log.assertion(disabledComponents.remove(component), "Disabled component could not be removed: " + component);
    }

    void removeLocaleChangeListener(LocaleChangeListener listener) {
        for (int i = 0; i < this.localeChangeListeners.size(); ++i) {
            if (listener != this.localeChangeListeners.elementAt(i)) continue;
            this.localeChangeListeners.remove(i);
            return;
        }
    }

    void setController(AbstractController controller) {
        this.controller = controller;
    }

    void setEnabled(boolean enabled, boolean iterateChildren) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (this.isDefaultEnabling()) {
                this.setEnabledDefault(enabled);
            } else {
                this.setEnabledCustom(enabled);
            }
        }
        if (iterateChildren) {
            Enumeration enume = this.childPresenters.elements();
            while (enume.hasMoreElements()) {
                ((AbstractPresenter)enume.nextElement()).setEnabled(enabled, true);
            }
        }
    }

    void setEnabledDefault(boolean enabled) {
        if (!enabled) {
            this.setCursor(Application.WAIT_CURSOR, false);
        }
        if (this.viewContainer != null) {
            this.viewContainer.setEnabled(enabled);
        }
        if (enabled) {
            this.setCursor(Application.DEFAULT_CURSOR, false);
        }
    }

    void setEnabledCustom(boolean enabled) {
        if (!enabled) {
            this.setCursor(Application.WAIT_CURSOR, false);
        }
        if (this.viewContainer != null) {
            Component component = this.viewContainer.getComponent();
            if (component instanceof RootPaneContainer) {
                JComponent glassPane = (JComponent)((RootPaneContainer)((Object)component)).getGlassPane();
                if (enabled) {
                    this.removeDisabledComponent(component);
                    glassPane.removeMouseListener(disableMouseListener);
                } else {
                    this.addDisabledComponent(component);
                    glassPane.addMouseListener(disableMouseListener);
                }
                glassPane.setVisible(!enabled);
            } else if (component != null) {
                component.setEnabled(enabled);
            }
        }
        if (enabled) {
            this.setCursor(Application.DEFAULT_CURSOR, false);
        }
    }

    void setCursor(Cursor cursor, boolean iterateChildren) {
        if (this.viewContainer != null) {
            this.viewContainer.getComponent().setCursor(cursor);
        }
        if (iterateChildren) {
            Enumeration enume = this.childPresenters.elements();
            while (enume.hasMoreElements()) {
                ((AbstractPresenter)enume.nextElement()).setCursor(cursor, true);
            }
        }
    }

    void setStatus(String statusString) {
        this.statusKey = null;
        this.statusArgs = null;
        this.status = statusString != null && !statusString.equals("") ? statusString : "";
        if (this.viewContainer != null) {
            this.viewContainer.setStatus(this.status);
        }
    }

    void setStatus(String statusKey, Object[] statusArgs) {
        this.statusKey = statusKey;
        this.statusArgs = statusArgs;
        if (statusKey != null && !statusKey.equals("")) {
            this.status = this.getString(statusKey, true);
            if (statusArgs != null) {
                this.status = MessageFormat.format(this.status, statusArgs);
            }
        } else {
            this.status = "";
        }
        if (this.viewContainer != null) {
            this.viewContainer.setStatus(this.status);
        }
    }

    void setTitle(String titleKey, Object[] titleArgs) {
        if ("true".equalsIgnoreCase(EmasSystemProperties.getProperty("application launched")) || "true".equalsIgnoreCase(EmasSystemProperties.getProperty("wizard launched"))) {
            String manager_title = EmasSystemProperties.getProperty("MANAGER_TITLE", "Element Manager");
            this.titleKey = titleKey;
            this.titleArgs = titleArgs;
            String formattedTitle = null;
            this.title = EmasSystemProperties.getProperty(PROPERTY_ADDRESS, "") + " - " + manager_title;
            if (titleKey != null && !titleKey.equals("")) {
                formattedTitle = this.getString(titleKey, true);
                if (titleArgs != null) {
                    formattedTitle = MessageFormat.format(formattedTitle, titleArgs);
                }
                this.title = this.title + " - " + formattedTitle;
            }
            if (this.viewContainer != null) {
                this.viewContainer.setTitle(this.title);
            }
        } else {
            this.titleKey = titleKey;
            this.titleArgs = titleArgs;
            if (titleKey != null && !titleKey.equals("")) {
                this.title = this.getString(titleKey, true);
                if (titleArgs != null) {
                    this.title = MessageFormat.format(this.title, titleArgs);
                }
            } else {
                this.title = "";
            }
            if (this.viewContainer != null) {
                this.viewContainer.setTitle(prefix + this.title);
            }
        }
    }

    public void setPrefix(Object newPrefix) {
        prefix = newPrefix.toString() + " - ";
    }

    void setVisible(boolean visible, boolean beenVisible) {
        this.beenVisible = beenVisible;
        this.setVisible(visible);
    }

    void setVisible(boolean visible) {
        this.visible = visible;
        if (!this.beenVisible && visible) {
            this.controller.beforeVisible();
            if (this.isDisposed()) {
                return;
            }
        }
        if (this.viewContainer != null) {
            this.viewContainer.setVisible(visible);
        }
        if (!this.isModal() && !this.beenVisible && visible) {
            this.controller.afterVisible();
            if (this.isDisposed()) {
                return;
            }
        }
        if (!this.beenVisible && visible) {
            this.beenVisible = true;
        }
        Enumeration enume = this.childPresenters.elements();
        while (enume.hasMoreElements()) {
            AbstractPresenter presenter = (AbstractPresenter)enume.nextElement();
            presenter.setVisible(visible);
        }
    }

    void bringToFront() {
        if (this.viewContainer != null) {
            this.viewContainer.bringToFront();
        }
    }

    void setView(AbstractView view) {
        this.view = view;
    }

    void setViewContainer(ViewContainer viewContainer) {
        this.viewContainer = viewContainer;
    }

    synchronized void stop() {
        if (this.parentPresenter != null) {
            this.parentPresenter.stopChildPresenter(this);
        } else if (this.canStop()) {
            this.stopNoCheck();
        }
    }

    synchronized void stopNoCheck() {
        if (this.parentPresenter != null) {
            this.parentPresenter.stopChildPresenterNoCheck(this);
        } else {
            this.stopThisNoCheck();
        }
    }

    synchronized void stopChildPresenter(AbstractPresenter presenter) {
        if (presenter.canStop()) {
            this.stopChildPresenterNoCheck(presenter);
        }
    }

    synchronized void stopChildPresenterNoCheck(AbstractPresenter presenter) {
        this.removeChildPresenter(presenter);
        presenter.setVisible(false);
        presenter.stopThisNoCheck();
        presenter.dispose();
    }

    private void stopThisNoCheck() {
        Enumeration enume = ((Vector)this.childPresenters.clone()).elements();
        while (enume.hasMoreElements()) {
            this.stopChildPresenterNoCheck((AbstractPresenter)enume.nextElement());
        }
        if (this.controller != null) {
            this.controller.stop();
        }
    }

    private void updateChildPresenters(Locale locale) {
        Enumeration enume = this.childPresenters.elements();
        while (enume.hasMoreElements()) {
            ((AbstractPresenter)enume.nextElement()).updateLocale(locale);
        }
    }

    private void updateLocaleListeners(Locale locale) {
        for (int i = 0; i < this.localeChangeListeners.size(); ++i) {
            ((LocaleChangeListener)this.localeChangeListeners.elementAt(i)).updateLocale(locale);
        }
    }

    void updateLocale(Locale locale) {
        this.sniffer.updateLocale(locale);
        this.updateLocaleTitleAndStatus(locale);
        this.updateLocaleListeners(locale);
        this.updateChildPresenters(locale);
        if (this.viewContainer != null) {
            this.viewContainer.doValidate();
        }
    }

    private void updateLocaleTitleAndStatus(Locale locale) {
        this.setTitle(this.titleKey, this.titleArgs);
        this.setStatus(this.statusKey, this.statusArgs);
    }

    protected void updateTitle() {
        Log.trace("Updating title...");
        this.setTitle(this.titleKey, this.titleArgs);
        Enumeration enume = this.childPresenters.elements();
        while (enume.hasMoreElements()) {
            ((AbstractPresenter)enume.nextElement()).updateTitle();
        }
    }

    void updateLookAndFeel() {
        if (this.viewContainer != null) {
            ComponentToolkit.updateLookAndFeel(this.viewContainer.getComponent());
        }
        Enumeration enume = this.childPresenters.elements();
        while (enume.hasMoreElements()) {
            ((AbstractPresenter)enume.nextElement()).updateLookAndFeel();
        }
    }

    private static class DisableMouseListener
    implements MouseListener {
        private DisableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Toolkit.getDefaultToolkit().beep();
            e.consume();
        }

        public void mouseEntered(MouseEvent e) {
            e.consume();
        }

        public void mouseExited(MouseEvent e) {
            e.consume();
        }

        public void mousePressed(MouseEvent e) {
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            e.consume();
        }
    }
}

