/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.applet.Applet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.comp.Log;

class CorbaNameResolver {
    private static final String NAME_SERVICE_IOR = "gsl.namingserviceiorfilename";
    private JApplet applet;
    private Properties env;
    private ORB orb;
    private NamingContext initialNamingContext;

    CorbaNameResolver(JApplet applet, Properties env, ORB orb) {
        this.applet = applet;
        this.env = env;
        this.orb = orb;
    }

    ORB initORB() {
        if (this.orb == null) {
            Log.logNotify("Init ORB");
            Log.measure("orb", true, "Init orb");
            this.orb = this.applet != null ? ORB.init((Applet)this.applet, (Properties)this.env) : ORB.init((String[])new String[0], (Properties)this.env);
            Log.measure("orb", false);
            Log.logNotify("ORB Class: " + this.orb.getClass().getName());
            CorbaNameResolver corbaNameResolver = this;
            Log.logNotify("ORB SingeltonClass: " + corbaNameResolver.orb.init().getClass().getName());
        }
        return this.orb;
    }

    NamingContext resolveInitialReference() throws Exception {
        String nameServiceIOR = this.env.getProperty(NAME_SERVICE_IOR);
        nameServiceIOR = nameServiceIOR != null ? nameServiceIOR : "ior/NameService.ior";
        return this.resolveInitialReferenceUseIOR(nameServiceIOR);
    }

    NamingContext resolveInitialReferenceDefault() throws Exception {
        if (this.initialNamingContext == null) {
            this.initORB();
            Log.measure("ns", true, "Resolve initial reference");
            Object objRef = this.orb.resolve_initial_references("NameService");
            Log.logNotify("NameService resolved Object: " + objRef);
            this.initialNamingContext = NamingContextHelper.narrow((Object)objRef);
            Log.logNotify("NameService narrowed NamingContext: " + this.initialNamingContext);
            Log.measure("ns", false);
        }
        return this.initialNamingContext;
    }

    NamingContext resolveInitialReferenceUseIOR(String nameServiceIOR) throws Exception {
        if (this.initialNamingContext == null) {
            return EmasFramework.getNamingServiceRoot();
        }
        return this.initialNamingContext;
    }

    Object serviceResolve(String serviceName) throws Exception {
        Object objRef = null;
        StringTokenizer st = new StringTokenizer(serviceName, ".", false);
        int length = st.countTokens();
        NameComponent[] name = new NameComponent[length];
        for (int i = 0; i < length; ++i) {
            String tokenName = st.nextToken();
            name[i] = new NameComponent(tokenName, "");
        }
        objRef = this.resolveInitialReference().resolve(name);
        return objRef;
    }
}

