/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.text.JTextComponent;

class EditListeners {
    private EditKeyListener editKeyListener = new EditKeyListener();
    private EditMouseListener editMouseListener = new EditMouseListener();
    private CompFocusListener compFocusListener = new CompFocusListener();
    private JTextComponent comp = null;
    private Action cutAction = null;
    private Action copyAction = null;
    private Action pasteAction = null;

    EditListeners(Action[] editActions, JTextComponent component) {
        this.cutAction = editActions[0];
        this.copyAction = editActions[1];
        this.pasteAction = editActions[2];
        this.comp = component;
        this.comp.addKeyListener(this.editKeyListener);
        this.comp.addMouseListener(this.editMouseListener);
        this.comp.addFocusListener(this.compFocusListener);
    }

    private void setCutCopyEnabled() {
        String selectedText = "";
        selectedText = this.comp.getSelectedText();
        boolean compEditable = this.comp.isEditable();
        if (compEditable && selectedText != null && !selectedText.equals("")) {
            this.copyAction.setEnabled(true);
            this.cutAction.setEnabled(true);
            return;
        }
        if (!compEditable && selectedText != null && !selectedText.equals("")) {
            this.copyAction.setEnabled(true);
            this.cutAction.setEnabled(false);
            return;
        }
        this.copyAction.setEnabled(false);
        this.cutAction.setEnabled(false);
    }

    private void setPasteEnabled() {
        if (this.comp.isEditable()) {
            this.pasteAction.setEnabled(true);
        } else {
            this.pasteAction.setEnabled(false);
        }
    }

    private class CompFocusListener
    implements FocusListener {
        private CompFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                EditListeners.this.copyAction.setEnabled(false);
                EditListeners.this.cutAction.setEnabled(false);
                EditListeners.this.pasteAction.setEnabled(false);
            }
        }

        public void focusGained(FocusEvent e) {
            EditListeners.this.setCutCopyEnabled();
            EditListeners.this.setPasteEnabled();
        }
    }

    private class EditMouseListener
    extends MouseAdapter {
        private EditMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            EditListeners.this.setCutCopyEnabled();
            EditListeners.this.setPasteEnabled();
        }

        public void mouseClicked(MouseEvent e) {
            EditListeners.this.setCutCopyEnabled();
            EditListeners.this.setPasteEnabled();
        }
    }

    private class EditKeyListener
    extends KeyAdapter {
        private EditKeyListener() {
        }

        public void keyReleased(KeyEvent ke) {
            EditListeners.this.setCutCopyEnabled();
            EditListeners.this.setPasteEnabled();
        }
    }
}

