/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import sun.misc.SoftCache;

public abstract class GuilibResourceBundle {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Hashtable underConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEFAULT_NOT_FOUND = new Integer(-1);
    private static SoftCache cacheList = new SoftCache(25, 1.0f);
    protected ResourceBundle parent = null;
    private Locale locale = null;

    private void setLocale(String baseName, String bundleName) {
        if (baseName.length() == bundleName.length()) {
            this.locale = new Locale("", "");
        } else if (baseName.length() < bundleName.length()) {
            int pos = baseName.length();
            String temp = bundleName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                this.locale = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            this.locale = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    public static ResourceBundle getBundle(String baseName, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(baseName, Locale.getDefault(), loader);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            throw new NullPointerException();
        }
        return GuilibResourceBundle.getBundleImpl(baseName, locale, loader);
    }

    private static ResourceBundle getBundleImpl(String baseName, Locale locale, ClassLoader loader) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        Object NOTFOUND = loader != null ? loader : DEFAULT_NOT_FOUND;
        String bundleName = baseName;
        String localeSuffix = locale.toString();
        if (localeSuffix.length() > 0) {
            bundleName = bundleName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            bundleName = bundleName + "___" + locale.getVariant();
        }
        Object lookup = GuilibResourceBundle.findBundleInCache(loader, bundleName);
        if (lookup == NOTFOUND) {
            GuilibResourceBundle.throwMissingResourceException(baseName, locale);
        } else if (lookup != null) {
            return (ResourceBundle)lookup;
        }
        Object parent = NOTFOUND;
        try {
            boolean foundInMainBranch;
            Object root = GuilibResourceBundle.findBundle(loader, baseName, baseName, null, NOTFOUND);
            if (root == null) {
                GuilibResourceBundle.putBundleInCache(loader, baseName, NOTFOUND);
                root = NOTFOUND;
            }
            Vector names = GuilibResourceBundle.calculateBundleNames(baseName, locale);
            boolean bl = foundInMainBranch = root != NOTFOUND && names.size() == 0;
            if (!foundInMainBranch) {
                parent = root;
                for (int i = names.size(); i > 0; --i) {
                    bundleName = (String)names.elementAt(i - 1);
                    lookup = GuilibResourceBundle.findBundle(loader, bundleName, baseName, parent, NOTFOUND);
                    if (lookup == null) continue;
                    parent = lookup;
                    foundInMainBranch = true;
                    break;
                }
            }
            parent = root;
            if (!foundInMainBranch) {
                Vector fallbackNames = GuilibResourceBundle.calculateBundleNames(baseName, Locale.getDefault());
                for (int i = 0; i < fallbackNames.size() && !names.contains(bundleName = (String)fallbackNames.elementAt(i)); ++i) {
                    lookup = GuilibResourceBundle.findBundle(loader, bundleName, baseName, parent, NOTFOUND);
                    if (lookup != null) {
                        parent = lookup;
                        continue;
                    }
                    GuilibResourceBundle.putBundleInCache(loader, bundleName, parent);
                }
            }
            parent = GuilibResourceBundle.propagate(loader, names, parent);
        }
        catch (Exception e) {
            GuilibResourceBundle.cleanUpConstructionList();
            GuilibResourceBundle.throwMissingResourceException(baseName, locale);
        }
        catch (Error e) {
            GuilibResourceBundle.cleanUpConstructionList();
            throw e;
        }
        if (parent == NOTFOUND) {
            GuilibResourceBundle.throwMissingResourceException(baseName, locale);
        }
        Log.logNotify(bundleName + " has been loaded");
        return (ResourceBundle)parent;
    }

    private static Object propagate(ClassLoader loader, Vector names, Object parent) {
        for (int i = 0; i < names.size(); ++i) {
            String bundleName = (String)names.elementAt(i);
            Object lookup = GuilibResourceBundle.findBundleInCache(loader, bundleName);
            if (lookup == null) {
                GuilibResourceBundle.putBundleInCache(loader, bundleName, parent);
                continue;
            }
            parent = lookup;
        }
        return parent;
    }

    private static void throwMissingResourceException(String baseName, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            Collection entries = underConstruction.values();
            Thread thisThread = Thread.currentThread();
            while (entries.remove(thisThread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader loader, String bundleName, String baseName, Object parent, Object NOTFOUND) {
        Object result;
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            boolean beingBuilt;
            cacheKey.setKeyValues(loader, bundleName);
            result = cacheList.get((Object)cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            Thread builder = (Thread)underConstruction.get(cacheKey);
            boolean bl = beingBuilt = builder != null && builder != Thread.currentThread();
            if (beingBuilt) {
                while (beingBuilt) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(loader, bundleName);
                    beingBuilt = underConstruction.containsKey(cacheKey);
                }
                result = cacheList.get((Object)cacheKey);
                if (result != null) {
                    cacheKey.clear();
                    return result;
                }
            }
            Object key = cacheKey.clone();
            underConstruction.put(key, Thread.currentThread());
            cacheKey.clear();
        }
        result = GuilibResourceBundle.loadBundle(loader, bundleName);
        if (result != null) {
            boolean constructing;
            SoftCache softCache2 = cacheList;
            synchronized (softCache2) {
                cacheKey.setKeyValues(loader, bundleName);
                constructing = underConstruction.get(cacheKey) == Thread.currentThread();
                cacheKey.clear();
            }
            if (constructing) {
                GuilibResourceBundle.putBundleInCache(loader, bundleName, result);
            }
        }
        return result;
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        result.addElement(temp.toString());
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        result.addElement(temp.toString());
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader loader, String bundleName) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, bundleName);
            Object result = cacheList.get((Object)cacheKey);
            cacheKey.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader loader, String bundleName, Object value) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, bundleName);
            cacheList.put(cacheKey.clone(), value);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadBundle(final ClassLoader loader, String bundleName) {
        final String resName = bundleName.replace('.', '/') + ".properties";
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            }
        });
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(stream);
                return propertyResourceBundle;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        try {
            Class<?> bundleClass = loader != null ? loader.loadClass(bundleName) : Class.forName(bundleName);
            if (ResourceBundle.class.isAssignableFrom(bundleClass)) {
                Object myBundle = bundleClass.newInstance();
                Object otherBundle = GuilibResourceBundle.findBundleInCache(loader, bundleName);
                if (otherBundle != null) {
                    return otherBundle;
                }
                return myBundle;
            }
        }
        catch (Exception e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        return null;
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                boolean hasLoaderRef;
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                boolean bl = hasLoaderRef = this.loaderRef != null;
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader loader, String searchName) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            if (loader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(loader);
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "");
        }
    }
}

