/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import javax.swing.JComponent;
import javax.swing.JMenu;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationDefaultController;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationDefaultView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;

class MenuToolbarHandler {
    private ApplicationToolBar applicationToolBar = null;
    private ApplicationMenuBar applicationMenuBar = null;
    private ApplicationDefaultView menuView = null;
    private ApplicationDefaultController menuController = null;
    private ApplicationPresenter presenter = null;

    MenuToolbarHandler() {
    }

    void init(ApplicationPresenter presenter) {
        this.presenter = presenter;
        this.menuView = (ApplicationDefaultView)presenter.createView(ApplicationDefaultView.class);
        this.menuView.init();
        this.menuController = (ApplicationDefaultController)presenter.createController(ApplicationDefaultController.class);
        this.menuController.init();
        this.createMenuBar();
        this.createToolBar();
    }

    void dispose() {
        if (this.applicationToolBar != null) {
            this.applicationToolBar.dispose();
        }
        this.applicationToolBar = null;
        if (this.applicationMenuBar != null) {
            this.applicationMenuBar.dispose();
        }
        this.applicationMenuBar = null;
        if (this.menuView != null) {
            this.menuView.dispose();
        }
        this.menuView = null;
        if (this.menuController != null) {
            this.menuController.stop();
        }
        if (this.menuController != null) {
            this.menuController.dispose();
        }
        this.menuController = null;
        this.presenter = null;
    }

    void changeMenuBar() {
        this.createMenuBar();
        this.presenter.getComponentSniffer().sniff(this.applicationMenuBar);
        this.presenter.updateLocale(this.presenter.getApplication().getLocale());
        ComponentToolkit.updateLookAndFeel(this.applicationMenuBar);
    }

    void changeToolBar() {
        this.createToolBar();
        ComponentToolkit.updateLookAndFeel(this.applicationMenuBar);
    }

    private void createMenuBar() {
        this.applicationMenuBar = null;
        if (((AbstractApplicationView)this.presenter.getView()).getMenus() != null) {
            this.applicationMenuBar = new ApplicationMenuBar(this.menuView);
        }
    }

    private void createToolBar() {
        this.applicationToolBar = null;
        if (((AbstractApplicationView)this.presenter.getView()).getToolBarComponents() != null) {
            this.applicationToolBar = new ApplicationToolBar(this.menuView);
        }
    }

    void setMenusVisible(JMenu[] menus, boolean visible) {
        if (this.applicationMenuBar != null) {
            this.applicationMenuBar.setMenusVisible(menus, visible);
            this.presenter.getViewContainer().doValidate();
        }
    }

    void setToolBarCompsVisible(JComponent[] comps, boolean visible) {
        if (this.applicationToolBar != null) {
            this.applicationToolBar.setComponentsVisible(comps, visible);
            this.presenter.getViewContainer().doValidate();
        }
    }

    void updateLookAndFeel() {
        if (this.applicationMenuBar != null) {
            ComponentToolkit.updateLookAndFeel(this.applicationMenuBar);
        }
        if (this.applicationToolBar != null) {
            ComponentToolkit.updateLookAndFeel(this.applicationToolBar);
        }
    }

    ApplicationMenuBar getApplicationMenuBar() {
        return this.applicationMenuBar;
    }

    ApplicationToolBar getApplicationToolBar() {
        return this.applicationToolBar;
    }

    ApplicationDefaultView getApplicationDefaultView() {
        return this.menuView;
    }
}

