/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.security.Principal;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.security.corba.Current;
import se.ericsson.security.corba.ORBInit;

class SecurityHandler {
    private ApplicationManager applicationManager;
    private ORB myOrb;
    private String username;

    SecurityHandler(ApplicationManager applicationManager) throws InvalidName {
        this.applicationManager = applicationManager;
        Properties properties = ORBInit.getOrbProperties();
        this.myOrb = ORB.init((String[])new String[0], (Properties)properties);
        this.username = "user";
        try {
            this.username = System.getProperties().getProperty("user.name");
        }
        catch (Exception x) {
            System.out.println("Unable to get system property user.name:" + x.getMessage());
        }
        try {
            Current current = (Current)this.myOrb.resolve_initial_references("OMSecSecurityCurrent");
            try {
                Principal originator = current.getDelegatedPrincipal();
                if (originator == null && (originator = current.getConnectionPrincipal()) == null) {
                    originator = current.getLocalPrincipal();
                }
                String u = current.getUniqueID(originator);
                System.out.println("logged-in user name=" + u);
                if (u != null && !u.equals("")) {
                    this.username = u;
                }
            }
            catch (Exception x) {
                System.out.println("OMSec Security: " + x.getMessage());
            }
        }
        catch (Exception y) {
            System.out.println("Starting with Security switched OFF: " + y.getMessage());
        }
    }

    void dispose() {
        this.applicationManager = null;
    }

    ORB getOrb() {
        return this.myOrb;
    }

    String getUserId() {
        return this.username;
    }
}

