/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;

public class Logger {
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager = LogManager.getLogManager();
    private String name;
    private Level levelObject;
    private int levelValue;
    private ArrayList handlers;
    private String resourceBundleName;
    private ResourceBundle catalog;
    private boolean useGlobalHandlers = true;
    private Filter filter;
    private boolean anonymous;
    public static final Logger global = Logger.getLogger("global");

    protected Logger(String name, String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
        if (resourceBundleName != null) {
            this.catalog = ResourceBundle.getBundle(resourceBundleName);
        }
        this.name = name;
        this.levelObject = Level.ALL;
        this.levelValue = this.levelObject.intValue();
    }

    public static synchronized Logger getLogger(String name) {
        if (name.equals("")) {
            throw new IllegalArgumentException("need a logger name");
        }
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            manager.addLogger(new Logger(name, null));
            result = manager.getLogger(name);
            result.levelObject = manager.getLevel(name);
            result.levelValue = result.levelObject.intValue();
        }
        return result;
    }

    public static synchronized Logger getLogger(String name, String resourceBundleName) {
        if (name.equals("")) {
            throw new IllegalArgumentException("need a logger name");
        }
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            ResourceBundle.getBundle(resourceBundleName);
            manager.addLogger(new Logger(name, null));
            result = manager.getLogger(name);
            result.levelObject = manager.getLevel(name);
            result.levelValue = result.levelObject.intValue();
        }
        if (result.resourceBundleName == null) {
            result.catalog = ResourceBundle.getBundle(resourceBundleName);
            result.resourceBundleName = resourceBundleName;
        } else if (!result.resourceBundleName.equals(resourceBundleName)) {
            throw new IllegalArgumentException(result.resourceBundleName + " != " + resourceBundleName);
        }
        return result;
    }

    public static synchronized Logger getAnonymousLogger() {
        LogManager manager = LogManager.getLogManager();
        Logger result = new Logger(null, null);
        result.anonymous = true;
        result.setLevel(manager.getLevel(""));
        return result;
    }

    public static synchronized Logger getAnonymousLogger(String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger result = new Logger(null, null);
        result.anonymous = true;
        result.setLevel(manager.getLevel(""));
        result.resourceBundleName = resourceBundleName;
        result.catalog = ResourceBundle.getBundle(resourceBundleName);
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.catalog;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public synchronized void log(LogRecord record) {
        record.setLoggerName(this.name);
        record.setResourceBundle(this.catalog);
        record.setResourceBundleName(this.resourceBundleName);
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        if (this.filter != null && !this.filter.isLoggable(record)) {
            return;
        }
        if (this.useGlobalHandlers) {
            this.manager.publish(record);
        }
        if (this.handlers != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                Handler h = (Handler)this.handlers.get(i);
                h.publish(record);
            }
        }
    }

    public void log(Level level, String sourceClass, String sourceMethod, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.log(lr);
    }

    public void log(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.log(lr);
    }

    public void log(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.log(lr);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, sourceClass, sourceMethod, "ENTRY", params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{result};
        this.log(Level.FINER, sourceClass, sourceMethod, "RETURN", params);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, "THROW");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.log(lr);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, sourceClass, sourceMethod, msg, params);
    }

    public void severe(String sourceClass, String sourceMethod, String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, sourceClass, sourceMethod, msg);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, sourceClass, sourceMethod, msg, params);
    }

    public void warning(String sourceClass, String sourceMethod, String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, sourceClass, sourceMethod, msg);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, sourceClass, sourceMethod, msg, params);
    }

    public void info(String sourceClass, String sourceMethod, String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, sourceClass, sourceMethod, msg);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, sourceClass, sourceMethod, msg, params);
    }

    public void config(String sourceClass, String sourceMethod, String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, sourceClass, sourceMethod, msg);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, sourceClass, sourceMethod, msg, params);
    }

    public void fine(String sourceClass, String sourceMethod, String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, sourceClass, sourceMethod, msg);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void finer(String sourceClass, String sourceMethod, String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, sourceClass, sourceMethod, msg);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, sourceClass, sourceMethod, msg, params);
    }

    public void finest(String sourceClass, String sourceMethod, String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, sourceClass, sourceMethod, msg);
    }

    private void inferCaller(LogRecord r) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Exception("").printStackTrace(pw);
            pw.close();
            String trace = sw.toString();
            int ix = trace.lastIndexOf("java.util.logging.Logger");
            ix = trace.indexOf("(", ix) + 3;
            int end = trace.indexOf("(", ix);
            int dot = trace.lastIndexOf(".", end);
            int start = trace.lastIndexOf(" ", dot) + 1;
            r.setSourceClassName(trace.substring(start, dot));
            r.setSourceMethodName(trace.substring(dot + 1, end));
        }
        catch (Exception ex) {
            return;
        }
    }

    public void log(Level level, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        this.inferCaller(lr);
        this.log(lr);
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setParameters(params);
        this.inferCaller(lr);
        this.log(lr);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.inferCaller(lr);
        this.log(lr);
    }

    public void severe(String msg, Object[] params) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg, params);
    }

    public void severe(String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg, Object[] params) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg, params);
    }

    public void warning(String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void info(String msg, Object[] params) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg, params);
    }

    public void info(String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void config(String msg, Object[] params) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg, params);
    }

    public void config(String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg, Object[] params) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg, params);
    }

    public void fine(String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void finer(String msg, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg, params);
    }

    public void finer(String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finest(String msg, Object[] params) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg, params);
    }

    public void finest(String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.levelObject = newLevel;
        this.levelValue = this.levelObject.intValue();
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (this.handlers == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public synchronized Handler[] getHandlers() throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (this.handlers == null) {
            return new Handler[0];
        }
        Handler[] result = new Handler[this.handlers.size()];
        result = this.handlers.toArray(result);
        return result;
    }

    public void setUseGlobalHandlers(boolean useGlobalHandlers) {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.useGlobalHandlers = useGlobalHandlers;
    }

    public boolean getUseGlobalHandlers() {
        return this.useGlobalHandlers;
    }
}

