/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

class ElementMapping {
    private String elementTag;
    private String elementClass;
    private Vector moTypes = new Vector();
    private Properties properties;
    String[] tableHeadings;

    public ElementMapping(Properties properties, String elementTag, String elementClass, String[] moTypes) {
        this.properties = properties;
        this.elementTag = elementTag;
        this.elementClass = elementClass;
        for (int i = 0; i < moTypes.length; ++i) {
            this.addMoType(moTypes[i]);
        }
    }

    public void addMoType(String moType) {
        this.moTypes.add(moType);
    }

    public String getFirstMoType() {
        return (String)this.moTypes.firstElement();
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getElementClass() {
        return this.elementClass;
    }

    public MOComposite getMOC(MOProxy mo) {
        MOComposite moc = null;
        MOProxy parent = mo.getParent();
        Iterator i = this.moTypes.iterator();
        MOProxy current = mo;
        if (i.hasNext() && current.getType().equals(i.next())) {
            moc = new MOComposite();
            moc.add(current);
        }
        while (i.hasNext()) {
            MOProxy[] children = new MOProxy[]{};
            try {
                children = current.getChildren(1, (String)i.next(), "");
            }
            catch (CSException e) {
                return null;
            }
            if (children.length > 0) {
                current = children[0];
                moc.add(current);
                continue;
            }
            return null;
        }
        return moc;
    }

    public void setTableHeadings(String[] newTableHeadings) {
        this.tableHeadings = newTableHeadings;
    }

    public String[] getTableHeadings() {
        return this.tableHeadings;
    }
}

