/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy;

import BasicConfig.Filter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.MOName;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class MOProxyCache
implements CSFacade.Subscriber {
    private Map cachedMOs = new TreeMap();
    private Map cachedChildren = new TreeMap();
    private CSFacade cs;
    private static MOProxyCache instance;
    private static final int additionalScope;

    public void cleanup() {
        if (CSFacade.getInstance() != null) {
            this.cs.unsubscribe(this);
        }
        instance = null;
    }

    public static MOProxyCache getInstance() {
        if (instance == null) {
            instance = new MOProxyCache();
        }
        return instance;
    }

    private MOProxyCache() {
        if (CSFacade.getInstance() != null) {
            this.cs = CSFacade.getInstance();
            this.cs.subscribe(this);
        }
    }

    public void flush() {
        if (this.cachedMOs.size() > 0) {
            this.cachedMOs.clear();
        }
        if (this.cachedChildren.size() > 0) {
            this.cachedChildren.clear();
        }
        Log.logNotify("cleaned the cache......, the size is now = " + this.cachedMOs.size());
    }

    public void flush(MOProxy mo) {
        this.flush(mo.getDN());
    }

    public void flush(MOName name) {
        this.flush(name.toString());
    }

    public synchronized void flush(String ldn) {
        if (this.cachedChildren.containsKey(ldn)) {
            for (MOProxy child : (Vector)this.cachedChildren.get(ldn)) {
                this.flush(child.getDN());
            }
            this.cachedChildren.remove(ldn);
        }
    }

    private void addMO(MOName mo) {
        this.addMO(this.getMOProxy(mo));
    }

    private synchronized void addMO(MOProxy mo) {
        String parentDN;
        if (!this.cachedMOs.containsKey(mo.getDN())) {
            this.cachedMOs.put(mo.getDN(), mo);
        }
        if ((parentDN = mo.getParent().getDN()) != null) {
            Vector siblings = null;
            if (this.cachedChildren.containsKey(parentDN)) {
                siblings = (Vector)this.cachedChildren.get(parentDN);
            } else {
                siblings = new Vector();
                this.cachedChildren.put(parentDN, siblings);
            }
            if (!siblings.contains(mo)) {
                siblings.add(mo);
            }
        }
    }

    public boolean isCached(String dn) {
        return dn != null && this.cachedChildren.containsKey(dn);
    }

    public boolean isCached(MOName name) {
        return this.isCached(name.toString());
    }

    public boolean isCached(MOProxy mo) {
        return this.isCached(mo.getDN());
    }

    private void delMO(MOName mo) {
        this.delMO(this.getMOProxy(mo));
    }

    private void delMO(MOProxy mo) {
        Vector children;
        this.flush(mo);
        this.cachedMOs.remove(mo.getDN());
        String parentDN = mo.getParent().getDN();
        if (this.cachedChildren.containsKey(parentDN) && (children = (Vector)this.cachedChildren.get(parentDN)).contains(mo)) {
            children.remove(mo);
        }
    }

    public void childCreated(MOName theChild) {
        MOProxy mo = this.getMOProxy(theChild);
        if (this.isCached(mo.getParent())) {
            this.addMO(theChild);
        }
    }

    public void childDeleted(MOName theChild) {
        this.delMO(theChild);
    }

    public void attributesChanged(MOName theMO, NameValue[] someAttributes) {
    }

    public MOProxy getMOProxy(MOName aMOName) {
        return this.getMOProxy(aMOName.toString());
    }

    public MOProxy getMOProxy(MOProxy mo) {
        return this.getMOProxy(mo.getDN());
    }

    public MOProxy getMOProxy(String aLDN) {
        MOProxy mo = null;
        if (this.cachedMOs.containsKey(aLDN)) {
            mo = (MOProxy)this.cachedMOs.get(aLDN);
        } else {
            mo = new MOProxy(aLDN);
            this.cachedMOs.put(aLDN, mo);
        }
        return mo;
    }

    public MOProxy[] getMOChildren(MOProxy mo) throws CSException {
        return this.getMOChildren(mo, 1, "");
    }

    private Vector getChildren(MOProxy mo, int scope) throws CSException {
        if (scope != 0 && !this.isCached(mo)) {
            int requestedScope = scope < 0 ? -1 : scope + additionalScope;
            MOName[] childrenDNs = this.cs.getMOChildren(new MOName(mo.getDN()), requestedScope, new Filter("", ""));
            String dn = mo.getDN();
            this.cachedChildren.put(dn, new Vector());
            for (int i = 1; i < childrenDNs.length; ++i) {
                this.addMO(childrenDNs[i]);
            }
            TreeMap<String, Integer> scopeMap = new TreeMap<String, Integer>();
            scopeMap.put(mo.getDN(), new Integer(0));
            for (int i = 1; i < childrenDNs.length; ++i) {
                String child = childrenDNs[i].toString();
                String parent = childrenDNs[i].getParentName().toString();
                int myScope = (Integer)scopeMap.get(parent) + 1;
                scopeMap.put(child, new Integer(myScope));
                if (this.isCached(child) || myScope >= requestedScope && requestedScope != -1) continue;
                this.cachedChildren.put(child, new Vector());
            }
        }
        Vector<MOProxy> children = new Vector<MOProxy>();
        children.add(mo);
        if (scope > 0) {
            Vector localChildren = (Vector)this.cachedChildren.get(mo.getDN());
            Iterator i = localChildren.iterator();
            while (i.hasNext()) {
                children.addAll(this.getChildren((MOProxy)i.next(), scope - 1));
            }
        }
        return children;
    }

    public MOProxy[] getMOChildren(MOProxy mo, int scope, String type) throws CSException {
        Vector children = this.getChildren(mo, scope, type);
        MOProxy[] moChildren = null;
        moChildren = children.isEmpty() ? new MOProxy[]{} : children.toArray(new MOProxy[children.size()]);
        return moChildren;
    }

    private Vector getChildren(MOProxy mo, int scope, String type) throws CSException {
        Vector<MOProxy> children = new Vector<MOProxy>();
        if (type == null || type.equals("") || mo.getType().compareToIgnoreCase(type) == 0) {
            children.add(mo);
        }
        if (scope != 0) {
            if (!this.isCached(mo)) {
                this.getChildren(mo, scope);
            }
            Vector localChildren = this.getChildren(mo, 1);
            Iterator i = localChildren.iterator();
            i.next();
            while (i.hasNext()) {
                Vector grandChildren = this.getChildren((MOProxy)i.next(), scope - 1, type);
                children.addAll(grandChildren);
            }
        }
        return children;
    }

    static {
        additionalScope = Integer.getInteger("MOProxyCache.level", 0);
    }
}

