/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.rbs.em.alexinitializer;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import se.ericsson.cello.emt.helpservice.AlexInitializer;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.OfflineCmUtil;

public class AlexInitializerImpl
implements AlexInitializer {
    private static final String PROPERTY_RESOURCE = "se/ericsson/rbs/em/alexinitializer/resources/EmHelp.properties";
    private static final String PROPERTIES_NO_VALUE_FOUND = "";
    protected static final String ALEX_LIBRARY_KEY = "ALEX_LIBRARY";
    private static final String DOCUMENT_LIBRARY_SYSTEM_SETTABLE_KEY = "docLibSystemSettable";
    private static final String LOAD_ERROR_MESSAGE = "Couldn't load help resource file.\nCause: %s";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Properties libraryProperties = new Properties();
    private NameValueFactory factory = OfflineCmUtil.getNameValueFactory();
    private Mo managedElementDataMo;

    public String convertTitle(String arg0) {
        return arg0;
    }

    public void initAlex(Mo managedElementMo, Mo managedElementDataMo) {
        this.managedElementDataMo = managedElementDataMo;
        this.loadProperties();
        this.setDocumentLibrarySystemSettable();
    }

    private void setDocumentLibrarySystemSettable() {
        this.setSystemSettable(ALEX_LIBRARY_KEY);
    }

    private void setSystemSettable(String key) {
        String value = this.libraryProperties.getProperty(key, PROPERTIES_NO_VALUE_FOUND);
        if (value.equals(PROPERTIES_NO_VALUE_FOUND)) {
            this.logger.info("Couldn't get value from properties. Won't set the MO Attribute docLibSystemSettable.");
        } else {
            this.logger.info(String.format("Setting docLibSystemSettable to %s for key %s", value, key));
            NameValue nameValue = this.factory.create(DOCUMENT_LIBRARY_SYSTEM_SETTABLE_KEY, value);
            this.managedElementDataMo.setAttribute(nameValue, null);
        }
    }

    protected void loadProperties() {
        Properties props = new Properties();
        URL url = this.getClass().getClassLoader().getResource(PROPERTY_RESOURCE);
        if (url != null) {
            try {
                props.load(url.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.warning(String.format(LOAD_ERROR_MESSAGE, "IOException"));
            }
        } else {
            this.logger.warning(String.format(LOAD_ERROR_MESSAGE, "URL is null."));
        }
        this.libraryProperties = (Properties)props.clone();
    }
}

