/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.attributehandling;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.attributehandling.AttrCoordinatorImpl;
import se.ericsson.crbs.cat.common.attributehandling.AttributeValueHandlerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AttributeValueHandler {
    private static final Class THIS_CLASS = AttributeValueHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final int COMMIT_TXID = 0;
    private final Map ldnToAttributeMap = new HashMap();
    private static final Object lock = new Object();
    private final Coordinator myTx;

    public AttributeValueHandler(Coordinator coordinator) {
        this.myTx = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String ldn, String attributeName, Object value) {
        logger.traceEnter(THIS_CLASS, "setValue(ldn=" + ldn + ", value=" + value);
        Object object = lock;
        synchronized (object) {
            Map moData = this.getMoData(ldn);
            moData.put(attributeName, value);
        }
        logger.traceReturn(THIS_CLASS, "setValue()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMoFromHolder(String ldn) {
        logger.traceEnter(THIS_CLASS, "removeMoFromHolder(ldn = " + ldn + ")");
        Object object = lock;
        synchronized (object) {
            this.ldnToAttributeMap.remove(ldn);
        }
        logger.traceReturn(THIS_CLASS, "removeMoFromHolder()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttributeValue(ManagedObject mo, String attributeName) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributeValue(mo = " + mo.getLocalDistinguishedName() + ", attributeName = " + attributeName + ")");
        Object returnValue = null;
        Object object = lock;
        synchronized (object) {
            Map moData = this.getMoData(mo.getLocalDistinguishedName());
            returnValue = moData.get(attributeName);
        }
        if (returnValue == null && this.myTx.getTransactionID() != 0) {
            logger.traceDebug(THIS_CLASS, "Could not find attribute in transaction cache (txid=" + this.myTx + "), will read from commit cache");
            AttributeValueHandler commitValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(new AttrCoordinatorImpl(0));
            returnValue = commitValueHandler.getAttributeValue(mo, attributeName);
        }
        logger.traceReturn(THIS_CLASS, "getAttributeValue(value = " + returnValue + ")");
        return returnValue;
    }

    private Map getMoData(String ldn) {
        Map returnValue = null;
        if (this.ldnToAttributeMap.containsKey(ldn)) {
            returnValue = (Map)this.ldnToAttributeMap.get(ldn);
        } else {
            returnValue = new HashMap();
            this.ldnToAttributeMap.put(ldn, returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyAttributeValueHandler(AttributeValueHandler valueHandlerToReadFrom) {
        Object object = lock;
        synchronized (object) {
            Iterator ldns = valueHandlerToReadFrom.ldnToAttributeMap.keySet().iterator();
            while (ldns.hasNext()) {
                String ldn = (String)ldns.next();
                if (this.ldnToAttributeMap.containsKey(ldn)) {
                    HashMap map = (HashMap)this.ldnToAttributeMap.get(ldn);
                    HashMap mapToReadFrom = (HashMap)valueHandlerToReadFrom.ldnToAttributeMap.get(ldn);
                    map.putAll(mapToReadFrom);
                    continue;
                }
                this.ldnToAttributeMap.put(ldn, valueHandlerToReadFrom.ldnToAttributeMap.get(ldn));
            }
        }
    }
}

