/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.ftp;

import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.net.FTPException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class FtpFaultNumberTranslationHelper {
    private static final Class THIS_CLASS = FtpFaultNumberTranslationHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)FtpFaultNumberTranslationHelper.class.getName());
    private static final transient Map faultNumbers = new TreeMap();

    public String translateFtpFaultNumber(FTPException exception) {
        String reason = "";
        int code = exception.getErrorCode();
        if (faultNumbers.containsKey(Integer.toString(code))) {
            reason = (String)faultNumbers.get(Integer.toString(code));
        } else {
            logger.traceAbnormal(THIS_CLASS, "Could not convert FTP error code to readable text");
            reason = "Unknown FTP/SFTP problem";
        }
        return reason;
    }

    static {
        faultNumbers.put(Integer.toString(0), "Connection problem. E.g. the host name could not be resolved");
        faultNumbers.put(Integer.toString(1000), "Unspecified FTP error");
        faultNumbers.put(Integer.toString(1001), "FTP Socket create failed");
        faultNumbers.put(Integer.toString(1002), "FTP connect initiation failed");
        faultNumbers.put(Integer.toString(1003), "FTP open of local file failed");
        faultNumbers.put(Integer.toString(1004), "FTP open of remote file failed");
        faultNumbers.put(Integer.toString(1005), "FTP write of local file failed");
        faultNumbers.put(Integer.toString(1009), "FTP write of remote file failed");
        faultNumbers.put(Integer.toString(1007), "FTP protocol error");
        faultNumbers.put(Integer.toString(1008), "FTP read of local file failed");
        faultNumbers.put(Integer.toString(1006), "FTP read of remote file failed");
        faultNumbers.put(Integer.toString(1010), "FTP invalid server IP address");
        faultNumbers.put(Integer.toString(1), "SFTP server timed out");
        faultNumbers.put(Integer.toString(2), "SFTP could not connect");
        faultNumbers.put(Integer.toString(3), "SFTP authentication failed");
        faultNumbers.put(Integer.toString(4), "SFTP not connected");
        faultNumbers.put(Integer.toString(5), "SFTP connected");
        faultNumbers.put(Integer.toString(6), "SFTP server disconnect");
        faultNumbers.put(Integer.toString(7), "SFTP open of local file failed");
        faultNumbers.put(Integer.toString(8), "SFTP invalid handle");
        faultNumbers.put(Integer.toString(9), "SFTP open of remote file failed");
        faultNumbers.put(Integer.toString(10), "SFTP persmission denied");
        faultNumbers.put(Integer.toString(11), "SFTP no data");
        faultNumbers.put(Integer.toString(12), "SFTP internal error");
        faultNumbers.put(Integer.toString(13), "SFTP not yet implemented");
        faultNumbers.put(Integer.toString(14), "SFTP local file not found");
        faultNumbers.put(Integer.toString(15), "SFTP remote file not found");
        faultNumbers.put(Integer.toString(16), "SFTP PreReq failure");
        faultNumbers.put(Integer.toString(17), "SFTP remote failure");
        faultNumbers.put(Integer.toString(18), "SFTP End Of File");
        faultNumbers.put(Integer.toString(19), "SFTP protocol error");
        faultNumbers.put(Integer.toString(20), "SFTP out of memory");
        faultNumbers.put(Integer.toString(21), "SFTP local disc access error");
        faultNumbers.put(Integer.toString(2000), "Invalid request");
        faultNumbers.put(Integer.toString(2001), "No ftp client available");
        faultNumbers.put(Integer.toString(2002), "Security mode switched to SFTP");
        faultNumbers.put(Integer.toString(2003), "Security mode switched to FTP");
        faultNumbers.put(Integer.toString(2004), "File transfer aborted");
        faultNumbers.put(Integer.toString(3000), "RFA server unavailable");
    }
}

