/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.validator;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.cat.common.validator.AttributeValidator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public abstract class AbstractAttributeValidator
implements AttributeValidator {
    private static final Class THIS_CLASS = AbstractAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected String attributeName;
    private final String subClassName;
    private final boolean shouldValidateAtCreate;
    private final boolean shouldValidateAtPrepare;
    private final boolean shouldValidateAtDelete;

    public AbstractAttributeValidator(String subClassName, String attribute, boolean validateAtCreate, boolean validateAtPrepare, boolean validateAtDelete) {
        logger.traceEnter(THIS_CLASS, "constructor(attribute[" + attribute + "], validateAtCreate[" + validateAtCreate + "], validateAtPrepare[" + validateAtPrepare + "], validateAtDelete[" + validateAtDelete + "])");
        this.subClassName = subClassName;
        this.attributeName = attribute;
        this.shouldValidateAtCreate = validateAtCreate;
        this.shouldValidateAtPrepare = validateAtPrepare;
        this.shouldValidateAtDelete = validateAtDelete;
        logger.traceReturn(THIS_CLASS, "constructor()");
    }

    protected abstract void validate(ManagedObject var1, Coordinator var2) throws PrepareFailedException, MoAccessException;

    protected void logAndThrowPrepareFailedException(String message) throws PrepareFailedException {
        logger.info(THIS_CLASS, message);
        throw new PrepareFailedException(message);
    }

    public void handlePostSet(ManagedObject mo, String attribute, Object value, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePostSet(ManagedObject " + mo + ", attribute " + attribute + ", value " + value + ")");
        logger.traceReturn(THIS_CLASS, "handlePostSet(ManagedObject " + mo + ")");
    }

    public void validateAtCreate(ManagedObject mo, Object value, AttrList attributes, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate(ManagedObject " + mo + " ,...)");
        if (this.shouldValidateAtCreate) {
            try {
                this.validate(mo, coordinator);
            }
            catch (MoAccessException e) {
                throw new PrepareFailedException("Got exception at validateAtCreate for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)e));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
    }

    public void validateAtPrepare(ManagedObject mo, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + mo + ", shouldValidateAtPrepare " + this.shouldValidateAtPrepare + ")");
        if (this.shouldValidateAtPrepare) {
            try {
                this.validate(mo, coordinator);
            }
            catch (MoAccessException e) {
                throw new PrepareFailedException("Got exception at validateAtPrepare for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)e));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + mo + ")");
    }

    public void validateAtDelete(ManagedObject mo, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtDelete(ManagedObject " + mo + ", shouldValidateAtDelete " + this.shouldValidateAtDelete + ")");
        if (this.shouldValidateAtDelete) {
            try {
                this.validate(mo, coordinator);
            }
            catch (MoAccessException e) {
                throw new PrepareFailedException("Got exception at validateAtDelete for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)e));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtDelete(ManagedObject " + mo + ")");
    }
}

