/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.cat.common.attributehandling.AttributeUtilities;
import se.ericsson.crbs.cat.common.attributehandling.AttributeValueHandler;
import se.ericsson.crbs.cat.common.attributehandling.AttributeValueHandlerFactory;
import se.ericsson.crbs.cat.common.exception.PreCreateValidationException;
import se.ericsson.crbs.cat.common.validator.AbstractAttributeValidator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public abstract class AbstractGenericAttributeValidatorMao
extends GenericMao {
    private static final Class THIS_CLASS = AbstractGenericAttributeValidatorMao.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private Map attrValidatorMap;
    private Coordinator lastTransactionUsed;
    private Coordinator createdInCurrentTransaction;

    public AbstractGenericAttributeValidatorMao(ManagedObject parent, AttrList attributes, String identity, String inputMoType, GenericMaoContext inputGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(parent, attributes, identity, inputMoType, inputGenericMaoContext, softwareRevision, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GenericAttributeValidatorMao()");
        logger.traceReturn(THIS_CLASS, "GenericAttributeValidatorMao()");
    }

    public AbstractGenericAttributeValidatorMao(MoDataWrapper recoveredData, String inputMoType, GenericMaoContext inputGenericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, inputMoType, inputGenericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "GenericAttributeValidatorMao(recover)");
        logger.traceReturn(THIS_CLASS, "GenericAttributeValidatorMao(recover)");
    }

    private Map getValidatorMap() {
        logger.traceEnter(THIS_CLASS, "getValidatorMap()");
        if (this.attrValidatorMap == null) {
            this.attrValidatorMap = new HashMap();
            this.registerValidators();
        }
        logger.traceReturn(THIS_CLASS, "getValidatorMap()");
        return this.attrValidatorMap;
    }

    protected abstract void registerValidators();

    protected void registerValidator(String attributeName, AbstractAttributeValidator validator) {
        logger.traceEnter(THIS_CLASS, "registerValidator(attributeName[" + attributeName + "])");
        Map validatorMap = this.getValidatorMap();
        List<AbstractAttributeValidator> validators = null;
        if (validatorMap.containsKey(attributeName)) {
            validators = (List)validatorMap.get(attributeName);
        } else {
            validators = new ArrayList();
            validatorMap.put(attributeName, validators);
        }
        validators.add(validator);
        logger.traceReturn(THIS_CLASS, "registerValidator()");
    }

    public void preCreateValidation(AttrList attributes, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preCreateValidation(AttrList, Coordinator)");
        this.createdInCurrentTransaction = coordinator;
        this.registerAndStoreCoordinator(coordinator, true);
        Map validatorsMap = this.getValidatorMap();
        for (int i = 0; i < attributes.size(); ++i) {
            String attribute = attributes.getName(i);
            Object attributeValue = attributes.getValue(i);
            if (!validatorsMap.containsKey(attribute)) continue;
            List validators = (List)validatorsMap.get(attribute);
            try {
                this.validateAtCreate(attributeValue, attributes, validators, coordinator);
                continue;
            }
            catch (PrepareFailedException e) {
                throw new PreCreateValidationException(this.getMoType(), e.reason);
            }
        }
        logger.traceReturn(THIS_CLASS, "preCreateValidation(AttrList, Coordinator)");
    }

    private void storeAllAttributesInValueHandler(AttrList attributes, Coordinator coordinator) throws NotHandledAttributeTypeException, MoNotFoundException {
        logger.traceEnter(THIS_CLASS, "storeAllAttributesInValueHandler()");
        AttributeValueHandler attributeValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(coordinator);
        Map map = this.getValidatorMap();
        for (int i = 0; i < attributes.size(); ++i) {
            String attribute = attributes.getName(i);
            if (!map.containsKey(attribute)) continue;
            Object attributeValue = attributes.getValue(i);
            attributeValueHandler.setValue(this.getLocalDistinguishedName(), attribute, attributeValue);
        }
        logger.traceReturn(THIS_CLASS, "storeAllAttributesInValueHandler()");
    }

    private void validateAtCreate(Object attributeValue, AttrList attributes, List validators, Coordinator coordinator) throws PrepareFailedException {
        Iterator iterator = validators.iterator();
        while (iterator.hasNext()) {
            AbstractAttributeValidator validator = (AbstractAttributeValidator)iterator.next();
            validator.validateAtCreate((ManagedObject)this, attributeValue, attributes, coordinator);
        }
    }

    public boolean isCreatedInCurrentTransaction(Coordinator tx) {
        boolean result = false;
        if (this.createdInCurrentTransaction != null) {
            result = this.createdInCurrentTransaction.getTransactionID() == tx.getTransactionID();
        }
        return result;
    }

    public void postSet(String attrName, Object value, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet, attribute: " + attrName + "=" + value);
        Map map = this.getValidatorMap();
        if (map.containsKey(attrName)) {
            this.registerAndStoreCoordinator(coordinator, true);
            AttributeValueHandler attributeValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(coordinator);
            attributeValueHandler.setValue(this.getLocalDistinguishedName(), attrName, value);
            List validators = (List)map.get(attrName);
            Iterator iterator = validators.iterator();
            while (iterator.hasNext()) {
                AbstractAttributeValidator validator = (AbstractAttributeValidator)iterator.next();
                validator.handlePostSet((ManagedObject)this, attrName, attributeValueHandler, coordinator);
            }
        }
        this.registerAndStoreCoordinator(coordinator, false);
        logger.traceReturn(THIS_CLASS, "postSet");
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        if (coordinator != null) {
            this.lastTransactionUsed = coordinator;
        }
    }

    public void prepare(Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "prepare()");
        Map map = this.getValidatorMap();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            List validators = (List)map.get(key);
            Iterator validatorIterator = validators.iterator();
            while (validatorIterator.hasNext()) {
                AbstractAttributeValidator validator = (AbstractAttributeValidator)validatorIterator.next();
                if (this.isRemoved()) {
                    validator.validateAtDelete((ManagedObject)this, coordinator);
                    continue;
                }
                validator.validateAtPrepare((ManagedObject)this, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "prepare()");
    }

    public void commit() {
        logger.traceEnter(THIS_CLASS, "commit()");
        if (this.lastTransactionUsed != null) {
            AttributeValueHandlerFactory.handleCommit(this.lastTransactionUsed);
        }
        super.commit();
        logger.traceReturn(THIS_CLASS, "commit()");
    }

    public void rollback() {
        logger.traceEnter(THIS_CLASS, "rollback()");
        if (this.lastTransactionUsed != null) {
            AttributeValueHandlerFactory.handleRollBack(this.lastTransactionUsed);
        }
        super.rollback();
        logger.traceReturn(THIS_CLASS, "rollback()");
    }

    private void registerAndStoreCoordinator(Coordinator coordinator, boolean register) {
        if (coordinator != null) {
            if (this.lastTransactionUsed == null || this.lastTransactionUsed.getTransactionID() != coordinator.getTransactionID()) {
                this.lastTransactionUsed = coordinator;
            }
            try {
                if (register) {
                    this.registerGenericMaoInTransaction(coordinator);
                }
            }
            catch (MoAccessException e) {
                logger.traceError(THIS_CLASS, "Could not register in the coordinator, got exception: " + (Object)((Object)e));
            }
        }
    }

    protected Map getDeprecatedAttributesMap() throws MoAccessException {
        return new HashMap();
    }

    public AttrList addFroParametersAtCreate(AttrList allAttributesList, AttrList notUsedList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        Map deprecatedAttributes = this.getDeprecatedAttributesMap();
        Set keySet = deprecatedAttributes.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            String keyValue = (String)iterator.next();
            int indexOf = allAttributesList.indexOf(keyValue);
            if (indexOf == -1) continue;
            allAttributesList.removeElementAt(indexOf);
        }
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        this.storeAllAttributesInValueHandler(allAttributesList, coordinator);
        return super.addFroParametersAtCreate(allAttributesList, notUsedList, coordinator);
    }

    protected AttrList removeParametersAtCreate(String[] attributeNamesToRemove, AttrList allAttributesList, AttrList notUsedList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "removeParametersAtCreate()");
        for (int i = 0; i < attributeNamesToRemove.length; ++i) {
            String keyValue = attributeNamesToRemove[i];
            int indexOf = allAttributesList.indexOf(keyValue);
            if (indexOf == -1) continue;
            allAttributesList.removeElementAt(indexOf);
        }
        logger.traceReturn(THIS_CLASS, "removeParametersAtCreate()");
        return super.addFroParametersAtCreate(allAttributesList, notUsedList, coordinator);
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute(attributeName[" + attributeName + "], attributeValue[" + attributeValue + "])");
        if (!this.setDeprecated(attributeName, attributeValue, coordinator)) {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeObjs, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes(no of attributes = " + attributeNames.length + ")");
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        ArrayList<Object> attributeValuesList = new ArrayList<Object>();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (this.setDeprecated(attributeNames[i], attributeObjs[i], coordinator)) continue;
            attributeNamesList.add(attributeNames[i]);
            attributeValuesList.add(attributeObjs[i]);
        }
        super.setAttributes(attributeNamesList.toArray(new String[attributeNamesList.size()]), attributeValuesList.toArray(new Object[attributeValuesList.size()]), coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    private boolean setDeprecated(String name, Object value, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setDeprecated()");
        boolean attributeIsDeprecated = false;
        Map deprecatedAttributes = this.getDeprecatedAttributesMap();
        Set keySet = deprecatedAttributes.keySet();
        if (keySet.contains(name)) {
            Object deprecationObject = deprecatedAttributes.get(name);
            if (deprecationObject instanceof List) {
                List list = (List)deprecationObject;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    this.setDeprecatedAttribute((AttributeUtilities.Pair)iter.next(), value, coordinator);
                }
            } else {
                this.setDeprecatedAttribute((AttributeUtilities.Pair)deprecationObject, value, coordinator);
            }
            attributeIsDeprecated = true;
        }
        logger.traceReturn(THIS_CLASS, "setDeprecated(Attribute is depreicated [" + attributeIsDeprecated + "])");
        return attributeIsDeprecated;
    }

    private void setDeprecatedAttribute(AttributeUtilities.Pair pair, Object value, Coordinator coordinator) throws MoAccessException {
        String ldn = pair.ldn;
        if (ldn != null) {
            String derecatedAttr = (String)pair.value;
            ManagedObject lookup = this.genericMaoContext.getMoRepositoryWrapper().lookup(ldn);
            lookup.setAttribute(derecatedAttr, value, coordinator);
        }
    }

    public Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getAttribute(attributeName[" + attributeName + "])");
        Object returnValue = this.getDeprecated(attributeName, coordinator);
        if (returnValue == null && (returnValue = this.getCachedValue(attributeName, coordinator)) == null) {
            returnValue = super.getAttribute(attributeName, this.getCoordinatorToUse(coordinator));
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(returnValue[" + returnValue + "])");
        return returnValue;
    }

    private Coordinator getCoordinatorToUse(Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getCoordinatorToUse(coordinator[" + coordinator + "])");
        Coordinator toUSe = null;
        if (coordinator != null && this.lastTransactionUsed != null && coordinator.getTransactionID() == this.lastTransactionUsed.getTransactionID()) {
            toUSe = coordinator;
        }
        logger.traceReturn(THIS_CLASS, "getCoordinatorToUse(Coordinator[" + toUSe + "]");
        return toUSe;
    }

    private Object getCachedValue(String attributeName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getCachedValue()");
        Object cachedValue = null;
        Map map = this.getValidatorMap();
        if (map.containsKey(attributeName) && coordinator != null) {
            AttributeValueHandler attributeValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(coordinator);
            cachedValue = attributeValueHandler.getAttributeValue((ManagedObject)this, attributeName);
        }
        logger.traceReturn(THIS_CLASS, "getCachedValue(cachedValue[" + cachedValue + "])");
        return cachedValue;
    }

    public Object[] getAttributes(String[] attributeNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        HashMap<String, Object> derecatedValues = new HashMap<String, Object>();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            Object returnValue = this.getDeprecated(attributeName, coordinator);
            if (returnValue == null) {
                returnValue = this.getCachedValue(attributeName, coordinator);
            }
            if (returnValue == null) {
                attributeNamesList.add(attributeName);
                continue;
            }
            derecatedValues.put(attributeName, returnValue);
        }
        Object[] myAttributes = super.getAttributes(attributeNamesList.toArray(new String[attributeNamesList.size()]), this.getCoordinatorToUse(coordinator));
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return this.combineAttributeLists(attributeNames, attributeNamesList, myAttributes, derecatedValues);
    }

    protected Object getDeprecated(String attributeName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getDeprecated(attributeName[" + attributeName + "])");
        Object returnValue = null;
        Map deprecatedAttributes = this.getDeprecatedAttributesMap();
        Set keySet = deprecatedAttributes.keySet();
        if (keySet.contains(attributeName)) {
            Object o = deprecatedAttributes.get(attributeName);
            AttributeUtilities.Pair pair = null;
            if (o instanceof List) {
                List list = (List)o;
                if (!list.isEmpty()) {
                    pair = (AttributeUtilities.Pair)list.get(0);
                }
            } else {
                pair = (AttributeUtilities.Pair)o;
            }
            if (pair != null) {
                String ldn = pair.ldn;
                if (ldn == null) {
                    returnValue = pair.value;
                } else {
                    String deprecatedAttr = (String)pair.value;
                    ManagedObject lookupMo = this.getDeprecatedMo(ldn);
                    returnValue = lookupMo.getAttribute(deprecatedAttr, coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "getDeprecated(returnValue[" + returnValue + "])");
        return returnValue;
    }

    private ManagedObject getDeprecatedMo(String ldn) {
        logger.traceEnter(THIS_CLASS, "getDeprecatedMo(ldn = " + ldn + ")");
        AbstractGenericAttributeValidatorMao mo = null;
        mo = ldn.equals(this.getLocalDistinguishedName()) ? this : this.genericMaoContext.getMoRepositoryWrapper().lookup(ldn);
        logger.traceEnter(THIS_CLASS, "getDeprecatedMo()");
        return mo;
    }

    protected Object[] combineAttributeLists(String[] originalAttributeNames, List newAttributeNamesList, Object[] newAttributeValues, Map deprecatedValues) {
        logger.traceEnter(THIS_CLASS, "combineAttributeLists()");
        ArrayList<Object> originalAttributeValues = new ArrayList<Object>();
        for (int i = 0; i < originalAttributeNames.length; ++i) {
            String currentAttributeName = originalAttributeNames[i];
            int indexOf = newAttributeNamesList.indexOf(currentAttributeName);
            if (indexOf >= 0) {
                originalAttributeValues.add(newAttributeValues[indexOf]);
                continue;
            }
            originalAttributeValues.add(deprecatedValues.get(currentAttributeName));
        }
        logger.traceReturn(THIS_CLASS, "combineAttributeLists()");
        return originalAttributeValues.toArray(new Object[originalAttributeValues.size()]);
    }
}

