/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.equipment.UpgradeRegistryBase;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.productinventory.SoftwareProductData;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.cello.transaction.Resource2;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportAdaptor;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.crbs.cat.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.crbs.cat.common.validator.ForbiddenCombinationValidator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.auxpluginunit.ChildHandler;
import se.ericsson.crbs.cat.mao.auxpluginunit.NoAccessToHwLogException;
import se.ericsson.crbs.cat.mao.auxpluginunit.RepairDeliveryNoteAlreadyExistsException;
import se.ericsson.crbs.cat.mao.auxpluginunit.RepairDeliveryNoteDoesNotExistException;
import se.ericsson.crbs.cat.mao.mohandler.program.RuProgramMoHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.RuProgramMoHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.PiuTypeHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.PiuTypeHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.commonmo.LengthOutOfRangeException;
import se.ericsson.crbs.omf.mao.commonmo.NoConnectionWithUnitException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.upgrade.TriggerCentralWrapper;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.ServiceLocatorWrapper;

public class AuxPlugInUnitMaoImpl
extends AbstractGenericAttributeValidatorMao
implements AuxPlugInUnitMao,
PiuTypeInstallListener {
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    private static final String INITIALRBSRD_PIUTYPE = "ManagedElement=1,SwManagement=1,PiuType=INITIALRBSRD_*";
    private static final Object MUTEX = new Object();
    private static final boolean READ_LOCK_NOT_NEEDED = false;
    private static final boolean READ_LOCK_NEEDED = true;
    private static final String LOAD_MODULE_FILE_PATH = "loadModuleFilePath";
    private static final String LOAD_MODULE_PRODUCTION_DATE = "loadModuleProductionDate";
    private static final String LOAD_MODULE_PRODUCT_NAME = "loadModuleProductName";
    private static final String LOAD_MODULE_PRODUCT_NUMBER = "loadModuleProductNumber";
    private static final String LOAD_MODULE_PRODUCT_REVISION = "loadModuleProductRevision";
    private static final String PIU_TYPE_SERIAL_NUMBER = "00000000";
    public static final int SEND_CONFIRM = 1;
    public static final int SEND_REJECT = 2;
    public static final int SEND_INCONCLUSIVE = 3;
    protected static final int SHUTDOWN_TIMER = 0;
    private static final Integer LOCK = new Integer(0);
    private static final int SHUTTING_DOWN = 2;
    private static final String MO_TYPE = "AuxPlugInUnit";
    private static final String[] ADMIN_STATE = new String[]{"LOCKED", "UNLOCKED"};
    private static final String[] OPERATIONAL_STATE = new String[]{"DISABLED", "ENABLED"};
    private static final String MANAGED_ELEMENT_DATA = "ManagedElementData";
    public static final String PIU_TYPE_ATTR = "piuType";
    private static final int INSTALLED = 2;
    private static final String RESERVED_BY_ATTR = "reservedBy";
    protected static final String OPERATIONAL_STATE_ATTR = "operationalState";
    protected static final String ADMINISTRATIVE_STATE_ATTR = "administrativeState";
    private static final String RESTART_UNIT = "restartUnit";
    protected static final String UNIT_TYPE = "unitType";
    private static final String LM_FILE_PATH = "loadModuleFilePath";
    private boolean isCppRegistered = false;
    private static final Class THIS_CLASS = AuxPlugInUnitMaoImpl.class;
    private static final String ATTRIBUTE_COUNTRY_CODE = "countryCode";
    private static final String ATTRIBUTE_DESCRIPTION_OF_FAULT = "descriptionOfFault";
    private static final String ATTRIBUTE_PREPARED_BY = "preparedBy";
    private static final String ATTRIBUTE_REFERENCE = "reference";
    private static final String ATTRIBUTE_STATE_CODE = "stateCode";
    private static final String ATTRIBUTE_TR_NUMBER = "trNumber";
    private static final int NC_RESULT_CODE_BASE = 0x1000000;
    public static final int ELIB_CONST_MAOFRO_NO_CONNECTION_WITH_UNIT = 0x1000006;
    public static final int ELIB_CONST_MAOFRO_NOT_OK = 0x1000001;
    public static final int ELIB_CONST_MAOFRO_HW_LOG_NO_ENTRY = 0x1000004;
    public static final int ELIB_CONST_MAOFRO_HW_LOG_NO_ACCESS = 0x1000003;
    public static final int ELIB_CONST_MAOFRO_HW_LOG_ENTRY_ALREADY_EXISTS = 0x1000005;
    private static final String ELIB_CONST_MAOFRO_NO_CONNECTION_WITH_UNIT_STRING = Integer.toString(0x1000006);
    private static final String ELIB_CONST_MAOFRO_NOT_OK_STRING = Integer.toString(0x1000001);
    private static final String ELIB_CONST_MAOFRO_HW_LOG_NO_ENTRY_STRING = Integer.toString(0x1000004);
    private static final String ELIB_CONST_MAOFRO_HW_LOG_NO_ACCESS_STRING = Integer.toString(0x1000003);
    private static final String ELIB_CONST_MAOFRO_HW_LOG_ENTRY_ALREADY_EXISTS_STRING = Integer.toString(0x1000005);
    private static final String READ_REPAIR_DELIVERY_NOTE_FROM_HW_LOG = "readRepairDeliveryNoteFromHwLog";
    private static final String WRITE_REPAIR_DELIVERY_NOTE_FROM_HW_LOG = "writeRepairDeliveryNoteToHwLog";
    private static final int ATTRIBUTE_DESCRIPTION_OF_FAULT_LENGTH_MIN = 1;
    private static final int ATTRIBUTE_DESCRIPTION_OF_FAULT_LENGTH_MAX = 64;
    private static final int ATTRIBUTE_PREPARED_BY_LENGTH_MIN = 1;
    private static final int ATTRIBUTE_PREPARED_BY_LENGTH_MAX = 15;
    private static final int ATTRIBUTE_REFERENCE_LENGTH_MIN = 0;
    private static final int ATTRIBUTE_REFERENCE_LENGTH_MAX = 8;
    private static final String[] ATTRIBUTE_STATE_CODE_VALID_VALUES = new String[]{"R", "S", "T"};
    private static final String ATTRIBUTE_STATE_CODE_VALID_VALUES_STR = ATTRIBUTE_STATE_CODE_VALID_VALUES[0] + ", " + ATTRIBUTE_STATE_CODE_VALID_VALUES[1] + ", " + ATTRIBUTE_STATE_CODE_VALID_VALUES[2];
    private static final int ATTRIBUTE_TR_NUMBER_LENGTH_MIN = 0;
    private static final int ATTRIBUTE_TR_NUMBER_LENGTH_MAX = 10;
    private final RuProgramMoHandler ruProgramMoHandler;
    protected RuDataHolder ruDataHolder = new RuDataHolder();
    protected String swCompatibilityListXml = "NoCoMpAtIbIlItYlIsTsPeCiFiEd";
    public String runningLmcInfoXml = "NoRuNnInGLmCiNfOsPeCiFiEd";
    protected boolean triggeredFromNodeControl = false;
    private static final AbstractLogger logger = LoggingService.getLogger((String)AuxPlugInUnitMaoImpl.class.getName());
    private String name = "";
    private boolean nodeIsUpgrading;
    private static final String INSTALL_NOT_CONFIRMED = "NotConfirmed";
    private static final String INSTALL_CONFIRMED = "Confirmed";
    private static final String INSTALL_REJECTED_FTP_NA = "RejectedFTPNotAvailable";
    private static final String INSTALL_REJECTED_OTHER = "RejectedOtherReason";
    private volatile String installPiuTypeResult = "NotConfirmed";

    public AuxPlugInUnitMaoImpl(ManagedObject inputParent, AttrList inputAttributes, String inputIdentity, GenericMaoContext inputGenericMaoContext, Integer inputSoftwareRevision, Coordinator inputCoordinator, InitialMaoContext inputInitialMaoContext) throws MoAccessException {
        super(inputParent, inputAttributes, inputIdentity, MO_TYPE, inputGenericMaoContext, inputSoftwareRevision, inputCoordinator, inputInitialMaoContext);
        ManagedObject managedobject1;
        MoIterator moiterator;
        logger.traceEnter(THIS_CLASS, "AuxPlugInUnitMaoImpl() - constructor");
        this.checkThatSwAllocationCanBeRetrievedFromPiuType(inputAttributes, inputCoordinator);
        this.ruProgramMoHandler = RuProgramMoHandlerFactory.getInstance().getRuProgramMoHandler(this, inputGenericMaoContext);
        this.registerForCppUpgrade();
        this.registerForProductInventory(inputCoordinator);
        Reservable piuTypeAccess = (Reservable)inputAttributes.getValue(inputAttributes.indexOf(PIU_TYPE_ATTR));
        if (piuTypeAccess != null) {
            piuTypeAccess.reserve((ManagedObject)this, inputCoordinator);
        }
        if ((moiterator = this.getMaoContext().getMoAccessor().lookupType(MANAGED_ELEMENT_DATA)) != null && moiterator.hasMoreElements() && ((ManagedElementDataMo)(managedobject1 = moiterator.nextMo())).getAutoConfigurationAllowed(inputCoordinator)) {
            logger.traceDebug(THIS_CLASS, "Autocreating children according to PiuType.");
            ChildHandler subTreeHandler = new ChildHandler(this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext.getMoFactoryMgrWrapper(), this.genericMaoContext.getTransactionServicesFactory(), this, MUTEX);
            subTreeHandler.createChildren(false, inputCoordinator);
        }
        new ResourceForRollback(this, inputCoordinator);
        logger.traceReturn(THIS_CLASS, "AuxPlugInUnitMaoImpl() - constructor");
    }

    public AuxPlugInUnitMaoImpl(MoDataWrapper inputRecoveredData, String inputMoType, GenericMaoContext inputGenericMaoContext, InitialMaoContext inputInitialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(inputRecoveredData, inputMoType, inputGenericMaoContext, inputInitialMaoContext);
        logger.traceEnter(THIS_CLASS, "AuxPlugInUnitMaoImpl() - reconstructor");
        this.ruProgramMoHandler = RuProgramMoHandlerFactory.getInstance().getRuProgramMoHandler(this, this.genericMaoContext);
        this.registerForCppUpgrade();
        this.registerForProductInventory(null);
        logger.traceReturn(THIS_CLASS, "AuxPlugInUnitMaoImpl() - reconstructor");
    }

    public void storeRuDataHolder(RuDataHolder inputRuDataHolder) {
        this.ruDataHolder = inputRuDataHolder;
        logger.traceGeneral(THIS_CLASS, "Stored RU data: \"" + this.ruDataHolder + "\"");
    }

    public void storeCompatibilityListXml(String theSwCompatibilityListXml) {
        if (theSwCompatibilityListXml.equals("")) {
            this.swCompatibilityListXml = "NoCoMpAtIbIlItYlIsTsPeCiFiEd";
            logger.traceGeneral(THIS_CLASS, "Stored an empty compatibility list");
        } else {
            this.swCompatibilityListXml = theSwCompatibilityListXml;
            logger.traceGeneral(THIS_CLASS, "Stored compatibility list: \"" + StringHelper.doubleQuote((String)this.swCompatibilityListXml));
        }
    }

    public void storeRunningLmcInfoXml(String theRunningLmcInfoXml) {
        if (theRunningLmcInfoXml.equals("")) {
            this.runningLmcInfoXml = "NoRuNnInGLmCiNfOsPeCiFiEd";
            logger.traceGeneral(THIS_CLASS, "Stored an empty running LMC info");
        } else {
            this.runningLmcInfoXml = theRunningLmcInfoXml;
            logger.traceGeneral(THIS_CLASS, "Stored running LMC info: " + StringHelper.doubleQuote((String)this.runningLmcInfoXml));
        }
    }

    public String getRunningLmcInfo() {
        return this.runningLmcInfoXml;
    }

    private final String getUnitType(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getUnitType()");
        ManagedObject thePiuType = (ManagedObject)super.getAttribute(PIU_TYPE_ATTR, false, coordinator);
        Object productData = thePiuType.getAttribute("productData", coordinator);
        String localProductName = (String)((Struct)productData).getValue("productName");
        logger.traceReturn(THIS_CLASS, "getUnitType() : " + localProductName);
        return localProductName;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.preGetAttributes(attrNames, coordinator);
        String temp = "null";
        Object[] result = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            result[i] = this.getAttribute(attrNames[i], coordinator);
            String attrValue = "null";
            if (result[i] != null) {
                temp = result[i].getClass().getName();
                attrValue = result[i] instanceof ManagedObject ? ((ManagedObject)result[i]).getLocalDistinguishedName() : result[i].toString();
            }
            logger.traceDebug(THIS_CLASS, "getAttributes() - AuxPlugInUnit - " + attrNames[i] + " = " + temp + ":" + attrValue);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return result;
    }

    public final Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttribute() - " + attributeName);
        Object result = null;
        result = UNIT_TYPE.equalsIgnoreCase(attributeName) ? this.getUnitType(coordinator) : super.getAttribute(attributeName, coordinator);
        String attrValue = "null";
        if (result != null) {
            attrValue = result instanceof ManagedObject ? ((ManagedObject)result).getLocalDistinguishedName() : result.toString();
        }
        logger.traceReturn(THIS_CLASS, "getAttribute() - " + attributeName + " - " + attrValue);
        return result;
    }

    private void registerForCppUpgrade() {
        try {
            this.name = "LTE actionReconfigureProgramPrepare preventor AuxPlugInUnit" + this.getRdnId(null);
        }
        catch (Exception e) {
            this.name = "LTE actionReconfigureProgramPrepare preventor AuxPlugInUnit" + Math.random();
            logger.traceAbnormal(THIS_CLASS, "Not possible to get the RDN value for the trigger central name. Uses this name instead: " + this.name);
        }
        if (!this.isCppRegistered) {
            ServiceRepository serviceRepository = ServiceLocatorWrapper.getServiceRepository();
            UpgradeRegistryBase upgradeRegistryBase = (UpgradeRegistryBase)serviceRepository.getService(UpgradeRegistryBase.class);
            upgradeRegistryBase.addPlugInUnitMoTypeName(MO_TYPE);
            TriggerCentralWrapper.addUpgradeParticipator((UpgradeParticipator)this);
            this.isCppRegistered = true;
        }
    }

    private void registerForProductInventory(Coordinator inputCoordinator) {
        Object lmProductNumberObject = this.retrievePersistently(LOAD_MODULE_PRODUCT_NUMBER, inputCoordinator);
        if (lmProductNumberObject != null && lmProductNumberObject instanceof Struct) {
            ProductRepository.instance().registerSw((SoftwareProductData)this);
        }
    }

    public int getRuSwResult() {
        return this.ruProgramMoHandler.getRuSwResult();
    }

    public void setTriggeredFromNodeControl() {
        this.triggeredFromNodeControl = true;
    }

    public boolean isTriggeredFromNodeControl() {
        return this.triggeredFromNodeControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionReconfigureProgramPrepare()");
        Object object = MUTEX;
        synchronized (object) {
            try {
                logger.traceGeneral(THIS_CLASS, "actionReconfigureProgramPrepare() after sync");
                if (!this.triggeredFromNodeControl && this.nodeIsUpgrading) {
                    logger.traceGeneral(THIS_CLASS, "We've been called from CPP - ignore this during upgrade and wait for call from NC instead");
                    return;
                }
                Control control = this.getTranscationFactory();
                Coordinator c = control.getCoordinator();
                PiuTypeAccess currentPiuType = (PiuTypeAccess)this.getPiuType(coordinator);
                this.ruProgramMoHandler.removeDisabledPrograms(false, coordinator);
                this.setRuDataFromCorrectSource(coordinator, currentPiuType);
                PiuTypeHelper piuTypeHelper = PiuTypeHelperFactory.getInstance().getPiuTypeHelper();
                PiuTypeMoSU_Access piuTypeMo = piuTypeHelper.getPiuTypeForHwPid(this.ruDataHolder, this.genericMaoContext);
                piuTypeMo = this.rollback(control, c, currentPiuType, piuTypeMo);
                this.downloadAndInstallMissingSW(piuTypeMo, coordinator);
                PiuTypeMoSU_Access piuType = this.ruProgramMoHandler.reconfigurePrograms(currentPiuType, this.triggeredFromNodeControl, this.ruDataHolder, this.swCompatibilityListXml, this.runningLmcInfoXml, coordinator);
                this.setAttribute(PIU_TYPE_ATTR, piuType, coordinator);
                this.storeProductData(coordinator);
                if (this.triggeredFromNodeControl && !this.nodeIsUpgrading) {
                    this.ruProgramMoHandler.removeDisabledPrograms(true, coordinator);
                }
                logger.traceReturn(THIS_CLASS, "actionReconfigureProgramPrepare()");
            }
            finally {
                this.triggeredFromNodeControl = false;
            }
        }
    }

    private PiuTypeMoSU_Access rollback(Control control, Coordinator c, PiuTypeAccess currentPiuType, PiuTypeMoSU_Access piuTypeMo) throws MoAccessException {
        boolean rollbackNeeded = false;
        if (piuTypeMo == null) {
            piuTypeMo = this.ruProgramMoHandler.reconfigurePrograms(currentPiuType, this.triggeredFromNodeControl, this.ruDataHolder, this.swCompatibilityListXml, this.runningLmcInfoXml, c);
            rollbackNeeded = true;
        }
        try {
            if (rollbackNeeded) {
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException e) {
            e.printStackTrace();
            logger.traceError(THIS_CLASS, "Failed to rollback transaction. Reason: " + e.reason, (Throwable)e);
        }
        return piuTypeMo;
    }

    private Control getTranscationFactory() {
        Control control = null;
        try {
            TransactionFactory transFact = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory();
            control = transFact.create(0);
        }
        catch (TransactionRolledBackException trbe) {
            logger.traceError(THIS_CLASS, "Failed to create (temp) transaction. Reason: " + trbe.reason, (Throwable)trbe);
        }
        return control;
    }

    private void downloadAndInstallMissingSW(PiuTypeMoSU_Access piuTypeMo, Coordinator coordinator) throws MoAccessException {
        boolean nodeIsUpgrading = this.getUpgradeStateFromUpgradePackage();
        logger.traceDebug(THIS_CLASS, "Value of local nodeIsUpgrading: " + nodeIsUpgrading);
        if (!this.isLmInInstalledState(piuTypeMo, null) && !nodeIsUpgrading) {
            this.fixMissingSwAllocationConnection(coordinator);
            this.installPiuType((PiuTypeMo)piuTypeMo);
        }
    }

    private boolean getUpgradeStateFromUpgradePackage() throws MoAccessException {
        ConfigurationVersionMo cvMo = (ConfigurationVersionMo)this.genericMaoContext.getMoRepositoryWrapper().lookup(CONFIGURATION_VERSION_LDN);
        logger.traceDebug(THIS_CLASS, "Check that ConfigurationVersionMo is not null: " + (cvMo != null));
        int upgradeState = -1;
        if (cvMo != null) {
            UpgradePackageMo upgradePackageMo = (UpgradePackageMo)cvMo.getCurrentUpgradePackage(null);
            logger.traceDebug(THIS_CLASS, "Check that UpgradePackageMo is not null: " + (upgradePackageMo != null));
            if (upgradePackageMo != null) {
                upgradeState = upgradePackageMo.getState(null);
            }
        }
        logger.traceDebug(THIS_CLASS, "Value of upgradeState: " + upgradeState);
        return upgradeState == 2 || upgradeState == 3;
    }

    public boolean isLmInInstalledState(PiuTypeMoSU_Access piuTypeMo, Coordinator coordinator) throws MoAccessException {
        LoadModuleHelper lmHelper = LoadModuleHelperFactory.getInstance().getLoadModuleHelper(this, this.genericMaoContext);
        LoadModuleMoSU_Access lm = lmHelper.getInstalledLoadModuleMo(piuTypeMo, coordinator);
        if (lm != null) {
            int lmFilesInstalledState = piuTypeMo.getLmFilesInstallState(null);
            return lmFilesInstalledState == 2;
        }
        return true;
    }

    public void fixMissingSwAllocationConnectionTest(Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        this.fixMissingSwAllocationConnection(coordinator);
    }

    private void fixMissingSwAllocationConnection(Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "fixMissingSwAllocationConnection()");
        String AuxPiuLDN = this.getLocalDistinguishedName();
        SwAllocationMo moSwARu = this.getSwAllocationForRU();
        logger.traceDebug(THIS_CLASS, "AuxPiuLdn: " + AuxPiuLDN);
        logger.traceDebug(THIS_CLASS, "moSwARu " + moSwARu);
        boolean auxPiuLdnFoundInSlotList = false;
        if (moSwARu != null) {
            logger.traceDebug(THIS_CLASS, "moSwARU exists");
            ManagedObject[] slotList = moSwARu.getSlotList(null);
            for (int i = 0; i < slotList.length; ++i) {
                logger.traceDebug(THIS_CLASS, "looping : " + slotList[i]);
                String slot = slotList[i].getLocalDistinguishedName();
                logger.traceDebug(THIS_CLASS, "slot : " + slot);
                if (!slot.equals(AuxPiuLDN)) continue;
                logger.traceDebug(THIS_CLASS, "AuxPiu Already configured in SwAllocation");
                auxPiuLdnFoundInSlotList = true;
                return;
            }
            if (!auxPiuLdnFoundInSlotList) {
                logger.traceDebug(THIS_CLASS, "AddSlot : " + this.getLocalDistinguishedName());
                moSwARu.actionAddSlot((ManagedObject)this, coordinator);
                logger.traceReturn(THIS_CLASS, "fixMissingSwAllocationConnection addSlot: " + this.getLocalDistinguishedName());
                return;
            }
        }
        logger.traceError(THIS_CLASS, "SwAllocation MO not found for auxpluginunit " + this.getLocalDistinguishedName());
    }

    private SwAllocationMo getSwAllocationForRU() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSwAllocationForRU()");
        MoIterator moiterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("SwAllocation");
        while (moiterator != null && moiterator.hasMoreElements()) {
            logger.traceDebug(THIS_CLASS, "getSwAllocationForRU() moIterator not null");
            ManagedObject mo = moiterator.nextMo();
            if (!(mo instanceof SwAllocationMo)) continue;
            logger.traceDebug(THIS_CLASS, "getSwAllocationForRU() moSwA is of type SwAllocation : " + mo.getLocalDistinguishedName());
            SwAllocationMo moSwA = (SwAllocationMo)mo;
            ManagedObject[] list = moSwA.getRepertoireList(null);
            for (int i = 0; i < list.length; ++i) {
                String ldn = list[i].getLocalDistinguishedName();
                logger.traceDebug(THIS_CLASS, "ldn of Repertoire : " + ldn);
                if (!ldn.equals("ManagedElement=1,SwManagement=1,Repertoire=LTE_RBS_RU")) continue;
                logger.traceReturn(THIS_CLASS, "getSwAllocationForRU() found : " + ldn);
                return moSwA;
            }
        }
        logger.traceReturn(THIS_CLASS, "getSwAllocationForRU() not found");
        return null;
    }

    private void installPiuType(PiuTypeMo piuTypeMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "installPiuType()");
        if (piuTypeMo == null) {
            logger.traceDebug(THIS_CLASS, "piuTypeMo is null -> installPiuType() return");
            return;
        }
        int lmFilesInstalledState = piuTypeMo.getLmFilesInstallState(null);
        logger.traceDebug(THIS_CLASS, "SW download (lmFilesInstalledState=" + lmFilesInstalledState + ")");
        PiuTypeInstallSupportAdaptor installAdaptor = PiuTypeInstallSupportAdaptor.instance();
        if (installAdaptor != null) {
            logger.traceDebug(THIS_CLASS, "Found PiuTypeMo instance: " + piuTypeMo.getLocalDistinguishedName());
            int id1 = installAdaptor.installPiuType(piuTypeMo, (PiuTypeInstallListener)this);
            logger.traceDebug(THIS_CLASS, "installPiuType triggered. actionId=" + id1);
            int installedState = piuTypeMo.getLmFilesInstallState(null);
            logger.traceDebug(THIS_CLASS, "piuType installedState=" + installedState + ". ldn=" + this.getFullDistinguishedName());
            try {
                int i = 0;
                int retries = 0;
                int MAX_NUMBER_OF_RETRIES = 6;
                while (!INSTALL_CONFIRMED.equals(this.installPiuTypeResult) && !INSTALL_REJECTED_OTHER.equals(this.installPiuTypeResult)) {
                    logger.traceDebug(THIS_CLASS, i + ". installPiuTypeResult=" + this.installPiuTypeResult);
                    Thread.sleep(10000L);
                    if (INSTALL_REJECTED_FTP_NA.equals(this.installPiuTypeResult)) {
                        if (retries >= 6) {
                            logger.traceError(THIS_CLASS, "Failed to install LM after " + retries + " retries, due to FTP server not available");
                            break;
                        }
                        int id2 = installAdaptor.installPiuType(piuTypeMo, (PiuTypeInstallListener)this);
                        logger.traceDebug(THIS_CLASS, "installPiuType triggered again after FTP server not available. Retry=" + retries + ", actionId=" + id2);
                        this.installPiuTypeResult = INSTALL_NOT_CONFIRMED;
                        ++retries;
                        i = 0;
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.traceDebug(THIS_CLASS, "actionReconfigureProgramPrepare(): *** installPiuTypeResult=" + this.installPiuTypeResult);
        }
        logger.traceReturn(THIS_CLASS, "installPiuType()");
    }

    public void installPiuTypeConfirmed(int actionId) {
        logger.traceEnter(THIS_CLASS, "installPiuTypeConfirmed(): id=" + actionId);
        this.installPiuTypeResult = INSTALL_CONFIRMED;
        logger.traceReturn(THIS_CLASS, "installPiuTypeConfirmed(): id=" + actionId);
    }

    public void installPiuTypeRejected(int actionId, InstallRejectReason rejectReason) {
        String rejectMessage = "installPiuTypeRejected(): " + actionId + ". " + rejectReason;
        this.checkRejectReason(rejectReason, rejectMessage);
    }

    public void installPiuTypeRejected(int actionId, InstallRejectReason rejectReason, String message) {
        String rejectMessage = "installPiuTypeRejected(): " + actionId + ". " + rejectReason + ". " + message;
        this.checkRejectReason(rejectReason, rejectMessage);
    }

    private void checkRejectReason(InstallRejectReason rejectReason, String rejectMessage) {
        logger.traceEnter(THIS_CLASS, rejectMessage);
        if (InstallRejectReason.FTP_SERVER_NOT_ACCESSIBLE.equals(rejectReason)) {
            this.installPiuTypeResult = INSTALL_REJECTED_FTP_NA;
        } else {
            this.installPiuTypeResult = INSTALL_REJECTED_OTHER;
            logger.traceError(THIS_CLASS, rejectMessage);
        }
        logger.traceReturn(THIS_CLASS, "installPiuTypeRejected()");
    }

    private void storeProductData(Coordinator coordinator) throws MoAccessException {
        if (this.sendInconclusive()) {
            String filePath = this.ruProgramMoHandler.getLmFilePath();
            this.storeLoadModuleData(filePath, null, coordinator);
        } else if (this.storePiciInformation()) {
            LoadModuleMoSU_Access loadModuleMo = this.ruProgramMoHandler.getLoadModuleMo();
            String filePath = (String)loadModuleMo.getAttribute("loadModuleFilePath", coordinator);
            Struct productData = (Struct)loadModuleMo.getAttribute("productData", coordinator);
            this.storeLoadModuleData(filePath, productData, coordinator);
        } else {
            this.storeLoadModuleData(null, null, coordinator);
        }
    }

    private boolean sendInconclusive() {
        return this.getRuSwResult() == 3;
    }

    private boolean storePiciInformation() {
        return this.ruProgramMoHandler.isPreInstalledUsed() || this.ruProgramMoHandler.isRunningSwUsed();
    }

    private void storeLoadModuleData(String filePath, Struct productData, Coordinator coordinator) throws MoAccessException {
        String localFilePath = filePath == null ? "" : filePath;
        this.storePersistently("loadModuleFilePath", localFilePath, coordinator);
        if (productData == null) {
            this.storePersistently(LOAD_MODULE_PRODUCT_NAME, "", coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCT_NUMBER, "", coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCT_REVISION, "", coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCTION_DATE, "", coordinator);
        } else {
            this.storePersistently(LOAD_MODULE_PRODUCT_NAME, productData.getValue("productName"), coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCT_NUMBER, productData.getValue("productNumber"), coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCT_REVISION, productData.getValue("productRevision"), coordinator);
            this.storePersistently(LOAD_MODULE_PRODUCTION_DATE, productData.getValue("productionDate"), coordinator);
        }
    }

    private final void storePersistently(String attributeName, Object attributeValue, Coordinator coordinator) {
        try {
            this.setAdditionalAttribute(attributeName, attributeValue, coordinator);
            logger.traceParam(THIS_CLASS, "Stored persistently \"" + attributeName + "\" - value: \"" + attributeValue + "\"");
        }
        catch (MoAccessException mae) {
            String msg = "Failed to persistently store attributes.";
            logger.traceError(THIS_CLASS, "Failed to persistently store attributes.", (Throwable)mae);
        }
    }

    private final Object retrievePersistently(String attributeName, Coordinator coordinator) {
        Object result = null;
        try {
            result = this.getAdditionalAttribute(attributeName, coordinator);
            logger.traceParam(THIS_CLASS, "Retrieved persistently \"" + attributeName + "\" - value: \"" + result + "\"");
        }
        catch (MoAccessException mae) {
            result = "";
            logger.traceError(THIS_CLASS, "The persistently stored attribute " + attributeName + " could not be retrieved.", (Throwable)mae);
        }
        return result;
    }

    private void setRuDataFromCorrectSource(Coordinator coordinator, PiuTypeAccess currentPiuType) {
        if (!this.ruDataHolder.isRequiredDataInitialized()) {
            RuDataHolder ruDataFromProductData = this.getRuDataFromProductData(coordinator);
            if (ruDataFromProductData.isRequiredDataInitialized()) {
                this.ruDataHolder = ruDataFromProductData;
                logger.traceDebug(THIS_CLASS, "RU data read from product data: " + this.ruDataHolder.toString());
            } else {
                RuDataHolder ruDataFromPiuType;
                this.ruDataHolder = ruDataFromPiuType = this.getRuDataFromPiuType(currentPiuType, coordinator);
                logger.traceDebug(THIS_CLASS, "RU data read from PiuType: " + this.ruDataHolder.toString());
            }
        }
    }

    protected RuDataHolder getRuDataFromPiuType(PiuTypeAccess currentPiuType, Coordinator localCoordinator) {
        RuDataHolder ruDataFromPiuType;
        try {
            ruDataFromPiuType = new RuDataHolder();
            Struct productData = currentPiuType.getProductData(localCoordinator);
            String piuTypeProductName = (String)productData.getValue("productName");
            String piuTypeProductNumber = (String)productData.getValue("productNumber");
            String piuTypeProductRevision = (String)productData.getValue("productRevision");
            ruDataFromPiuType.setLdn(this.getLocalDistinguishedName());
            ruDataFromPiuType.setProductName(piuTypeProductName);
            ruDataFromPiuType.setProductNumber(piuTypeProductNumber);
            ruDataFromPiuType.setProductRevision(piuTypeProductRevision);
            ruDataFromPiuType.setSerialNumber(PIU_TYPE_SERIAL_NUMBER);
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "Failed to retrieve RU data from current PiuType MO.", (Throwable)e);
            ruDataFromPiuType = new RuDataHolder();
        }
        return ruDataFromPiuType;
    }

    protected RuDataHolder getRuDataFromProductData(Coordinator localCoordinator) {
        RuDataHolder ruDataFromProductData;
        try {
            ruDataFromProductData = new RuDataHolder();
            Struct productData = (Struct)this.getAttribute("productData", localCoordinator);
            String productDataProductName = (String)productData.getValue("productName");
            String productDataProductNumber = (String)productData.getValue("productNumber");
            String productDataProductRevision = (String)productData.getValue("productRevision");
            String productDataSerialNumber = (String)productData.getValue("serialNumber");
            ruDataFromProductData.setLdn(this.getLocalDistinguishedName());
            ruDataFromProductData.setProductName(productDataProductName);
            ruDataFromProductData.setProductNumber(productDataProductNumber);
            ruDataFromProductData.setProductRevision(productDataProductRevision);
            ruDataFromProductData.setSerialNumber(productDataSerialNumber);
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "Failed to retrieve RU data from product data.", (Throwable)e);
            ruDataFromProductData = new RuDataHolder();
        }
        return ruDataFromProductData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionRemoveDisabledPrograms()");
        Object object = MUTEX;
        synchronized (object) {
            logger.traceGeneral(THIS_CLASS, "actionRemoveDisabledPrograms() after sync");
            this.handleTransactionRead(coordinator);
            this.ruProgramMoHandler.removeDisabledPrograms(false, coordinator);
            logger.traceReturn(THIS_CLASS, "actionRemoveDisabledPrograms()");
        }
    }

    public void actionRestart(int restartRank, int restartCause, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionRestart()");
        this.actionRestartUnit(coordinator);
        logger.traceReturn(THIS_CLASS, "actionRestart()");
    }

    public void actionRestartUnit(Coordinator coordinator) throws MoAccessException, InternalErrorException, NoConnectionWithUnitException {
        logger.traceEnter(THIS_CLASS, "actionRestartUnit()");
        try {
            this.sendActionWithCfm(RESTART_UNIT, coordinator, new TreeMap());
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (result.equals(ELIB_CONST_MAOFRO_NO_CONNECTION_WITH_UNIT_STRING)) {
                throw new NoConnectionWithUnitException(MO_TYPE, "No connection with " + this.getLocalDistinguishedName());
            }
            if (result.equals(ELIB_CONST_MAOFRO_NOT_OK_STRING)) {
                throw new InternalErrorException(MO_TYPE, "Internal error for " + this.getLocalDistinguishedName());
            }
            logger.traceAbnormal(THIS_CLASS, "Got an unexpected exception " + (Object)((Object)frfe));
        }
        logger.traceReturn(THIS_CLASS, "actionRestartUnit()");
    }

    public Struct actionReadRepairDeliveryNoteFromHwLog(Coordinator coordinator) throws NoAccessToHwLogException, RepairDeliveryNoteDoesNotExistException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionReadRepairDeliveryNoteFromHwLog()");
        this.handleTransactionRead(coordinator);
        TreeMap parameters = new TreeMap();
        StructImpl repairDeliveryNote = new StructImpl();
        try {
            Map returnedParameters = this.sendActionWithCfm(READ_REPAIR_DELIVERY_NOTE_FROM_HW_LOG, coordinator, parameters);
            Iterator parameterNameIterator = returnedParameters.keySet().iterator();
            while (parameterNameIterator.hasNext()) {
                String currentAttrName = (String)parameterNameIterator.next();
                repairDeliveryNote.addElement(currentAttrName, returnedParameters.get(currentAttrName));
            }
        }
        catch (FroRequestFailedException exception) {
            String exceptionVariables = exception.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (result.equals(ELIB_CONST_MAOFRO_HW_LOG_NO_ACCESS_STRING)) {
                String msg = "Could not access the HW log. Caught exception = " + (Object)((Object)exception);
                logger.traceGeneral(THIS_CLASS, msg);
                throw new NoAccessToHwLogException(MO_TYPE, msg);
            }
            if (result.equals(ELIB_CONST_MAOFRO_HW_LOG_NO_ENTRY_STRING)) {
                String msg = "The HW log does not exist. Caught exception = " + (Object)((Object)exception);
                logger.traceGeneral(THIS_CLASS, msg);
                throw new RepairDeliveryNoteDoesNotExistException(MO_TYPE, msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)exception));
            throw exception;
        }
        logger.traceReturn(THIS_CLASS, "actionReadRepairDeliveryNoteFromHwLog()");
        return repairDeliveryNote;
    }

    public void actionWriteRepairDeliveryNoteToHwLog(String preparedBy, String countryCode, String stateCode, String descriptionOfFault, String trNumber, String reference, Coordinator coordinator) throws NoAccessToHwLogException, RepairDeliveryNoteAlreadyExistsException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionWriteRepairDeliveryNoteToHwLog()");
        this.handleTransactionRead(coordinator);
        String[] availCountryCodes = Locale.getISOCountries();
        boolean validCountryCode = false;
        for (int i = 0; i < availCountryCodes.length; ++i) {
            if (!countryCode.equalsIgnoreCase(availCountryCodes[i])) continue;
            validCountryCode = true;
            break;
        }
        this.checkValidCountryCode(countryCode, validCountryCode);
        this.validate(ATTRIBUTE_DESCRIPTION_OF_FAULT, descriptionOfFault, 1, 64);
        this.validate(ATTRIBUTE_PREPARED_BY, preparedBy, 1, 15);
        this.validate(ATTRIBUTE_TR_NUMBER, trNumber, 0, 10);
        this.validate(ATTRIBUTE_REFERENCE, reference, 0, 8);
        boolean validStateCode = false;
        if (stateCode.length() == 1) {
            for (int i = 0; i < ATTRIBUTE_STATE_CODE_VALID_VALUES.length; ++i) {
                if (!stateCode.equals(ATTRIBUTE_STATE_CODE_VALID_VALUES[i])) continue;
                validStateCode = true;
                break;
            }
        }
        if (!validStateCode) {
            String msg = "The provided stateCode [" + stateCode + "] is not valid. Valid stateCodes are: " + ATTRIBUTE_STATE_CODE_VALID_VALUES_STR;
            logger.traceGeneral(THIS_CLASS, msg);
            throw new IllegalAttributeValueException(msg, MO_TYPE);
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(ATTRIBUTE_COUNTRY_CODE, countryCode);
        parameters.put(ATTRIBUTE_DESCRIPTION_OF_FAULT, descriptionOfFault);
        parameters.put(ATTRIBUTE_PREPARED_BY, preparedBy);
        parameters.put(ATTRIBUTE_REFERENCE, reference);
        parameters.put(ATTRIBUTE_STATE_CODE, stateCode);
        parameters.put(ATTRIBUTE_TR_NUMBER, trNumber);
        this.sendWriteRepairAction(coordinator, parameters);
        logger.traceReturn(THIS_CLASS, "actionWriteRepairDeliveryNoteToHwLog()");
    }

    private void checkValidCountryCode(String countryCode, boolean localValidCountryCode) throws IllegalAttributeValueException {
        if (!localValidCountryCode) {
            String msg = "The provided country code [" + countryCode + "] is not valid.";
            logger.traceGeneral(THIS_CLASS, msg);
            throw new IllegalAttributeValueException(msg, MO_TYPE);
        }
    }

    private void sendWriteRepairAction(Coordinator coordinator, Map parameters) throws MoAccessException {
        try {
            this.sendActionWithCfm(WRITE_REPAIR_DELIVERY_NOTE_FROM_HW_LOG, coordinator, parameters);
        }
        catch (MoAccessException exception) {
            String exceptionVariables = exception.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (result.equals(ELIB_CONST_MAOFRO_HW_LOG_ENTRY_ALREADY_EXISTS_STRING)) {
                String msg = "This RepairDeliveryNote already exists. Caught exception = " + (Object)((Object)exception);
                logger.traceGeneral(this.getClass(), msg);
                throw new RepairDeliveryNoteAlreadyExistsException(MO_TYPE, msg);
            }
            if (result.equals(ELIB_CONST_MAOFRO_HW_LOG_NO_ACCESS_STRING)) {
                String msg = "No access to the HW Log. Caught exception = " + (Object)((Object)exception);
                logger.traceGeneral(this.getClass(), msg);
                throw new NoAccessToHwLogException(MO_TYPE, msg);
            }
            logger.traceAbnormal(this.getClass(), "Exception = " + (Object)((Object)exception));
            throw exception;
        }
    }

    public void delete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        ChildHandler subTreeHandler = new ChildHandler(this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext.getMoFactoryMgrWrapper(), this.genericMaoContext.getTransactionServicesFactory(), this, MUTEX);
        subTreeHandler.deleteChildren(coordinator);
        ProductRepository.instance().deregisterSw((SoftwareProductData)this, coordinator);
        TriggerCentralWrapper.removeUpgradeParticipator((UpgradeParticipator)this);
        super.delete(coordinator);
    }

    private ManagedObject findSwAllocationThroughPiuType(Coordinator coordinator) throws MoAccessException {
        ManagedObject swa = null;
        ManagedObject piuType = this.getPiuType(coordinator);
        ManagedObject[] piuTypeReserved = (ManagedObject[])piuType.getAttribute(RESERVED_BY_ATTR, coordinator);
        ManagedObject[] repertoireReservedBy = null;
        if (piuTypeReserved != null) {
            block0: for (int i = 0; i < piuTypeReserved.length && swa == null; ++i) {
                if (!(piuTypeReserved[i] instanceof RepertoireMo) || (repertoireReservedBy = (ManagedObject[])piuTypeReserved[i].getAttribute(RESERVED_BY_ATTR, coordinator)) == null) continue;
                for (int j = 0; j < repertoireReservedBy.length; ++j) {
                    if (!(repertoireReservedBy[j] instanceof SwAllocationMo)) continue;
                    swa = repertoireReservedBy[j];
                    continue block0;
                }
            }
        }
        return swa;
    }

    public void notifyAutoConfigurationAllowed(Coordinator coordinator) {
        try {
            ChildHandler subTreeHandler = new ChildHandler(this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext.getMoFactoryMgrWrapper(), this.genericMaoContext.getTransactionServicesFactory(), this, MUTEX);
            subTreeHandler.createChildren(false, coordinator);
        }
        catch (MoAccessException e) {
            logger.traceDebug(THIS_CLASS, "Unable to autocreate children for AuxPlugInUnit: " + this.getLocalDistinguishedName());
        }
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAdministrativeState()");
        int administrativeState = (Integer)this.getAttribute(ADMINISTRATIVE_STATE_ATTR, coordinator);
        logger.traceReturn(THIS_CLASS, "getAdministrativeState(): " + ADMIN_STATE[administrativeState]);
        return administrativeState;
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getOperationalState()");
        int operationalState = (Integer)this.getAttribute(OPERATIONAL_STATE_ATTR, coordinator);
        logger.traceReturn(THIS_CLASS, "getOperationalState(): " + OPERATIONAL_STATE[operationalState]);
        return operationalState;
    }

    public final ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPiuType()");
        ManagedObject piuType = (ManagedObject)this.getAttribute(PIU_TYPE_ATTR, coordinator);
        logger.traceReturn(THIS_CLASS, "getPiuType(): " + piuType);
        return piuType;
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getResourceId()");
        int froId = this.getFroId(coordinator);
        logger.traceReturn(THIS_CLASS, "getResourceId(): " + froId);
        return froId;
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getShutDownTimer()");
        logger.traceReturn(THIS_CLASS, "getShutDownTimer()");
        return 0;
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSwAllocation()");
        ManagedObject swa = null;
        ManagedObject[] mos = (ManagedObject[])this.getAttribute(RESERVED_BY_ATTR, coordinator);
        if (mos != null) {
            for (int i = 0; i < mos.length; ++i) {
                if (!(mos[i] instanceof SwAllocationMo)) continue;
                swa = mos[i];
                logger.traceGeneral(THIS_CLASS, "Yes mo[" + i + "]  " + mos[i].getFullDistinguishedName());
                break;
            }
        }
        if (swa == null) {
            swa = this.findSwAllocationThroughPiuType(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getSwAllocation(): " + swa);
        return swa;
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.setAttribute(ADMINISTRATIVE_STATE_ATTR, LOCK, coordinator);
            } else {
                super.setAttribute(attributeName, attributeValue, coordinator);
            }
        } else {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "SetAttributes()");
        for (int i = 0; i < attributeNames.length; ++i) {
            if (ADMINISTRATIVE_STATE_ATTR.equals(attributeNames[i])) {
                this.setAttribute(attributeNames[i], attributeValues[i], coordinator);
                continue;
            }
            super.setAttribute(attributeNames[i], attributeValues[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "SetAttributes()");
    }

    public void setAdministrativeState(int state, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAdministrativeState()");
        this.setAttribute(ADMINISTRATIVE_STATE_ATTR, new Integer(state), coordinator);
        logger.traceReturn(THIS_CLASS, "setAdministrativeState()");
    }

    public void setAdministrativeStateSwitch(int newAdmState, int switchAtLock, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "setAdministrativeStateSwitch()");
        if (switchAtLock != 1 && switchAtLock != 2) {
            throw new ValueOutOfRangeException("SwitchAtLock needs to be 1 or 2.", MO_TYPE);
        }
        this.setAdministrativeState(newAdmState, coordinator);
        logger.traceReturn(THIS_CLASS, "setAdministrativeStateSwitch()");
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedobject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setPiuTypeForSwUpgrade()");
        if (managedobject == null) {
            this.setAttributeWithoutValidation(PIU_TYPE_ATTR, managedobject, coordinator);
        } else {
            this.setAttribute(PIU_TYPE_ATTR, managedobject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setPiuTypeForSwUpgrade()");
    }

    public void setShutDownTimer(int shutDownTimer, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setShutDownTimer()");
        logger.traceReturn(THIS_CLASS, "setShutDownTimer()");
    }

    private void validate(String paramName, String paramValue, int rangeMin, int rangeMax) throws LengthOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "validate()");
        if (paramValue.length() < rangeMin || paramValue.length() > rangeMax) {
            String msg = "Length of " + paramName + " not within range. Range: " + rangeMin + " - " + rangeMax;
            logger.traceGeneral(THIS_CLASS, msg);
            throw new LengthOutOfRangeException(MO_TYPE, msg);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    public void postSet(String attrName, Object attrValue, Coordinator coordinator) throws MoAccessException {
        super.postSet(attrName, attrValue, coordinator);
        if (!this.nodeIsUpgrading && PIU_TYPE_ATTR.equalsIgnoreCase(attrName) && attrValue != null) {
            ChildHandler childHandler = new ChildHandler(this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext.getMoFactoryMgrWrapper(), this.genericMaoContext.getTransactionServicesFactory(), this, MUTEX);
            childHandler.createChildren(true, coordinator);
        }
    }

    public String getFilePath(Coordinator coordinator) throws MoAccessException {
        try {
            return this.retrievePersistently("loadModuleFilePath", coordinator).toString();
        }
        catch (Exception e) {
            throw new AttributeNotSetYetException("loadModuleFilePath");
        }
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        Object productionDateObject = this.retrievePersistently(LOAD_MODULE_PRODUCTION_DATE, coordinator);
        String result = "";
        if (productionDateObject != null) {
            result = productionDateObject.toString();
        }
        return result;
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        Object productNameObject = this.retrievePersistently(LOAD_MODULE_PRODUCT_NAME, coordinator);
        String result = "";
        if (productNameObject != null) {
            result = productNameObject.toString();
        }
        return result;
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        Object productNumberObject = this.retrievePersistently(LOAD_MODULE_PRODUCT_NUMBER, coordinator);
        String result = "";
        if (productNumberObject != null) {
            result = ProductNumberHelper.convertProductNumber(productNumberObject.toString());
        }
        return result;
    }

    public int getSignatureValidationService(Coordinator arg0) throws MoAccessException {
        return 1;
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        Object productRevisionObject = this.retrievePersistently(LOAD_MODULE_PRODUCT_REVISION, coordinator);
        String result = "";
        if (productRevisionObject != null) {
            result = productRevisionObject.toString();
        }
        return result;
    }

    public String participatorName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerIndicated(UpgradeMaster upgradeMaster, String trigger) {
        logger.traceEnter(THIS_CLASS, "triggerIndicated(" + trigger + ")");
        try {
            if ("START".equalsIgnoreCase(trigger)) {
                this.nodeIsUpgrading = true;
            } else if ("FINISH".equalsIgnoreCase(trigger)) {
                this.nodeIsUpgrading = false;
                ChildHandler subTreeHandler = new ChildHandler(this.genericMaoContext.getMoRepositoryWrapper(), this.genericMaoContext.getMoFactoryMgrWrapper(), this.genericMaoContext.getTransactionServicesFactory(), this, MUTEX);
                subTreeHandler.updateChildrenAfterUpgrade();
            }
        }
        finally {
            upgradeMaster.triggerConfirmed((UpgradeParticipator)this, trigger, true);
        }
        logger.traceReturn(THIS_CLASS, "triggerIndicated(" + trigger + ", " + this.nodeIsUpgrading + ")");
    }

    private final void checkThatSwAllocationCanBeRetrievedFromPiuType(AttrList attributes, Coordinator coordinator) throws MoAccessException, MoCanNotBeCreatedException {
        ManagedObject piuType = (ManagedObject)attributes.getValue(attributes.indexOf(PIU_TYPE_ATTR));
        ManagedObject swa = null;
        ManagedObject[] piuTypeReserved = (ManagedObject[])piuType.getAttribute(RESERVED_BY_ATTR, coordinator);
        ManagedObject[] repertoireReservedBy = null;
        if (piuTypeReserved != null) {
            block0: for (int i = 0; i < piuTypeReserved.length && swa == null; ++i) {
                if (!(piuTypeReserved[i] instanceof RepertoireMo) || (repertoireReservedBy = (ManagedObject[])piuTypeReserved[i].getAttribute(RESERVED_BY_ATTR, coordinator)) == null) continue;
                for (int j = 0; j < repertoireReservedBy.length; ++j) {
                    if (!(repertoireReservedBy[j] instanceof SwAllocationMo)) continue;
                    swa = repertoireReservedBy[j];
                    continue block0;
                }
            }
        }
        if (!INITIALRBSRD_PIUTYPE.equals(piuType.getLocalDistinguishedName())) {
            this.checkSwAllocation(piuType, swa);
        }
    }

    private void checkSwAllocation(ManagedObject piuType, ManagedObject localSwa) throws MoCanNotBeCreatedException {
        if (localSwa == null) {
            String errorMsg = "The specified PiuType," + piuType.getLocalDistinguishedName() + ", must have a SwAllocation referenced from the referenced Repertoire MO";
            throw new MoCanNotBeCreatedException(errorMsg);
        }
    }

    protected void registerValidators() {
        this.registerValidator(ADMINISTRATIVE_STATE_ATTR, new ForbiddenCombinationValidator(new Integer(0), ADMINISTRATIVE_STATE_ATTR, "ENodeBFunction", "technicianPresent", Boolean.TRUE, this.genericMaoContext));
        this.registerValidator(ADMINISTRATIVE_STATE_ATTR, new ForbiddenCombinationValidator(new Integer(1), ADMINISTRATIVE_STATE_ATTR, "ENodeBFunction", "technicianPresent", Boolean.TRUE, this.genericMaoContext));
    }

    private class ResourceForRollback
    implements Resource2 {
        private final AuxPlugInUnitMao subscriber;

        public ResourceForRollback(AuxPlugInUnitMao inputSubscriber, Coordinator coordinator) {
            this.subscriber = inputSubscriber;
            try {
                coordinator.registerResource((Resource2)this);
            }
            catch (InactiveTransactionException e) {
                // empty catch block
            }
        }

        public void commit() {
        }

        public void rollback() {
            TriggerCentralWrapper.removeUpgradeParticipator((UpgradeParticipator)this.subscriber);
            ProductRepository.instance().deregisterSw((SoftwareProductData)this.subscriber);
        }

        public void prepare(Coordinator coordinator) throws PrepareFailedException {
        }
    }

    private static class AttributeNotSetYetException
    extends MoAccessException {
        private static final long serialVersionUID = 1L;

        public AttributeNotSetYetException(String attributeName) {
            super("Attribute not yet available: " + attributeName);
            this.addVariableValue("Message", "Attribute not yet available: " + attributeName);
        }
    }
}

