/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.transactions.TransactionServicesFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ChildHandler {
    private static final String RESERVED_BY_ATTRIBUTE = "reservedBy";
    private static final Class THIS_CLASS = ChildHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper repositoryWrapper;
    private final MoFactoryMgrWrapper factoryWrapper;
    private final TransactionServicesFactory transactionServicesFactory;
    private final AttrListImpl emptyAttrList;
    private final ManagedObject auxPlugInUnit;
    private final Object mutex;

    protected ChildHandler(MoRepositoryWrapper inRepositoryWrapper, MoFactoryMgrWrapper inFactoryWrapper, TransactionServicesFactory inTransactionServicesFactory, ManagedObject inAuxPlugInUnit, Object inMutex) {
        this.repositoryWrapper = inRepositoryWrapper;
        this.factoryWrapper = inFactoryWrapper;
        this.transactionServicesFactory = inTransactionServicesFactory;
        this.auxPlugInUnit = inAuxPlugInUnit;
        this.emptyAttrList = new AttrListImpl(0);
        this.mutex = inMutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createChildren(boolean bestEffort, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createChildren()");
        Object object = this.mutex;
        synchronized (object) {
            logger.traceGeneral(THIS_CLASS, "createChildren() after sync");
            PiuTypeAccess piuType = (PiuTypeAccess)this.auxPlugInUnit.getAttribute("piuType", coordinator);
            if (piuType == null) {
                logger.traceDebug(THIS_CLASS, "No PiuType specified, can not autoCreate children.");
            } else {
                Struct[] moConfiguration = piuType.getMoConfiguration(coordinator);
                if (moConfiguration == null) {
                    logger.traceDebug(THIS_CLASS, "No Mo Configuration list found. No autocreation will be performed.");
                } else {
                    this.deleteMosNotInConfiguration(piuType, moConfiguration, bestEffort, coordinator);
                    this.loopAndCreateChildren(piuType, moConfiguration, bestEffort, coordinator);
                }
            }
            logger.traceReturn(THIS_CLASS, "createChildren()");
        }
    }

    private void deleteMosNotInConfiguration(PiuTypeAccess piuType, Struct[] moConfiguration, boolean bestEffort, Coordinator coordinator) throws MoAccessException {
        List moLdnsInConfiguration = this.getMoLdnsInConfiguration(piuType, moConfiguration);
        this.deleteChildren(this.auxPlugInUnit, moLdnsInConfiguration, bestEffort, true, coordinator);
    }

    private List getMoLdnsInConfiguration(PiuTypeAccess piuType, Struct[] moConfiguration) throws MoAccessException {
        ArrayList<String> ldnList = new ArrayList<String>();
        for (int i = 0; i < moConfiguration.length; ++i) {
            String subParentLdn = piuType.getMoConfigurationHardwaresSubParentLDN(moConfiguration[i]);
            String moType = piuType.getMoConfigurationHardwareMoTypeName(moConfiguration[i]);
            String moId = piuType.getMoConfigurationMoIdentity(moConfiguration[i]);
            String parentLdn = this.auxPlugInUnit.getLocalDistinguishedName();
            if (!"".equals(subParentLdn)) {
                parentLdn = parentLdn + "," + subParentLdn;
            }
            String childLdn = parentLdn + "," + moType + "=" + moId;
            ldnList.add(childLdn);
        }
        return ldnList;
    }

    protected final Thread updateChildrenAfterUpgrade() {
        String rdn = this.auxPlugInUnit.getRelativeDistinguishedName();
        Thread updateThread = new Thread((Runnable)new ChildCreator(), "LTE_RBS_NOAMLM_AUXPLUGINUNIT=" + rdn + "_UPDATER");
        updateThread.start();
        return updateThread;
    }

    private void loopAndCreateChildren(PiuTypeAccess piuType, Struct[] moConfiguration, boolean bestEffort, Coordinator coordinator) throws MoAccessException {
        for (int i = 0; i < moConfiguration.length; ++i) {
            String parentLdn;
            ManagedObject parent;
            String subParentLdn = piuType.getMoConfigurationHardwaresSubParentLDN(moConfiguration[i]);
            String moType = piuType.getMoConfigurationHardwareMoTypeName(moConfiguration[i]);
            String moId = piuType.getMoConfigurationMoIdentity(moConfiguration[i]);
            if ("".equals(subParentLdn)) {
                parent = this.auxPlugInUnit;
                parentLdn = this.auxPlugInUnit.getLocalDistinguishedName();
            } else {
                parentLdn = this.auxPlugInUnit.getLocalDistinguishedName() + "," + subParentLdn;
                parent = this.repositoryWrapper.lookup(parentLdn);
                if (parent == null) {
                    logger.traceDebug(THIS_CLASS, "WARNING: MO Parent defined in PiuType not found under AuxPlugInUnit, parent:" + parentLdn);
                    continue;
                }
            }
            String childLdn = parentLdn + "," + moType + "=" + moId;
            if (this.repositoryWrapper.lookup(childLdn) == null) {
                this.createChild(childLdn, moType, moId, parent, bestEffort, coordinator);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Mo " + childLdn + " does already exist");
        }
    }

    private void createChild(String childLdn, String moType, String moId, ManagedObject parent, boolean bestEffort, Coordinator coordinator) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "Creating MO " + childLdn);
        MoFactory mofactory = this.factoryWrapper.lookup(moType);
        if (mofactory == null) {
            logger.traceDebug(THIS_CLASS, "WARNING:MoFactory not found " + moType);
        } else {
            try {
                mofactory.createMo(parent, (AttrList)this.emptyAttrList, moId, null, coordinator);
            }
            catch (MoAccessException mae) {
                if (bestEffort) {
                    logger.traceDebug(THIS_CLASS, "Unable create " + childLdn + " due to exception. " + ExceptionHelper.convertToString((Throwable)mae));
                }
                throw mae;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteChildren(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteChildren()");
        Object object = this.mutex;
        synchronized (object) {
            logger.traceGeneral(THIS_CLASS, "deleteChildren() after sync");
            this.deleteChildren(this.auxPlugInUnit, new ArrayList(), false, false, coordinator);
            logger.traceReturn(THIS_CLASS, "deleteChildren()");
        }
    }

    private boolean deleteChildren(ManagedObject parent, List moLdnsThatShallNotBeDeleted, boolean bestEffort, boolean keepProgramMos, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteChildren()");
        boolean childrenAreDeleted = true;
        MoIterator moiterator = parent.getChildren();
        if (moiterator != null) {
            while (moiterator.hasMoreElements()) {
                ManagedObject managedobject = moiterator.nextMo();
                boolean allDeleted = this.deleteChildren(managedobject, moLdnsThatShallNotBeDeleted, bestEffort, keepProgramMos, coordinator);
                if (allDeleted) {
                    allDeleted = this.deleteMo(managedobject, moLdnsThatShallNotBeDeleted, bestEffort, keepProgramMos, coordinator);
                }
                childrenAreDeleted &= allDeleted;
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteChildren()");
        return childrenAreDeleted;
    }

    private boolean deleteMo(ManagedObject managedobject, List moLdnsThatShallNotBeDeleted, boolean bestEffort, boolean keepProgramMos, Coordinator coordinator) throws MoHasChildrenException, MoAccessException {
        boolean moIsRemoved = false;
        if (moLdnsThatShallNotBeDeleted.contains(managedobject.getLocalDistinguishedName())) {
            logger.traceDebug(THIS_CLASS, "MO " + managedobject.getLocalDistinguishedName() + " not deleted.");
        } else if (this.isReserved(managedobject, coordinator)) {
            this.traceMoIsReservedCannotBeDeleted(managedobject, bestEffort);
        } else if (!keepProgramMos || !this.isProgramMo(managedobject)) {
            try {
                managedobject.delete(coordinator);
                moIsRemoved = true;
            }
            catch (MoHasChildrenException mhce) {
                this.traceMoHasChildrenCannotBeDeleted(managedobject, bestEffort, mhce);
            }
        }
        return moIsRemoved;
    }

    private void traceMoHasChildrenCannotBeDeleted(ManagedObject managedobject, boolean bestEffort, MoHasChildrenException mhce) throws MoHasChildrenException {
        if (!bestEffort) {
            throw mhce;
        }
        logger.traceDebug(THIS_CLASS, "Cannot delete MO " + managedobject.getLocalDistinguishedName() + ". MO has children.");
    }

    private void traceMoIsReservedCannotBeDeleted(ManagedObject managedobject, boolean bestEffort) throws MoIsReservedException {
        if (!bestEffort) {
            throw new MoIsReservedException(managedobject.getLocalDistinguishedName(), "Cannot delete MO. MO is reserved.");
        }
        logger.traceAbnormal(THIS_CLASS, "Cannot delete MO " + managedobject.getLocalDistinguishedName() + ". MO is reserved.");
    }

    private boolean isProgramMo(ManagedObject managedobject) {
        return managedobject instanceof GenericProgramBase;
    }

    private boolean isReserved(ManagedObject mo, Coordinator coordinator) {
        boolean isReserved = false;
        try {
            ManagedObject[] reservedByArray = (ManagedObject[])mo.getAttribute(RESERVED_BY_ATTRIBUTE, coordinator);
            isReserved = reservedByArray != null && reservedByArray.length > 0;
        }
        catch (NoSuchAttributeException e) {
        }
        catch (MoAccessException e) {
            // empty catch block
        }
        return isReserved;
    }

    public class MoIsReservedException
    extends MoAccessException {
        private static final long serialVersionUID = 1L;

        public MoIsReservedException(String ldn, String message) {
            super("MoIsReserved");
            this.addVariableValue("moLdn", ldn);
            this.addVariableValue("message", message);
        }
    }

    final class ChildCreator
    implements Runnable {
        ChildCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.traceEnter(THIS_CLASS, "run()");
            Object object = ChildHandler.this.mutex;
            synchronized (object) {
                logger.traceGeneral(THIS_CLASS, "run() after sync");
                TransactionFactory transFact = ChildHandler.this.transactionServicesFactory.getCppTransactionFactory();
                try {
                    Control control = transFact.create(0);
                    try {
                        ChildHandler.this.createChildren(true, control.getCoordinator());
                        try {
                            control.getTerminator().commit();
                        }
                        catch (InactiveTransactionException exception) {
                            control.getTerminator().rollback();
                            logger.traceDebug(THIS_CLASS, "Transaction inactive at update of children to " + ChildHandler.this.auxPlugInUnit.getLocalDistinguishedName());
                        }
                        catch (TransactionRolledBackException exception) {
                            logger.traceDebug(THIS_CLASS, "Transaction rolled back at update of children to " + ChildHandler.this.auxPlugInUnit.getLocalDistinguishedName());
                        }
                    }
                    catch (MoAccessException exception) {
                        control.getTerminator().rollback();
                        logger.traceDebug(THIS_CLASS, "Unable to update children to " + ChildHandler.this.auxPlugInUnit.getLocalDistinguishedName() + " due to " + ExceptionHelper.convertToString((Throwable)exception));
                    }
                }
                catch (TransactionRolledBackException exception) {
                    logger.traceDebug(THIS_CLASS, "Transaction inactive at update of children to " + ChildHandler.this.auxPlugInUnit.getLocalDistinguishedName());
                }
                catch (InactiveTransactionException exception) {
                    logger.traceDebug(THIS_CLASS, "Transaction rolled back at update of children to " + ChildHandler.this.auxPlugInUnit.getLocalDistinguishedName());
                }
                logger.traceReturn(THIS_CLASS, "run()");
            }
        }
    }
}

