/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.util.library.Lib;
import se.ericsson.crbs.cat.mao.auxpluginunit.RevisionHolder;
import se.ericsson.crbs.cat.mao.auxpluginunit.SwMatchingException;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwListItemHolder;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CompatibilityListSwMatcher {
    public static final int NO_SW_MATCH = 0;
    public static final int PRE_INSTALLED_SW = 1;
    public static final int SW_ON_DU = 2;
    protected static final String[] MATCH_CRITERIA = new String[]{"NO_SW_MATCH", "PRE_INSTALLED_SW", "SW_ON_DU"};
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String PRODUCT_REVISION = "productRevision";
    private static final Class THIS_CLASS = CompatibilityListSwMatcher.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private CompatibilityListSwMatcher() {
    }

    public static int matchAgainstLm(Struct loadModuleProductData, LmcListHolder desiredLmcListHolder) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "matchAgainstLmOnDu()");
        int result = 0;
        try {
            String loadModuleProdRev;
            String loadModuleProdNo;
            logger.traceGeneral(THIS_CLASS, "Trying to match, " + desiredLmcListHolder.getProductNumber() + "_" + desiredLmcListHolder.getProductRevision() + ", against: " + Lib.toString((Struct)loadModuleProductData));
            try {
                String tmpLoadModuleProdNo = (String)loadModuleProductData.getValue(PRODUCT_NUMBER);
                loadModuleProdNo = ProductNumberHelper.convertProductNumber(tmpLoadModuleProdNo);
                loadModuleProdRev = (String)loadModuleProductData.getValue(PRODUCT_REVISION);
            }
            catch (Exception e) {
                throw new SwMatchingException("Failed to retrieve load module product data, when matching SW", e);
            }
            RevisionHolder loadModuleRevisionHolder = new RevisionHolder(loadModuleProdRev);
            if (!loadModuleRevisionHolder.isSlashedWithANumber() && desiredLmcListHolder.getProductNumber().equalsIgnoreCase(loadModuleProdNo) && CompatibilityListSwMatcher.isGreaterThanOrEqualTo(loadModuleProdRev, desiredLmcListHolder.getProductRevision())) {
                result = 2;
                logger.traceGeneral(THIS_CLASS, "Product numbers matched and desired SW revision (" + loadModuleProdRev + ") is greater than or equal to load module SW revision: " + desiredLmcListHolder.getProductRevision());
            } else {
                SwListItemHolder[] swListItemHolders = desiredLmcListHolder.getSwListItems();
                for (int j = 0; j < swListItemHolders.length; ++j) {
                    CompatibilityListSwMatcher.checkSwListItemCompatibility(loadModuleProdNo, loadModuleProdRev, swListItemHolders[j]);
                }
                result = CompatibilityListSwMatcher.getSwMatchingResult(loadModuleProdRev, desiredLmcListHolder);
            }
            logger.traceGeneral(THIS_CLASS, "Matching of SW against the compatibility list resulted in: \"" + MATCH_CRITERIA[result] + "\"");
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "Failed to match SW on DU against the comaptibility list. Reason: " + mae.getReasonTag(), (Throwable)mae);
            throw mae;
        }
        logger.traceReturn(THIS_CLASS, "matchAgainstLmOnDu(" + result + ")");
        return result;
    }

    public static boolean isProductNumberAndRevisonCompatibleWithLmc(String productNumber, String productRevision, LmcListHolder lmcListHolder) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "isProductNumberAndRevisonCompatibleWithLmc()");
        boolean isWithinRange = false;
        try {
            logger.traceGeneral(THIS_CLASS, "Trying to match SW with product number, \"" + productNumber + "\", and product revision, \"" + productRevision + "\"" + "  with compatibility list for \"" + lmcListHolder.getProductNumber() + "-" + lmcListHolder.getProductRevision() + "\"");
            RevisionHolder loadModuleRevisionHolder = new RevisionHolder(productRevision, true);
            SwListItemHolder[] swListItemHolders = lmcListHolder.getSwListItems();
            for (int i = 0; i < swListItemHolders.length; ++i) {
                boolean stopRevOk;
                RevisionHolder startRevisionHolder = new RevisionHolder(swListItemHolders[i].getSwProductStartRevision(), true);
                RevisionHolder stopRevisionHolder = new RevisionHolder(swListItemHolders[i].getSwProductStopRevision(), true);
                String runningSwProductNumber = swListItemHolders[i].getSwProductNumber();
                boolean productNumbersOk = runningSwProductNumber.equalsIgnoreCase(productNumber);
                boolean startRevOk = loadModuleRevisionHolder.isGreaterThan(startRevisionHolder) || loadModuleRevisionHolder.equals(startRevisionHolder);
                boolean bl = stopRevOk = loadModuleRevisionHolder.isLessThan(stopRevisionHolder) || loadModuleRevisionHolder.equals(stopRevisionHolder);
                if (!productNumbersOk || !startRevOk || !stopRevOk) continue;
                isWithinRange = true;
                break;
            }
            logger.traceGeneral(THIS_CLASS, "Matching of SW (" + productNumber + "-" + productRevision + ") against the compatibility list resulted in: \"" + isWithinRange + "\"");
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "Failed to match SW on DU against the comaptibility list. Reason: " + mae.getReasonTag(), (Throwable)mae);
            throw mae;
        }
        logger.traceReturn(THIS_CLASS, "isProductNumberAndRevisonCompatibleWithLmc()");
        return isWithinRange;
    }

    private static int getSwMatchingResult(String loadModuleProdRev, LmcListHolder lmcListHolder) throws RevisionHolder.RevisionParseException {
        int result = 0;
        boolean productNumberChanged = CompatibilityListSwMatcher.isProductNumberChanged(lmcListHolder);
        boolean swOnDuPresent = CompatibilityListSwMatcher.isSwOnDuPresent(lmcListHolder);
        boolean greaterOrEqualToAll = CompatibilityListSwMatcher.isGreaterOrEqualToAll(loadModuleProdRev, lmcListHolder);
        if (greaterOrEqualToAll) {
            logger.traceGeneral(THIS_CLASS, "SW on DU is greater than ALL List Items with match \"PreInstalled SW\"");
        }
        if (productNumberChanged || swOnDuPresent && greaterOrEqualToAll) {
            result = 2;
        } else {
            boolean preInstalledPresent = CompatibilityListSwMatcher.isPreInstalledPresent(lmcListHolder);
            if (preInstalledPresent) {
                logger.traceGeneral(THIS_CLASS, "List Item with match \"PreInstalled SW\" available");
            }
            result = preInstalledPresent ? 1 : 0;
        }
        return result;
    }

    private static boolean isProductNumberChanged(LmcListHolder preInstalledSw) {
        boolean result = true;
        SwListItemHolder[] swListItemHolders = preInstalledSw.getSwListItems();
        for (int i = 0; i < swListItemHolders.length; ++i) {
            if (swListItemHolders[i].getMatchingCriteria() == 3) continue;
            result = false;
            break;
        }
        if (result) {
            logger.traceGeneral(THIS_CLASS, "Product number of RU SW has been changed - load \"SW on DU\"");
        }
        return result;
    }

    private static boolean isSwOnDuPresent(LmcListHolder preInstalledSw) {
        boolean result = false;
        SwListItemHolder[] swListItemHolders = preInstalledSw.getSwListItems();
        for (int i = 0; i < swListItemHolders.length; ++i) {
            if (swListItemHolders[i].getMatchingCriteria() != 1) continue;
            result = true;
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolders[i].getSwProductStartRevision() + ", stop: " + swListItemHolders[i].getSwProductStopRevision() + " has match \"SW on DU\"");
            break;
        }
        return result;
    }

    private static boolean isGreaterOrEqualToAll(String loadModuleProdRev, LmcListHolder preInstalledSw) throws RevisionHolder.RevisionParseException {
        boolean result = true;
        SwListItemHolder[] swListItemHolders = preInstalledSw.getSwListItems();
        for (int i = 0; i < swListItemHolders.length; ++i) {
            if (swListItemHolders[i].getMatchingCriteria() != 2 || !CompatibilityListSwMatcher.isLessThan(loadModuleProdRev, swListItemHolders[i].getSwProductStopRevision(), false)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean isPreInstalledPresent(LmcListHolder preInstalledSw) {
        boolean result = false;
        SwListItemHolder[] swListItemHolders = preInstalledSw.getSwListItems();
        for (int i = 0; i < swListItemHolders.length; ++i) {
            if (swListItemHolders[i].getMatchingCriteria() != 2) continue;
            result = true;
            break;
        }
        return result;
    }

    private static void checkSwListItemCompatibility(String loadModuleProdNo, String loadModuleProdRev, SwListItemHolder swListItemHolder) throws RevisionHolder.RevisionParseException {
        if (CompatibilityListSwMatcher.productNumbersMatch(loadModuleProdNo, swListItemHolder.getSwProductNumber())) {
            if (CompatibilityListSwMatcher.isRevisionSlashedWithANumber(loadModuleProdRev)) {
                CompatibilityListSwMatcher.handleSlashedWithANumber(loadModuleProdRev, swListItemHolder);
            } else {
                CompatibilityListSwMatcher.handleNotSlashedWithANumber(loadModuleProdRev, swListItemHolder);
            }
        } else {
            swListItemHolder.setMatchingCriteria(3);
            logger.traceGeneral(THIS_CLASS, "Pre-installed SW on RU has different product number (" + swListItemHolder.getSwProductNumber() + ") than SW on the DU (" + loadModuleProdNo + ") - \"No Match\"");
        }
    }

    private static boolean productNumbersMatch(String loadModuleProdNo, String compListProductNumber) {
        String tmpLmProdNo = StringHelper.replaceInString((String)loadModuleProdNo, (String)"%", (String)"_");
        tmpLmProdNo = StringHelper.replaceInString((String)tmpLmProdNo, (String)"/", (String)"_");
        String tmpCompListProdNo = StringHelper.replaceInString((String)compListProductNumber, (String)"%", (String)"_");
        tmpCompListProdNo = StringHelper.replaceInString((String)tmpCompListProdNo, (String)"/", (String)"_");
        return tmpLmProdNo.equalsIgnoreCase(tmpCompListProdNo);
    }

    private static void handleSlashedWithANumber(String prodRevision, SwListItemHolder swListItemHolder) {
        if (prodRevision.equalsIgnoreCase(swListItemHolder.getSwProductStartRevision()) && prodRevision.equalsIgnoreCase(swListItemHolder.getSwProductStopRevision())) {
            swListItemHolder.setMatchingCriteria(2);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " slashed with a number same as SW on DU: " + prodRevision + " - \"PreInstalled SW\"");
        } else {
            swListItemHolder.setMatchingCriteria(0);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " slashed with a number not same as SW on DU: " + prodRevision + " - \"No Match\"");
        }
    }

    private static void handleNotSlashedWithANumber(String prodRevision, SwListItemHolder swListItemHolder) throws RevisionHolder.RevisionParseException {
        RevisionHolder revisionHolder = new RevisionHolder(swListItemHolder.getSwProductStartRevision());
        if (revisionHolder.isSlashedWithANumber()) {
            swListItemHolder.setMatchingCriteria(0);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " is slashed with a number, but SW on DU: " + prodRevision + " is not - \"No Match\"");
        } else if (CompatibilityListSwMatcher.isLessThan(prodRevision, swListItemHolder.getSwProductStartRevision(), false)) {
            swListItemHolder.setMatchingCriteria(0);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " has a start revision greater than SW on DU: " + prodRevision + " - \"No Match\"");
        } else if (CompatibilityListSwMatcher.isGreaterThan(prodRevision, swListItemHolder.getSwProductStopRevision(), false)) {
            swListItemHolder.setMatchingCriteria(1);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " has a stop revision less than SW on DU: " + prodRevision + " - \"SW on DU\"");
        } else {
            swListItemHolder.setMatchingCriteria(2);
            logger.traceGeneral(THIS_CLASS, "List Item, start: " + swListItemHolder.getSwProductStartRevision() + ", stop: " + swListItemHolder.getSwProductStopRevision() + " has a stop revision greater than or equal to SW on DU: " + prodRevision + " - \"PreInstalled SW\"");
        }
    }

    private static boolean isRevisionSlashedWithANumber(String productRevision) throws RevisionHolder.RevisionParseException {
        RevisionHolder revisionHolder = new RevisionHolder(productRevision);
        return revisionHolder.isSlashedWithANumber();
    }

    public static boolean isLessThan(String prodRefToBeLeast, String prodRefToBeGreatest, boolean includeSlashedNumbers) throws RevisionHolder.RevisionParseException {
        RevisionHolder greatestRevisionHolder = new RevisionHolder(prodRefToBeGreatest, includeSlashedNumbers);
        RevisionHolder leastRevisionHolder = new RevisionHolder(prodRefToBeLeast, includeSlashedNumbers);
        return greatestRevisionHolder.isGreaterThan(leastRevisionHolder);
    }

    private static boolean isGreaterThanOrEqualTo(String prodRefToBeGreatest, String prodRefToBeLeast) throws RevisionHolder.RevisionParseException {
        RevisionHolder greatestRevisionHolder = new RevisionHolder(prodRefToBeGreatest);
        RevisionHolder leastRevisionHolder = new RevisionHolder(prodRefToBeLeast);
        return greatestRevisionHolder.equals(leastRevisionHolder) || greatestRevisionHolder.isGreaterThan(leastRevisionHolder);
    }

    public static boolean isGreaterThan(String prodRefToBeGreatest, String prodRefToBeLeast, boolean includeSlashedNumbers) throws RevisionHolder.RevisionParseException {
        RevisionHolder greatestRevisionHolder = new RevisionHolder(prodRefToBeGreatest, includeSlashedNumbers);
        RevisionHolder leastRevisionHolder = new RevisionHolder(prodRefToBeLeast, includeSlashedNumbers);
        return greatestRevisionHolder.isGreaterThan(leastRevisionHolder);
    }
}

