/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMaoImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataXmlParser;
import se.ericsson.crbs.cat.mao.pic.proxy.PicProxy;
import se.ericsson.crbs.cat.mao.pic.signals.OmfMaoPicCompatibilityListCfmSignal;
import se.ericsson.crbs.cat.mao.pic.signals.OmfMaoPicCompatibilityListRejSignal;
import se.ericsson.crbs.cat.mao.pic.signals.OmfMaoPicCompatibilityListReqSignal;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverFactoryFactory;
import se.ericsson.crbs.omf.common.proxy.SignalException;
import se.ericsson.crbs.omf.common.proxy.SignalHandler;
import se.ericsson.crbs.omf.common.proxy.SignalObject;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class RadioUnitManager
implements SignalHandler {
    private static final Class THIS_CLASS = RadioUnitManager.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final OseSenderReceiver oseSenderReceiver;
    private final PicProxy picProxy;
    private final OmfContext omfContext;

    public RadioUnitManager(PicProxy inputPicProxy, OmfContext inputOmfContext) {
        this.picProxy = inputPicProxy;
        this.omfContext = inputOmfContext;
        this.picProxy.addSignalHandler((SignalObject)new OmfMaoPicCompatibilityListReqSignal(), this);
        this.oseSenderReceiver = OseSenderReceiverFactoryFactory.getOseSenderReceiverFactory().getOseSenderReceiver();
    }

    public SignalObject request(SignalObject requestSignalObj) {
        logger.traceGeneral(THIS_CLASS, "Received new request signal: " + requestSignalObj);
        int signalNumber = requestSignalObj.getSignalNumber();
        switch (signalNumber) {
            case 24379924: {
                try {
                    this.handleCompatibilityListRequest((OmfMaoPicCompatibilityListReqSignal)requestSignalObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.traceError(THIS_CLASS, "Failed to parse identity information for the RU. Reason: " + e.getMessage(), (Throwable)e);
                }
                break;
            }
            default: {
                logger.traceAbnormal(THIS_CLASS, "Ignoring unknown signal " + signalNumber);
            }
        }
        return requestSignalObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCompatibilityListRequest(OmfMaoPicCompatibilityListReqSignal compListReqSignal) throws SAXException, IOException, ParserConfigurationException {
        String ruDataXml = compListReqSignal.getRuDataXml();
        RuDataXmlParser ruDataXmlParser = new RuDataXmlParser();
        ruDataXmlParser.parse(ruDataXml);
        RuDataHolder ruDataHolder = ruDataXmlParser.getRuDataHolder();
        MoRepositoryWrapper moRepositoryWrapper = this.omfContext.getMoRepositoryWrapper();
        ManagedObject managedObject = moRepositoryWrapper.lookup(ruDataHolder.getLdn());
        if (this.isAuxPlugInUnitMaoImpl(managedObject)) {
            AuxPlugInUnitMaoImpl auxPlugInUnitMaoImpl = (AuxPlugInUnitMaoImpl)managedObject;
            auxPlugInUnitMaoImpl.storeRuDataHolder(ruDataHolder);
            auxPlugInUnitMaoImpl.storeCompatibilityListXml(compListReqSignal.getCompatibilityListXml());
            auxPlugInUnitMaoImpl.storeRunningLmcInfoXml(compListReqSignal.getRunningLmcInfo());
            Control control = null;
            try {
                TransactionFactory transFact = this.omfContext.getGenericMaoContext("AuxPlugInUnit").getTransactionServicesFactory().getCppTransactionFactory();
                control = transFact.create(0);
            }
            catch (TransactionRolledBackException trbe) {
                logger.traceError(THIS_CLASS, "Failed to create transaction for call to \"reconfigureProgramPrepare\", on AuxPlugInUnit MO. Reason: " + trbe.reason, (Throwable)trbe);
            }
            if (this.isControlOk(control)) {
                Coordinator coordinator = control.getCoordinator();
                try {
                    auxPlugInUnitMaoImpl.setTriggeredFromNodeControl();
                    String loadModuleFilePath = "";
                    try {
                        auxPlugInUnitMaoImpl.actionReconfigureProgramPrepare(coordinator);
                        loadModuleFilePath = auxPlugInUnitMaoImpl.getFilePath(coordinator);
                        control.getTerminator().commit();
                    }
                    finally {
                        this.sendResponse(loadModuleFilePath, compListReqSignal, auxPlugInUnitMaoImpl);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.traceError(THIS_CLASS, "Call to \"reconfigureProgramPrepare\", on AuxPlugInUnit MO, failed. Reason: " + e.getMessage(), (Throwable)e);
                    try {
                        control.getTerminator().rollback();
                    }
                    catch (InactiveTransactionException ite) {
                        logger.traceError(THIS_CLASS, "Failed to rollback transaction when calling \"reconfigureProgramPrepare\" on AuxPlugInUnit MO. Reason: " + ite.reason, (Throwable)ite);
                    }
                }
            }
        } else {
            logger.traceError(THIS_CLASS, "Failed to resolve AuxPlugInUnit MO for LDN: \"" + ruDataHolder.getLdn() + "\"");
        }
    }

    private void sendResponse(String loadmoduleFilePath, OmfMaoPicCompatibilityListReqSignal compListReqSignal, AuxPlugInUnitMaoImpl auxPlugInUnitMaoImpl) throws MoAccessException {
        OseProcess sender = this.oseSenderReceiver.getSender((InSignal)compListReqSignal.getOseSignal());
        if (auxPlugInUnitMaoImpl.getRuSwResult() == 1) {
            this.sendConfirm(this.oseSenderReceiver.getThisProcess(), sender, false, "", compListReqSignal);
        } else if (auxPlugInUnitMaoImpl.getRuSwResult() == 3) {
            this.sendConfirm(this.oseSenderReceiver.getThisProcess(), sender, true, loadmoduleFilePath, compListReqSignal);
        } else if (auxPlugInUnitMaoImpl.getRuSwResult() == 2) {
            this.sendReject(this.oseSenderReceiver.getThisProcess(), sender, compListReqSignal);
        }
    }

    private boolean isControlOk(Control control) {
        boolean controlOk = true;
        if (control == null) {
            controlOk = false;
            logger.traceAbnormal(THIS_CLASS, "Could not create a control from the transaction factory");
        }
        return controlOk;
    }

    private boolean isAuxPlugInUnitMaoImpl(ManagedObject managedObject) {
        return managedObject != null && managedObject instanceof AuxPlugInUnitMaoImpl;
    }

    private void sendConfirm(OseProcess sender, OseProcess receiver, boolean inconclusive, String lmFilePath, OmfMaoPicCompatibilityListReqSignal compListReqSignal) {
        OmfMaoPicCompatibilityListCfmSignal cfm = new OmfMaoPicCompatibilityListCfmSignal();
        cfm.setClientRef(compListReqSignal.getClientRef());
        cfm.setServerRef(compListReqSignal.getServerRef());
        cfm.setInconclusive(inconclusive);
        cfm.setLmFilePath(lmFilePath);
        try {
            this.picProxy.sendSignal(sender, receiver, (Signal)cfm.getOseSignal());
            logger.traceGeneral(THIS_CLASS, "Sent confirm to NC. Inconclusive: " + inconclusive + " - LM file path: \"" + lmFilePath + "\"");
        }
        catch (SignalException se) {
            logger.traceError(THIS_CLASS, "Failed to send confirm signal to Node Control. Reason: " + se.getMessage(), (Throwable)se);
        }
    }

    private void sendReject(OseProcess sender, OseProcess receiver, OmfMaoPicCompatibilityListReqSignal compListReqSignal) {
        OmfMaoPicCompatibilityListRejSignal rej = new OmfMaoPicCompatibilityListRejSignal();
        rej.setClientRef(compListReqSignal.getClientRef());
        rej.setServerRef(compListReqSignal.getServerRef());
        try {
            this.picProxy.sendSignal(sender, receiver, (Signal)rej.getOseSignal());
        }
        catch (SignalException se) {
            logger.traceError(THIS_CLASS, "Failed to send reject signal to Node Control. Reason: " + se.getMessage(), (Throwable)se);
        }
    }
}

