/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit.helper;

import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class RbsConfigurationAutoConfigHelper
implements AvcSubscriber {
    private static final Class THIS_CLASS = RbsConfigurationAutoConfigHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String AUTO_CONFIGURATION_ALLOWED = "autoConfigurationAllowed";
    private static RbsConfigurationAutoConfigHelper instance;
    private OmfContext omfContext;
    protected boolean retrievedNotification = false;

    private RbsConfigurationAutoConfigHelper() {
    }

    public void start(OmfContext inputOmfContext) {
        logger.traceEnter(THIS_CLASS, "start()");
        this.omfContext = inputOmfContext;
        Runnable handler = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RbsConfigurationAutoConfigHelper.this.startService();
            }
        };
        Thread autoConfThread = new Thread(handler, "CRBS_lmCatOamLmU_AutoConfiguration");
        autoConfThread.start();
        logger.traceReturn(THIS_CLASS, "start()");
    }

    public void stop() {
        try {
            this.omfContext.getGenericMaoContext("AuxPlugInUnit").getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "ManagedElementData", AUTO_CONFIGURATION_ALLOWED);
            this.omfContext.getGenericMaoContext("AuxPlugInUnit").getAvcRegistratorFactory().getAvcRegistrator().stopSubscriptions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startService() {
        while (true) {
            try {
                this.omfContext.getGenericMaoContext("AuxPlugInUnit").getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "ManagedElementData", AUTO_CONFIGURATION_ALLOWED);
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Node not up, waiting..");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    logger.traceDebug(THIS_CLASS, "Interrupted during sleep");
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbsConfigurationAutoConfigHelper getInstance() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (instance == null) {
                instance = new RbsConfigurationAutoConfigHelper();
            }
            return instance;
        }
    }

    public void reportChange() {
        logger.traceEnter(THIS_CLASS, "reportChange()");
        MoIterator auxPiuIter = this.omfContext.getMoRepositoryWrapper().lookupType("AuxPlugInUnit");
        if (auxPiuIter == null) {
            logger.traceDebug(THIS_CLASS, "No AuxPlugInUnit found.");
        } else {
            block3: while (auxPiuIter.hasMoreElements()) {
                AuxPlugInUnitMao aux = (AuxPlugInUnitMao)auxPiuIter.nextMo();
                while (true) {
                    TransactionFactory transFact = this.omfContext.getGenericMaoContext("AuxPlugInUnit").getTransactionServicesFactory().getCppTransactionFactory();
                    try {
                        Control control = transFact.create(0);
                        Coordinator coordinator = control.getCoordinator();
                        aux.notifyAutoConfigurationAllowed(coordinator);
                        control.getTerminator().commit();
                        continue block3;
                    }
                    catch (TransactionRolledBackException trbe) {
                        logger.traceDebug(THIS_CLASS, "Trying to notify AuxPlugInUnit(" + aux.getLocalDistinguishedName() + ") but got exception: " + trbe.getMessage());
                        continue;
                    }
                    catch (InactiveTransactionException ite) {
                        logger.traceDebug(THIS_CLASS, "Trying to notify AuxPlugInUnit(" + aux.getLocalDistinguishedName() + ") but got exception: " + ite.getMessage());
                        continue;
                    }
                    break;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "reportChange()");
    }

    public void reportAvc(String ldn, String attributeName, Object attributeValue, Coordinator coordinator) {
        if (AUTO_CONFIGURATION_ALLOWED.equalsIgnoreCase(attributeName) && ((Boolean)attributeValue).booleanValue()) {
            this.notifyAuxPluginUnits();
        }
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        ManagedElementDataMo mo;
        boolean isAutoConfigurationAllowed;
        if (!this.retrievedNotification && (isAutoConfigurationAllowed = (mo = (ManagedElementDataMo)this.omfContext.getMoRepositoryWrapper().lookupType("ManagedElementData").nextElement()).getAutoConfigurationAllowed(coordinator))) {
            this.notifyAuxPluginUnits();
        }
    }

    private void notifyAuxPluginUnits() {
        this.reportChange();
        this.retrievedNotification = true;
    }
}

