/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.devicegroup;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.devicegroup.DeviceGroupMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class DeviceGroupMaoImpl
extends GenericMao
implements DeviceGroupMao {
    private static final Class THIS_CLASS = DeviceGroupMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String TR_DEVICE_SET = "TrDeviceSet";
    private static final String XMU_DEVICE_SET = "XmuDeviceSet";
    private static final String RDIC_DEVICE_SET = "RdicDeviceSet";

    public DeviceGroupMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "DeviceGroup", aGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
    }

    public DeviceGroupMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete()");
        MoIterator childrenIter = this.getChildren();
        if (childrenIter != null) {
            while (childrenIter.hasMoreElements()) {
                ManagedObject child = childrenIter.nextMo();
                if (!TR_DEVICE_SET.equals(child.getType()) && !XMU_DEVICE_SET.equals(child.getType()) && !RDIC_DEVICE_SET.equals(child.getType())) continue;
                logger.traceDebug(THIS_CLASS, "Deleting MO: " + child);
                child.delete(coordinator);
            }
        }
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    public AttrList addFroParametersAtCreate(AttrList allAttributesList, AttrList notUsedList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        ManagedObject myParent = this.getParent();
        int piuFroId = 1;
        if (myParent instanceof GenPmMao) {
            piuFroId = ((GenPmMao)myParent).getFroId(coordinator);
            logger.traceGeneral(THIS_CLASS, "PIU, piuFroId=" + piuFroId);
        } else if (myParent instanceof GenericMao) {
            piuFroId = ((GenericMao)myParent).getFroId(coordinator);
            logger.traceGeneral(THIS_CLASS, "AuxPIU, piuFroId=" + piuFroId);
        } else {
            logger.traceGeneral(THIS_CLASS, "OTHER (" + myParent.getClass() + "), piuFroId=" + piuFroId);
        }
        ((AttrListImpl)allAttributesList).addAttribute("piuFroId", (Object)new Integer(piuFroId));
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return super.addFroParametersAtCreate(allAttributesList, notUsedList, coordinator);
    }
}

