/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.ima.handler;

import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ImaRequestXmlHandler
extends DefaultHandler {
    private static final Class THIS_CLASS = ImaRequestXmlHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private Set ldns;
    private static final String expectedVersion = "R1A";

    public Set getLdns() {
        return this.ldns;
    }

    public void startDocument() throws SAXException {
        this.ldns = new HashSet();
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement " + qName);
        if ("ima".equals(qName)) {
            this.verifyVersion(qName, attributes);
        } else if ("request".equals(qName)) {
            this.storeLdn(qName, attributes);
        } else {
            throw new SAXException("Unknown element received \"" + qName + "\"");
        }
        logger.traceReturn(this.getClass(), "startElement");
    }

    private void storeLdn(String qName, Attributes attributes) throws SAXException {
        boolean found = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equals("ldn")) {
                if (found) {
                    throw new SAXException("Multiple attribute <" + attributes.getQName(i) + "> for <" + qName + "> received. Only one allowed!");
                }
            } else {
                throw new SAXException("Only version allowed as attribute for \"" + qName + "\", received: \"" + attributes.getQName(i) + "\"");
            }
            this.ldns.add(attributes.getValue(i));
            found = true;
        }
    }

    private void verifyVersion(String qName, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equalsIgnoreCase("version")) {
                if (attributes.getValue(i).equals(expectedVersion)) continue;
                throw new SAXException("Wrong IMA XML version " + attributes.getValue(i) + ". Expected " + expectedVersion);
            }
            throw new SAXException("Only version allowed as attribute for \"" + qName + "\", received: \"" + attributes.getQName(i) + "\"");
        }
    }

    public void error(SAXParseException saxParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse error " + saxParseException.toString());
        throw new SAXException(saxParseException);
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse warning " + saxParseException.toString());
        throw new SAXException(saxParseException);
    }

    public void warning(SAXParseException saxParseException) throws SAXException {
        logger.traceAbnormal(THIS_CLASS, "Ignoring XML parse warning " + saxParseException.toString());
    }
}

