/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.ima.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.crbs.cat.mao.ima.signals.AbstractOmfMaoImaReadReqOseSignal;
import se.ericsson.crbs.cat.mao.ima.signals.OmfMaoImaNcReadReqOseSignal;
import se.ericsson.crbs.cat.mao.ima.signals.OmfMaoImaNcReadReqSignal;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalObject;
import se.ericsson.crbs.omf.common.proxy.IllegalSignalException;
import se.ericsson.crbs.omf.common.proxy.SignalException;
import se.ericsson.crbs.omf.common.proxy.SignalHandler;
import se.ericsson.crbs.omf.common.proxy.SignalObject;

public class ImaProxy
extends AbstractSignalConverter
implements Runnable {
    private static final Class THIS_CLASS = ImaProxy.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String IMA_SERVICE_NAME = "CRBS_OMF_MAO_IMA_SERVICE_NAME";
    private static final Class[] INPUT_SIGNALS = new Class[]{OmfMaoImaNcReadReqOseSignal.class};

    public ImaProxy() {
        super(IMA_SERVICE_NAME, INPUT_SIGNALS);
    }

    public void inputSignalReceived(InSignal inSignal) throws IllegalSignalException {
        logger.traceEnter(THIS_CLASS, "inputSignalReceived(" + inSignal + ")");
        try {
            switch (inSignal.getSigNo()) {
                case 24379908: {
                    this.handleNcReadRequest(inSignal);
                    break;
                }
                default: {
                    String msg = "Ignoring unexpected signal " + inSignal.getSigNo();
                    logger.traceAbnormal(THIS_CLASS, msg);
                    throw new IllegalSignalException(msg);
                }
            }
        }
        catch (IllegalStateException e) {
            String msg = "Ignoring illegal signal " + inSignal.getSigNo() + ". " + e.toString();
            logger.traceError(THIS_CLASS, msg);
            throw new IllegalSignalException(msg);
        }
        logger.traceReturn(THIS_CLASS, "inputSignalReceived(" + inSignal + ")");
    }

    private void handleNcReadRequest(InSignal inSignal) {
        OmfMaoImaNcReadReqOseSignal omfMaoImaNcReadReqOseSignal = (OmfMaoImaNcReadReqOseSignal)inSignal;
        if (this.identicalToTheNextSignalInQueue(omfMaoImaNcReadReqOseSignal)) {
            logger.traceAbnormal(THIS_CLASS, "Skipping redundant NC read request with data:" + omfMaoImaNcReadReqOseSignal.getData());
        } else {
            OmfMaoImaNcReadReqSignal ncReadReqSignal = new OmfMaoImaNcReadReqSignal();
            ncReadReqSignal.setOseSignal(omfMaoImaNcReadReqOseSignal);
            this.getAndReturnAnswerFromHandlers(this.getSender(inSignal), (SignalObject)ncReadReqSignal);
        }
    }

    private boolean identicalToTheNextSignalInQueue(AbstractOmfMaoImaReadReqOseSignal requestSignal) {
        InSignal nextInSignal = this.peekSignalQueue();
        boolean signalsAreIdentical = false;
        if (nextInSignal != null && nextInSignal instanceof AbstractOmfMaoImaReadReqOseSignal) {
            AbstractOmfMaoImaReadReqOseSignal nextRequestSignal = (AbstractOmfMaoImaReadReqOseSignal)nextInSignal;
            signalsAreIdentical = nextRequestSignal.getData().equalsIgnoreCase(requestSignal.getData()) && this.getSender((InSignal)nextRequestSignal).equals((Object)this.getSender((InSignal)requestSignal));
        }
        return signalsAreIdentical;
    }

    protected void getAndReturnAnswerFromHandlers(OseProcess sender, SignalObject readReqSignal) {
        logger.traceEnter(THIS_CLASS, "getAndReturnAnswerFromHandlers()");
        SignalHandler[] signalHandlerArray = this.getSignalHandlers(readReqSignal);
        if (signalHandlerArray.length > 0) {
            for (int i = 0; i < signalHandlerArray.length; ++i) {
                try {
                    AbstractSignalObject signalClone = (AbstractSignalObject)readReqSignal.clone();
                    SignalObject sigObj = signalHandlerArray[i].request((SignalObject)signalClone);
                    this.handleResponse(sender, signalClone, sigObj);
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupported) {
                    logger.traceError(THIS_CLASS, "Can't clone signal: " + cloneNotSupported.toString());
                }
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, "No registred handler for signal " + readReqSignal.getSignalNumber());
        }
        logger.traceReturn(THIS_CLASS, "getAndReturnAnswerFromHandlers()");
    }

    private void handleResponse(OseProcess sender, AbstractSignalObject signalClone, Object sigObj) {
        if (sigObj == null) {
            logger.traceAbnormal(THIS_CLASS, "Handler of signal " + signalClone.getDescription() + " return a null signal. Can't send this signal to " + (sender == null ? "NO SENDER" : sender.toString()));
        } else {
            AbstractSignalObject cfm = (AbstractSignalObject)sigObj;
            try {
                this.sendSignal(this.inputThreadProcess, sender, (Signal)cfm.getOseSignal());
            }
            catch (SignalException se) {
                logger.traceAbnormal(THIS_CLASS, "Error when sending comfirm " + cfm.getDescription() + " signal to " + (sender == null ? "NO SENDER" : sender.toString()) + ": " + se.toString());
            }
        }
    }
}

