/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.AbstractRuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncorrectCompatibilityListHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuIncorrectCompatibilityListHandlerImpl
extends AbstractRuHandler
implements RuIncorrectCompatibilityListHandler {
    private static final Class THIS_CLASS = RuIncorrectCompatibilityListHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";

    public RuIncorrectCompatibilityListHandlerImpl(AuxPlugInUnitMao auxPlugInUnitMao, GenericMaoContext genericMaoContext) {
        super(auxPlugInUnitMao, genericMaoContext);
    }

    public void handleIncorrectCompatibilityList(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleIncorrectCompatibilityList()");
        boolean xpProgramCreated = this.createLoadModuleAndXpProgram(true, ruDataHolder, localCoordinator);
        if (xpProgramCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for incorrect compatibility list");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for incorrect compatibility list");
        }
        logger.traceReturn(THIS_CLASS, "handleIncorrectCompatibilityList()");
    }

    public void handleIncorrectRunningLmcInfo(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleIncorrectRunningLmcInfo()");
        boolean xpProgramCreated = this.createLoadModuleAndXpProgram(false, ruDataHolder, localCoordinator);
        if (xpProgramCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for incorrect running LMC info");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for incorrect running LMC info");
        }
        logger.traceReturn(THIS_CLASS, "handleIncorrectRunningLmcInfo()");
    }

    private boolean createLoadModuleAndXpProgram(boolean compatibilityListFaulty, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        String productNumber;
        String filePath;
        this.preInstalledUsed = false;
        if (compatibilityListFaulty) {
            filePath = "compLstFault/FaultyCompatibilityList";
            productNumber = "FaultyCompList";
        } else {
            filePath = "compLstFault/FaultyRunningLmcInfo";
            productNumber = "FaultyRunningLmcInfo";
        }
        String productInfo = "compLstFault";
        String productionDate = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING);
        String productName = ruDataHolder.getProductName();
        String productRevision = "-";
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("compLstFault", productionDate, productName, productNumber, "-");
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, filePath, loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        return xpProgramMoHolder.isCreated;
    }
}

