/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.AbstractRuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuPreInstalledSwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuPreInstalledSwHandlerImpl
extends AbstractRuHandler
implements RuPreInstalledSwHandler {
    private static final Class THIS_CLASS = RuPreInstalledSwHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";

    public RuPreInstalledSwHandlerImpl(AuxPlugInUnitMao auxPlugInUnitMao, GenericMaoContext genericMaoContext) {
        super(auxPlugInUnitMao, genericMaoContext);
    }

    public void handlePreInstalledSw(boolean genericPiuType, LmcListHolder preInstalledLmcListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePreInstalledSw()");
        this.preInstalledUsed = true;
        String productInfo = "preinsSW";
        String tmpProductionDate = preInstalledLmcListHolder.getProductionDate();
        String productionDate = tmpProductionDate == null || tmpProductionDate.equalsIgnoreCase("") ? DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING) : StringHelper.replaceInString((String)tmpProductionDate, (String)"-", (String)"");
        String productName = ruDataHolder.getProductName();
        String productNumber = preInstalledLmcListHolder.getProductNumber();
        String productRevision = preInstalledLmcListHolder.getProductRevision();
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("preinsSW", productionDate, productName, productNumber, productRevision);
        String productNumberWithoutSlash = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevisionWithoutSlash = ProductNumberHelper.convertSlashToPercent(productRevision);
        String filePath = "preinsSW/" + productNumberWithoutSlash + "_" + productRevisionWithoutSlash;
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, filePath, loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            if (genericPiuType) {
                logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for generic PiuType - preinstalled SW");
            } else {
                logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for a normal PiuType - preinstalled SW");
            }
        } else if (genericPiuType) {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for generic PiuType - preinstalled SW");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for a normal PiuType - preinstalled SW");
        }
        logger.traceReturn(THIS_CLASS, "handlePreInstalledSw()");
    }
}

