/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwListItemHolder;

public class LmcListHolder
implements Comparable {
    private String productNumber = "";
    private String productRevision = "";
    private String productionDate = "";
    private boolean preInstalled = false;
    private final List swListItemsList = new ArrayList();

    public void resetMatchingCriteria() {
        for (int i = 0; i < this.swListItemsList.size(); ++i) {
            SwListItemHolder swListItemHolder = (SwListItemHolder)this.swListItemsList.get(i);
            swListItemHolder.setMatchingCriteria(-1);
        }
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public void setProductNumber(String inputProductNumber) {
        this.productNumber = ProductNumberHelper.convertProductNumber(inputProductNumber);
    }

    public String getProductRevision() {
        return this.productRevision;
    }

    public void setProductRevision(String inputProductRevision) {
        this.productRevision = inputProductRevision;
    }

    public String getProductionDate() {
        return this.productionDate;
    }

    public void setProductionDate(String inputProductionDate) {
        this.productionDate = inputProductionDate;
    }

    public boolean isPreInstalled() {
        return this.preInstalled;
    }

    public void setPreInstalled(boolean lmPreInstalled) {
        this.preInstalled = lmPreInstalled;
    }

    public SwListItemHolder[] getSwListItems() {
        Object[] swListItemHolders = new SwListItemHolder[this.swListItemsList.size()];
        this.swListItemsList.toArray(swListItemHolders);
        Arrays.sort(swListItemHolders);
        return swListItemHolders;
    }

    public void addSwListItem(SwListItemHolder swListItem) {
        this.swListItemsList.add(swListItem);
    }

    public int compareTo(Object otherObj) {
        LmcListHolder otherLmcListHolder;
        int result = 0;
        result = otherObj instanceof LmcListHolder ? ((otherLmcListHolder = (LmcListHolder)otherObj).isPreInstalled() ? 1 : (this.preInstalled ? -1 : (this.productNumber.equals(otherLmcListHolder.getProductNumber()) ? this.productRevision.compareTo(otherLmcListHolder.getProductRevision()) : this.productNumber.compareTo(otherLmcListHolder.getProductNumber())))) : 0;
        return result;
    }

    public String toString() {
        StringBuffer contents = new StringBuffer(1000);
        contents.append("LM product number: \"").append(this.productNumber).append("\"\nLM product revision: \"").append(this.productRevision).append("\"\nLM preinstalled: \"").append(this.preInstalled).append("\"\n");
        SwListItemHolder[] swListItemHolders = this.getSwListItems();
        for (int i = 0; i < swListItemHolders.length; ++i) {
            contents.append(swListItemHolders[i].toString());
            if (i >= swListItemHolders.length - 1) continue;
            contents.append('\n');
        }
        return contents.toString();
    }
}

