/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RuDataXmlParser
extends DefaultHandler {
    private static final String RADIO_UNIT_TAG = "RadioUnitData";
    private static final String IDENTITY_TAG = "Identity";
    private static final String HW_PID_TAG = "HwPid";
    private static final String LDN_TAG = "ldn";
    private static final String PRODUCT_NAME_TAG = "productName";
    private static final String PRODUCT_NUMBER_TAG = "productNumber";
    private static final String PRODUCT_REVISION_TAG = "productRevision";
    private static final String SERIAL_NUMBER_TAG = "serialNumber";
    private static final Class THIS_CLASS = RuDataXmlParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private RuDataHolder ruDataHolder = new RuDataHolder();

    public RuDataHolder getRuDataHolder() {
        return this.ruDataHolder;
    }

    public void parse(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
        ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
        InputSource input = new InputSource(bais);
        logger.traceGeneral(THIS_CLASS, "xmlString: \"" + xmlString + "\"");
        saxParser.parse(input, (DefaultHandler)this);
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if (RADIO_UNIT_TAG.equals(qName)) {
            this.ruDataHolder = new RuDataHolder();
        } else if (IDENTITY_TAG.equals(qName)) {
            this.handleIdentity(attributes);
        } else if (HW_PID_TAG.equals(qName)) {
            this.handleHwPid(attributes);
        }
    }

    private void handleIdentity(Attributes attributes) {
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (!LDN_TAG.equals(attributes.getQName(index))) continue;
            this.ruDataHolder.setLdn(attributes.getValue(index));
        }
    }

    private void handleHwPid(Attributes attributes) {
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (PRODUCT_NAME_TAG.equals(attributes.getQName(index))) {
                this.ruDataHolder.setProductName(attributes.getValue(index));
                continue;
            }
            if (PRODUCT_NUMBER_TAG.equals(attributes.getQName(index))) {
                String productNumber = attributes.getValue(index);
                productNumber = ProductNumberHelper.convertProductNumber(productNumber);
                this.ruDataHolder.setProductNumber(productNumber);
                continue;
            }
            if (PRODUCT_REVISION_TAG.equals(attributes.getQName(index))) {
                this.ruDataHolder.setProductRevision(attributes.getValue(index));
                continue;
            }
            if (!SERIAL_NUMBER_TAG.equals(attributes.getQName(index))) continue;
            this.ruDataHolder.setSerialNumber(attributes.getValue(index));
        }
    }

    public void error(SAXParseException saxParseException) throws SAXException {
        String msg = "error()";
        logger.traceEnter(THIS_CLASS, "error()");
        logger.traceAbnormal(THIS_CLASS, saxParseException.getMessage());
        logger.traceReturn(THIS_CLASS, "error()");
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        String msg = "fatalError()";
        logger.traceEnter(THIS_CLASS, "fatalError()");
        logger.traceAbnormal(THIS_CLASS, saxParseException.getMessage());
        logger.traceReturn(THIS_CLASS, "fatalError()");
    }
}

