/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.nodeaddresschange;

import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChange;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChangeInformer;
import se.ericsson.crbs.cat.mao.nodeaddresschange.MoRepositoryHelper;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeParams;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class NodeAddressChangeHandler
extends TimerTask
implements Runnable,
NodeAddressChange {
    private static final Class THIS_CLASS = NodeAddressChangeHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int POLLING_TIME = 10000;
    private final Timer timer = new Timer();
    private boolean timerStarted = false;
    private MoRepositoryWrapper moRepository;
    private NodeAddressChangeInformer addressChangeInformer;
    private NodeAddressChangeParams nodeAddressChangeParams;

    public NodeAddressChangeHandler(MoRepositoryWrapper moRepositoryIn) {
        logger.traceEnter(THIS_CLASS, "NodeAddressChangeHandler constructor");
        this.moRepository = moRepositoryIn;
        logger.traceReturn(THIS_CLASS, "NodeAddressChangeHandler constructor");
    }

    public void setParameters(NodeAddressChangeParams paramsIn) {
        logger.traceEnter(THIS_CLASS, "setParameters()");
        this.nodeAddressChangeParams = paramsIn;
        logger.traceReturn(THIS_CLASS, "setParameters()");
    }

    public void run() {
        logger.traceEnter(THIS_CLASS, "run()");
        boolean continueExecution = true;
        if (this.nodeAddressChangeParams == null) {
            continueExecution = false;
            logger.traceDebug(THIS_CLASS, "nodeAddressChangeParams is null.");
        }
        String[] ipAddresses = null;
        if (continueExecution && (ipAddresses = MoRepositoryHelper.getIpMoAddresses(this.moRepository)).length == 0) {
            continueExecution = false;
            logger.traceAbnormal(THIS_CLASS, "No IpMo addresses found");
        }
        String[] hostLinkDynamicModeIpAddresses = null;
        if (continueExecution) {
            hostLinkDynamicModeIpAddresses = MoRepositoryHelper.getCheckForHostLinkDynamicIpAddresses(this.moRepository, ipAddresses, 0);
            if (hostLinkDynamicModeIpAddresses.length > 1) {
                continueExecution = false;
                logger.traceDebug(THIS_CLASS, "Found " + hostLinkDynamicModeIpAddresses.length + " hostLinkIKEModeIpAddresses.");
            } else if (hostLinkDynamicModeIpAddresses.length < 1 && (hostLinkDynamicModeIpAddresses = MoRepositoryHelper.getCheckForHostLinkDynamicIpAddresses(this.moRepository, ipAddresses, 1)).length != 1) {
                continueExecution = false;
                logger.traceDebug(THIS_CLASS, "Found " + hostLinkDynamicModeIpAddresses.length + " hostLinkDhcpModeIpAddresses.");
            }
        }
        if (continueExecution && MoRepositoryHelper.getIpHostLinkCount(this.moRepository) == 1) {
            String newIpAddress = hostLinkDynamicModeIpAddresses[0];
            String oldIpAddress = this.nodeAddressChangeParams.getIpAddress();
            logger.traceDebug(THIS_CLASS, "Old address: " + oldIpAddress + ", new address: " + newIpAddress);
            if (!newIpAddress.equals(oldIpAddress)) {
                this.nodeAddressChangeParams.setIpAddress(newIpAddress);
                if (!this.nodeAddressChanged()) {
                    this.nodeAddressChangeParams.setIpAddress(oldIpAddress);
                    logger.traceAbnormal(THIS_CLASS, "Failed to send address change to OSS.");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "run()");
    }

    private boolean nodeAddressChanged() {
        boolean result;
        logger.traceEnter(THIS_CLASS, "nodeAddressChanged()");
        if (this.addressChangeInformer == null) {
            this.addressChangeInformer = MoRepositoryHelper.getNodeAddressChangeInformer(this.moRepository);
        }
        boolean bl = result = this.addressChangeInformer != null;
        if (result) {
            this.addressChangeInformer.informOss(this.nodeAddressChangeParams);
        }
        logger.traceReturn(THIS_CLASS, "nodeAddressChanged()");
        return result;
    }

    public void start() {
        logger.traceEnter(THIS_CLASS, "start()");
        this.stop();
        this.timer.schedule((TimerTask)this, 10000L, 10000L);
        this.timerStarted = true;
        logger.traceReturn(THIS_CLASS, "start()");
    }

    public void stop() {
        logger.traceEnter(THIS_CLASS, "stop()");
        if (this.timerStarted) {
            this.timer.cancel();
            this.timerStarted = false;
        }
        logger.traceReturn(THIS_CLASS, "stop()");
    }
}

