/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.retsubunit;

import java.io.File;
import java.util.TreeMap;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.ftp.FtpFaultNumberTranslationHelper;
import se.ericsson.crbs.cat.mao.retsubunit.ForceCalibrationFailureException;
import se.ericsson.crbs.cat.mao.retsubunit.RetSubUnitMao;
import se.ericsson.crbs.cat.mao.retsubunit.SendAntennaConfigurationFileFailureException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.ArrayHelper;
import se.ericsson.crbs.omf.mao.commonmo.NoConnectionWithUnitException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class RetSubUnitMaoImpl
extends GenericMao
implements RetSubUnitMao,
LogContentInspector {
    private static final Class THIS_CLASS = RetSubUnitMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)RetSubUnitMaoImpl.class.getName());
    private static final String ACTION_FORCE_CALIBRATION = "forceCalibration";
    private static final String ACTION_SEND_ANTENNA_CONFIGURATION_FILE = "sendAntennaConfigurationFile";
    private static final int LTERBS_RESULT_CODE_BASE = 0x1000000;
    private static final int LTERBS_NC_RESULT_CODE_BASE = 0x1000000;
    private static final int RESULT_NOT_OK = 1;
    protected final int RESULT_NO_CONNECTION_WITH_UNIT = 0x1000006;
    protected final int RESULT_FORCE_CALIBRATION_FAILURE_EXCEPTION = 1;
    protected final int RESULT_SEND_ANTENNA_CONFIGURATION_FILE_FAILURE_EXCEPTION = 1;
    private final String RESULT_NO_CONNECTION_WITH_UNIT_STRING = Integer.toString(0x1000006);
    private final String RESULT_FORCE_CALIBRATION_FAILURE_EXCEPTION_STRING = Integer.toString(1);
    private final String RESULT_SEND_ANTENNA_CONFIGURATION_FILE_FAILURE_EXCEPTION_STRING = Integer.toString(1);
    private static final String LOCAL_FILE_PATH = "/c/usr/";

    public RetSubUnitMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext inputGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "RetSubUnit", inputGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "RetSubUnitMaoImpl() - constructor");
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "RetSubUnit");
        logger.traceReturn(THIS_CLASS, "RetSubUnitMaoImpl() - constructor");
    }

    public RetSubUnitMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext inputGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, inputGenericMaoContext, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "RetSubUnitMaoImpl() - reconstructor");
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "RetSubUnit");
        logger.traceReturn(THIS_CLASS, "RetSubUnitMaoImpl() - reconstructor");
    }

    public void actionForceCalibration(Coordinator coordinator) throws MoAccessException, ForceCalibrationFailureException, NoConnectionWithUnitException {
        logger.traceEnter(THIS_CLASS, "actionForceCalibration()");
        logger.traceDebug(THIS_CLASS, "coordinator: " + coordinator);
        try {
            this.sendActionWithCfm(ACTION_FORCE_CALIBRATION, null, new TreeMap());
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (this.RESULT_FORCE_CALIBRATION_FAILURE_EXCEPTION_STRING.equals(result)) {
                String msg = "Force calibration failure. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new ForceCalibrationFailureException("RetSubUnit", msg);
            }
            if (this.RESULT_NO_CONNECTION_WITH_UNIT_STRING.equals(result)) {
                String msg = "No connection with unit. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoConnectionWithUnitException("RetSubUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionForceCalibration()");
    }

    public void actionSendAntennaConfigurationFile(String server, String path, String username, String password, Coordinator coordinator) throws MoAccessException, NoConnectionWithUnitException, SendAntennaConfigurationFileFailureException {
        logger.traceEnter(THIS_CLASS, "actionSendAntennaConfigurationFile()");
        logger.traceDebug(THIS_CLASS, "server: " + server + ", path: " + path + ", username: " + username);
        this.getConfigurationFileViaFtp(server, path, username, password);
        try {
            File configFile = new File(path);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("path", LOCAL_FILE_PATH + configFile.getName());
            this.sendActionWithCfm(ACTION_SEND_ANTENNA_CONFIGURATION_FILE, coordinator, treeMap);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (this.RESULT_SEND_ANTENNA_CONFIGURATION_FILE_FAILURE_EXCEPTION_STRING.equals(result)) {
                String msg = "Error when communicating with FRO. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new SendAntennaConfigurationFileFailureException("RetSubUnit", msg);
            }
            if (this.RESULT_NO_CONNECTION_WITH_UNIT_STRING.equals(result)) {
                String msg = "No connection with unit. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoConnectionWithUnitException("RetSubUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionSendAntennaConfigurationFile()");
    }

    private void getConfigurationFileViaFtp(String server, String path, String username, String password) throws SendAntennaConfigurationFileFailureException {
        String fileName = new File(path).getName();
        String remoteFilePath = path;
        try {
            logger.traceDebug(THIS_CLASS, "Trying to download configuration file from server...server= " + server + ", path= " + path);
            this.genericMaoContext.getFTPClientWrapperFactory().getFTPClientWrapper().get(server, username, password, LOCAL_FILE_PATH + fileName, remoteFilePath);
        }
        catch (FTPException ftpe) {
            FtpFaultNumberTranslationHelper ftpFaultNumberTranslater = new FtpFaultNumberTranslationHelper();
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + ftpFaultNumberTranslater.translateFtpFaultNumber(ftpe);
            logger.traceAbnormal(THIS_CLASS, errMsg);
            logger.traceDebug(THIS_CLASS, errMsg);
            throw new SendAntennaConfigurationFileFailureException("RetSubUnit", errMsg);
        }
        catch (Exception e) {
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + e;
            logger.traceDebug(THIS_CLASS, errMsg);
            throw new SendAntennaConfigurationFileFailureException("RetSubUnit", errMsg);
        }
    }

    public Object[] hideHazardousActionParameters(String actionName, Object[] parameters) {
        logger.traceEnter(THIS_CLASS, "hideHazardousActionParameters() action: " + actionName);
        Object[] result = null;
        if (ACTION_SEND_ANTENNA_CONFIGURATION_FILE.equalsIgnoreCase(actionName)) {
            result = ArrayHelper.replaceObject((Object[])parameters, (int)3, (Object)"[HIDDEN]");
        }
        logger.traceReturn(THIS_CLASS, "hideHazardousActionParameters()");
        return result;
    }

    public Object[] hideHazardousAttributeValues(AttrList attrlist) {
        return null;
    }
}

