/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.riport;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rilink.RiLinkMaoImpl;
import se.ericsson.crbs.cat.mao.riport.RiPortMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class RiPortMaoImpl
extends GenericMao
implements RiPortMao {
    private static final String RESERVED_BY = "reservedBy";
    private static final String RILINK = "RiLink";
    private static final String RIPORT_REF_1 = "riPortRef1";
    private static final String RIPORT_REF_2 = "riPortRef2";
    private static final String REMOTE_RI_PORT_REF = "remoteRiPortRef";
    private static final Class THIS_CLASS = RiPortMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ID_ATTR = "RiPortId";
    private static final List ALLOWED_ID = new ArrayList(36);
    private static final String OLD_ID_DATA_1 = "DATA_1";
    private static final String OLD_ID_DATA_2 = "DATA_2";
    private static final String NEW_ID_DATA_1 = "Data1";
    private static final String NEW_ID_DATA_2 = "Data2";

    public RiPortMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "RiPort", aGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
    }

    public RiPortMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
    }

    public AttrList addFroParametersAtCreate(AttrList signalParameters, AttrList clientProvidedParameters, Coordinator coordinator) throws MoAccessException {
        String ldn = this.getLocalDistinguishedName();
        int index = ldn.lastIndexOf(61);
        String id = "";
        if (index == -1) {
            throw new MoCanNotBeCreatedException("Missing ID attribute for MO RiPort!");
        }
        id = ldn.substring(index + 1);
        if (ALLOWED_ID.contains(id)) {
            ((se.ericsson.crbs.omf.mao.commonmo.AttrListImpl)signalParameters).addAttribute(ID_ATTR, (Object)id);
        } else if (id.equals(OLD_ID_DATA_1)) {
            ((se.ericsson.crbs.omf.mao.commonmo.AttrListImpl)signalParameters).addAttribute(ID_ATTR, (Object)NEW_ID_DATA_1);
        } else if (id.equals(OLD_ID_DATA_2)) {
            ((se.ericsson.crbs.omf.mao.commonmo.AttrListImpl)signalParameters).addAttribute(ID_ATTR, (Object)NEW_ID_DATA_2);
        } else {
            throw new MoCanNotBeCreatedException("Incorrect ID for MO RiPort: " + id);
        }
        if (signalParameters.contains(new String[]{REMOTE_RI_PORT_REF})) {
            int attrIndex = ((se.ericsson.crbs.omf.mao.commonmo.AttrListImpl)signalParameters).indexOf(REMOTE_RI_PORT_REF);
            ((se.ericsson.crbs.omf.mao.commonmo.AttrListImpl)signalParameters).removeElementAt(attrIndex);
        }
        return signalParameters;
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes()");
        for (int i = 0; i < attributeNames.length; ++i) {
            this.setAttribute(attributeNames[i], attributeValues[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    private void deleteRiLink(Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject[] reservedBy = (ManagedObject[])this.getAttribute(RESERVED_BY, coordinator);
        if (reservedBy != null) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (!RILINK.equals(reservedBy[i].getType())) continue;
                reservedBy[i].delete(coordinator);
                break;
            }
        }
    }

    private void setRiLinkAttribute(ManagedObject attributeValue, RiLinkMaoImpl riLinkMaoImpl1, RiLinkMaoImpl riLinkMaoImpl2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        if (riLinkMaoImpl1 == riLinkMaoImpl2) {
            return;
        }
        if (riLinkMaoImpl2 != null) {
            throw new ResourceUnavailableException("RiPort", "This RiPort is already in use: " + attributeValue.getLocalDistinguishedName());
        }
        if (((ManagedObject)riLinkMaoImpl1.getAttribute(RIPORT_REF_1, coordinator)).getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) {
            riLinkMaoImpl1.setAttribute(RIPORT_REF_2, attributeValue, coordinator);
        } else if (((ManagedObject)riLinkMaoImpl1.getAttribute(RIPORT_REF_2, coordinator)).getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) {
            riLinkMaoImpl1.setAttribute(RIPORT_REF_1, attributeValue, coordinator);
        } else {
            throw new ResourceUnavailableException("RiPort", "This RiPort is already in use: " + attributeValue.getLocalDistinguishedName());
        }
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (attributeName.equals(REMOTE_RI_PORT_REF)) {
            if (attributeValue == null || "".equals(attributeValue)) {
                this.deleteRiLink(coordinator);
            } else {
                if (!(attributeValue instanceof ManagedObject) || !"RiPort".equalsIgnoreCase(((ManagedObject)attributeValue).getType())) {
                    throw new WrongAttributeTypeException("RiPort", "The given reference is not pointing to a RiPort!");
                }
                RiLinkMaoImpl riLinkMaoImpl1 = this.getRiLink(this, coordinator);
                RiLinkMaoImpl riLinkMaoImpl2 = this.getRiLink((RiPortMaoImpl)attributeValue, coordinator);
                if (riLinkMaoImpl1 == null && riLinkMaoImpl2 == null) {
                    this.createRiLink(this, (RiPortMaoImpl)attributeValue, coordinator);
                } else {
                    this.setRiLinkAttribute((ManagedObject)attributeValue, riLinkMaoImpl1, riLinkMaoImpl2, coordinator);
                }
            }
        } else {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    private void createRiLink(RiPortMaoImpl riPortRef1, RiPortMaoImpl riPortRef2, Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        ManagedObject equipment = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,Equipment=1");
        Integer linkType = new Integer(1);
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement(RIPORT_REF_1, (Object)riPortRef1);
        attrList.addElement(RIPORT_REF_2, (Object)riPortRef2);
        attrList.addElement("linkType", (Object)linkType);
        int riLinkId = this.findNewRiLinkId(coordinator);
        this.createMo(RILINK, equipment, String.valueOf(riLinkId), attrList, coordinator);
    }

    private int findNewRiLinkId(Coordinator coordinator) throws TransactionRequiredException, ProcessingFailureException, ResourceUnavailableException, MoAccessException {
        int id = 1;
        MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(RILINK);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                RiLinkMaoImpl riLinkMaoImpl = (RiLinkMaoImpl)moIterator.nextMo();
                String rdnId = riLinkMaoImpl.getRdnId(coordinator);
                int i = 0;
                try {
                    i = Integer.parseInt(rdnId);
                    id = i >= id ? i + 1 : id;
                }
                catch (NumberFormatException e) {}
            }
        }
        return id;
    }

    private ManagedObject createMo(String moType, ManagedObject parent, String identity, AttrListImpl attrList, Coordinator coordinator) throws NotHandledAttributeTypeException, MoNotFoundException, ProcessingFailureException {
        ManagedObject createdMo = null;
        MoFactory moFactory = this.findAndCheckFactory(moType);
        AttrListImpl attributeList = attrList == null ? new AttrListImpl() : attrList;
        try {
            createdMo = moFactory.createMo(parent, (AttrList)attributeList, identity, null, coordinator);
        }
        catch (MoAccessException mae) {
            throw new ProcessingFailureException("Could not create MO of type " + moType + " with id: ");
        }
        return createdMo;
    }

    private MoFactory findAndCheckFactory(String moType) throws ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "findAndCheckFactory() " + moType);
        MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup(moType);
        if (moFactory == null) {
            throw new ProcessingFailureException("Could not find MO factory for type " + moType + ".");
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckFactory() " + moType);
        return moFactory;
    }

    private RiLinkMaoImpl getRiLink(RiPortMaoImpl riPortMaoImpl, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject[] reservedBy = (ManagedObject[])riPortMaoImpl.getAttribute(RESERVED_BY, coordinator);
        if (reservedBy != null) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (!RILINK.equals(reservedBy[i].getType())) continue;
                return (RiLinkMaoImpl)reservedBy[i];
            }
        }
        return null;
    }

    public Object getAttribute(String attrName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        if (REMOTE_RI_PORT_REF.equals(attrName)) {
            return this.getAttrForRiPortRef(coordinator);
        }
        if (RESERVED_BY.equals(attrName)) {
            return this.getAttrForReservedBy(coordinator);
        }
        return super.getAttribute(attrName, coordinator);
    }

    private Object getAttrForRiPortRef(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        ManagedObject[] reservedBy = (ManagedObject[])super.getAttribute(RESERVED_BY, coordinator);
        if (reservedBy != null && reservedBy.length > 0) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (!RILINK.equals(reservedBy[i].getType())) continue;
                RiLinkMaoImpl riLinkMaoImpl = (RiLinkMaoImpl)reservedBy[i];
                ManagedObject riPortRef1 = (ManagedObject)riLinkMaoImpl.getAttribute(RIPORT_REF_1, coordinator);
                ManagedObject riPortRef2 = (ManagedObject)riLinkMaoImpl.getAttribute(RIPORT_REF_2, coordinator);
                if (riPortRef1.getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) {
                    return riPortRef2;
                }
                if (!riPortRef2.getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                return riPortRef1;
            }
        }
        return null;
    }

    private Object getAttrForReservedBy(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        ManagedObject[] reservedBy = (ManagedObject[])super.getAttribute(RESERVED_BY, coordinator);
        ManagedObject remoteRiPortRef = (ManagedObject)this.getAttribute(REMOTE_RI_PORT_REF, coordinator);
        if (remoteRiPortRef != null) {
            ManagedObject[] newReservedBy;
            if (reservedBy != null) {
                newReservedBy = new ManagedObject[reservedBy.length + 1];
                System.arraycopy(reservedBy, 0, newReservedBy, 0, reservedBy.length);
            } else {
                newReservedBy = new ManagedObject[1];
            }
            newReservedBy[newReservedBy.length - 1] = remoteRiPortRef;
            return newReservedBy;
        }
        return reservedBy;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        Object[] result = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            result[i] = this.getAttribute(attrNames[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return result;
    }

    static {
        ALLOWED_ID.add("A");
        ALLOWED_ID.add("B");
        ALLOWED_ID.add("C");
        ALLOWED_ID.add("D");
        ALLOWED_ID.add("E");
        ALLOWED_ID.add("F");
        ALLOWED_ID.add("B1");
        ALLOWED_ID.add("B2");
        ALLOWED_ID.add("C1");
        ALLOWED_ID.add("C2");
        ALLOWED_ID.add("C3");
        ALLOWED_ID.add("C4");
        ALLOWED_ID.add("C5");
        ALLOWED_ID.add("C6");
        ALLOWED_ID.add("D1");
        ALLOWED_ID.add("D2");
        ALLOWED_ID.add("D3");
        ALLOWED_ID.add("D4");
        ALLOWED_ID.add("D5");
        ALLOWED_ID.add("D6");
        ALLOWED_ID.add("1");
        ALLOWED_ID.add("2");
        ALLOWED_ID.add("3");
        ALLOWED_ID.add("4");
        ALLOWED_ID.add("5");
        ALLOWED_ID.add("6");
        ALLOWED_ID.add("7");
        ALLOWED_ID.add("8");
        ALLOWED_ID.add("9");
        ALLOWED_ID.add("10");
        ALLOWED_ID.add("11");
        ALLOWED_ID.add("12");
        ALLOWED_ID.add("13");
        ALLOWED_ID.add("14");
        ALLOWED_ID.add("15");
        ALLOWED_ID.add("16");
    }
}

