/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.sectorequipmentfunction;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.sectorequipmentfunction.SectorEquipmentFunctionMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.IndicationHandler;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class SectorEquipmentFunctionMaoImpl
extends GenericMao
implements SectorEquipmentFunctionMao {
    private static final Class THIS_CLASS = SectorEquipmentFunctionMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    public static final String CONF_OUTPUT_POWER = "confOutputPower";
    public static final String CONFIGURED_OUTPUT_POWER = "configuredOutputPower";
    public static final String SECTOR_POWER = "sectorPower";
    public static final String AVAILABLE_SECTOR_POWER = "availableSectorPower";
    public static final String ADMINISTRATIVE_STATE_ATTR = "administrativeState";
    private static final Integer LOCK = new Integer(0);
    private static final int SHUTTING_DOWN = 2;

    public SectorEquipmentFunctionMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext inputGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "SectorEquipmentFunction", inputGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - constructor");
    }

    public SectorEquipmentFunctionMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext inputGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, inputGenericMaoContext, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - reconstructor");
        logger.traceReturn(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - reconstructor");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "delete()");
        ManagedObject[] reservedBy = (ManagedObject[])this.getAttribute("reservedBy", coordinator);
        for (int i = 0; i < reservedBy.length; ++i) {
            ManagedObject[] reservedBySectorCarrier;
            ManagedObject currReservedBy = reservedBy[i];
            if (!MO_TYPE_SECTOR_CARRIER.equalsIgnoreCase(currReservedBy.getType()) || 0 != (reservedBySectorCarrier = (ManagedObject[])currReservedBy.getAttribute("reservedBy", coordinator)).length) continue;
            logger.traceDebug(this.getClass(), "delete() delete orphan SectorCarrier Mo" + currReservedBy.getLocalDistinguishedName());
            currReservedBy.delete(coordinator);
        }
        super.delete(coordinator);
        logger.traceReturn(this.getClass(), "delete()");
    }

    public AttrList addFroParametersAtCreate(AttrList signalParameters, AttrList clientProvidedParameters, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        AttrListImpl result = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        for (int i = 0; i < signalParameters.size(); ++i) {
            if (CONF_OUTPUT_POWER.equals(signalParameters.getName(i))) {
                int defaultOutputPower = (Integer)this.genericMaoContext.getMoMetaDataFinder().getMoAttributes("SectorEquipmentFunction", CONF_OUTPUT_POWER).getData().getDefaultValue(this.genericMaoContext.getMoMetaDataFinder());
                int oldValue = (Integer)signalParameters.getValue(i);
                if (oldValue == defaultOutputPower) continue;
                Integer value = new Integer(oldValue * 1000);
                result.addAttribute(CONFIGURED_OUTPUT_POWER, (Object)value);
                continue;
            }
            result.addAttribute(signalParameters.getName(i), signalParameters.getValue(i));
        }
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return result;
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (CONF_OUTPUT_POWER.equals(attributeName)) {
            int oldValue = (Integer)attributeValue;
            Integer newValue = new Integer(oldValue * 1000);
            super.setAttribute(CONFIGURED_OUTPUT_POWER, (Object)newValue, coordinator);
        } else if (SECTOR_POWER.equals(attributeName)) {
            int oldValue = (Integer)attributeValue;
            Integer newValue = new Integer(oldValue * 1000);
            super.setAttribute(AVAILABLE_SECTOR_POWER, (Object)newValue, coordinator);
        } else if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.setAttribute(ADMINISTRATIVE_STATE_ATTR, (Object)LOCK, coordinator);
            } else {
                super.setAttribute(attributeName, attributeValue, coordinator);
            }
        } else {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "SetAttributes()");
        for (int i = 0; i < attributeNames.length; ++i) {
            if (CONF_OUTPUT_POWER.equals(attributeNames[i]) || SECTOR_POWER.equals(attributeNames[i]) || ADMINISTRATIVE_STATE_ATTR.equals(attributeNames[i])) {
                this.setAttribute(attributeNames[i], attributeValues[i], coordinator);
                continue;
            }
            super.setAttribute(attributeNames[i], attributeValues[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "SetAttributes()");
    }

    public final Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException {
        Object result;
        logger.traceEnter(THIS_CLASS, "getAttribute()");
        if (CONF_OUTPUT_POWER.equals(attributeName)) {
            int newValue = (Integer)super.getAttribute(CONFIGURED_OUTPUT_POWER, coordinator);
            result = new Integer(newValue / 1000);
        } else if (SECTOR_POWER.equals(attributeName)) {
            int newValue = (Integer)super.getAttribute(AVAILABLE_SECTOR_POWER, coordinator);
            result = new Integer(newValue / 1000);
        } else {
            result = super.getAttribute(attributeName, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttribute()");
        return result;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.preGetAttributes(attrNames, coordinator);
        Object[] result = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            result[i] = CONF_OUTPUT_POWER.equals(attrNames[i]) || SECTOR_POWER.equals(attrNames[i]) ? this.getAttribute(attrNames[i], coordinator) : super.getAttribute(attrNames[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return result;
    }

    public void parameterChanged(String attributeName, Object attributeValue) {
        logger.traceEnter(THIS_CLASS, "parameterChanged()");
        if (CONFIGURED_OUTPUT_POWER.equals(attributeName)) {
            Integer newValue = new Integer((Integer)attributeValue / 1000);
            IndicationHandler indicationSubscriber = this.genericMaoContext.getIndicationHandlerFactory().createIndicationHandler((ManagedObject)this, this.genericMaoContext);
            indicationSubscriber.handleAvcNotification(CONF_OUTPUT_POWER, (Object)newValue, null);
        } else if (AVAILABLE_SECTOR_POWER.equals(attributeName)) {
            Integer newValue = new Integer((Integer)attributeValue / 1000);
            IndicationHandler indicationSubscriber = this.genericMaoContext.getIndicationHandlerFactory().createIndicationHandler((ManagedObject)this, this.genericMaoContext);
            indicationSubscriber.handleAvcNotification(SECTOR_POWER, (Object)newValue, null);
        } else if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.parameterChanged(attributeName, (Object)new Integer(0));
            } else {
                super.parameterChanged(attributeName, attributeValue);
            }
        }
        super.parameterChanged(attributeName, attributeValue);
        logger.traceReturn(THIS_CLASS, "parameterChanged()");
    }
}

