/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.systemconstants;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.systemconstants.SystConstantNotFoundException;
import se.ericsson.crbs.cat.mao.systemconstants.SystConstantsFullException;
import se.ericsson.crbs.cat.mao.systemconstants.SystemConstantsMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.LengthOutOfRangeException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class SystemConstantsMaoImpl
extends GenericMao
implements SystemConstantsMao {
    private static final String MO_TYPE = "SystemConstants";
    private static final String RESET_SYST_CONST = "resetSystConst";
    private static final String WRITE_SYST_CONST = "writeSystConst";
    private static final String ARGUMENT_NAME = "name";
    private static final String SYST_CONSTANTS_PARAM = "systConstants";
    private static final String ARGUMENT_VALUE = "value";
    private static final String RESULT_SYST_CONST_FULL = Integer.toString(0x1000001);
    private static final String RESULT_SYST_CONST_NOT_FOUND = Integer.toString(0x1000002);
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final int MAX_LENGTH = 31;

    public SystemConstantsMaoImpl(ManagedObject inputParent, AttrList inputAttributes, String inputIdentity, GenericMaoContext inputGenericMaoContext, Integer inputSoftwareRevision, Coordinator inputCoordinator, InitialMaoContext inputInitialmaocontext) throws MoAccessException {
        super(inputParent, inputAttributes, inputIdentity, MO_TYPE, inputGenericMaoContext, inputSoftwareRevision, inputCoordinator, inputInitialmaocontext);
    }

    public SystemConstantsMaoImpl(MoDataWrapper inputRecoveredData, String inputMoType, GenericMaoContext inputGenericMaoContext, InitialMaoContext inputInitialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(inputRecoveredData, inputMoType, inputGenericMaoContext, inputInitialMaoContext);
    }

    public void actionResetSystConst(String name, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(this.getClass(), "actionResetSystConst()");
        this.handleTransactionWrite(coordinator);
        this.checkArgumentCharacters(name, ARGUMENT_NAME);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(ARGUMENT_NAME, name);
        try {
            this.sendActionWithCfm(RESET_SYST_CONST, coordinator, parameters);
        }
        catch (FroRequestFailedException e) {
            String exceptionVariables = e.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (result.equals(RESULT_SYST_CONST_NOT_FOUND)) {
                throw new SystConstantNotFoundException(MO_TYPE, "System Constant: " + name + " to reset not found.");
            }
            throw e;
        }
        logger.traceReturn(this.getClass(), "actionResetSystConst()");
    }

    public void actionWriteSystConst(String name, String value, Coordinator coordinator) throws MoAccessException, IllegalArgumentTypeException {
        logger.traceEnter(this.getClass(), "actionWriteSystConst()");
        if (coordinator == null) {
            this.writeSystConst(name, value);
        } else {
            this.writeSystConst(name, value, coordinator);
        }
        logger.traceReturn(this.getClass(), "actionWriteSystConst()");
    }

    private void writeSystConst(String name, String value) throws MoAccessException {
        TransactionFactory transFact = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory();
        try {
            Control control = transFact.create(120);
            try {
                this.writeSystConst(name, value, control.getCoordinator());
                control.getTerminator().commit();
            }
            catch (MoAccessException mae) {
                control.getTerminator().rollback();
                throw mae;
            }
        }
        catch (TransactionRolledBackException trbe) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "Fault during transaction handling, transaction rolled back. " + (Object)((Object)trbe));
        }
        catch (InactiveTransactionException ite) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "Fault during transaction handling, transaction already inactive. " + (Object)((Object)ite));
        }
    }

    private void writeSystConst(String name, String value, Coordinator newCoordinator) throws TransactionRequiredException, NoPermissionException, ResourceLockedException, MoAccessException, IllegalArgumentTypeException, SystConstantsFullException, FroRequestFailedException {
        this.handleTransactionWrite(newCoordinator);
        this.checkArgumentsLength(name, value);
        this.checkArgumentCharacters(name, ARGUMENT_NAME);
        this.checkArgumentCharacters(value, ARGUMENT_VALUE);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(ARGUMENT_NAME, name);
        parameters.put(ARGUMENT_VALUE, value);
        try {
            this.sendActionWithCfm(WRITE_SYST_CONST, newCoordinator, parameters);
        }
        catch (FroRequestFailedException e) {
            String exceptionVariables = e.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (result.equals(RESULT_SYST_CONST_FULL)) {
                String message = "Write System Constant, " + name + " " + value + ", failed. System Constants full.";
                logger.info(this.getClass(), message);
                throw new SystConstantsFullException(MO_TYPE, message);
            }
            throw e;
        }
    }

    public AttrList addFroParametersAtCreate(AttrList parameters, AttrList attributes, Coordinator coordinator) throws MoAccessException {
        AttrListImpl myParameters = (AttrListImpl)parameters;
        logger.traceEnter(this.getClass(), "addFroParametersAtCreate()");
        myParameters.addAttribute(SYST_CONSTANTS_PARAM, (Object)"");
        logger.traceReturn(this.getClass(), "addFroParametersAtCreate()");
        return parameters;
    }

    private void checkArgumentCharacters(String argument, String argumentName) throws IllegalArgumentTypeException {
        String[] notPermitted = new String[]{":", ","};
        HashSet<String> illegals = new HashSet<String>();
        for (int i = 0; i < notPermitted.length; ++i) {
            String testString = notPermitted[i];
            if (argument.indexOf(testString) == -1) continue;
            illegals.add(testString);
        }
        if (!illegals.isEmpty()) {
            StringBuffer msg = new StringBuffer("Argument ");
            msg.append(argumentName);
            msg.append(" contains illegal character");
            if (illegals.size() > 1) {
                msg.append('s');
            }
            msg.append(' ');
            Iterator i = illegals.iterator();
            while (i.hasNext()) {
                msg.append('\'');
                msg.append(i.next());
                msg.append("' ");
            }
            logger.info(this.getClass(), msg.toString());
            throw new IllegalArgumentTypeException((ManagedObject)this, argumentName);
        }
    }

    private void checkArgumentsLength(String argName, String argValue) throws MoAccessException {
        if (argName.length() + argValue.length() > 31) {
            String message = "Arguments name: " + argName + " & value: " + argValue + " exceeds max length " + 31 + ".";
            logger.info(this.getClass(), message);
            throw new LengthOutOfRangeException(MO_TYPE, message);
        }
    }
}

