/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.xpprogram;

import java.text.SimpleDateFormat;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.common.ProgramMaoBase;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.cat.mao.xpprogram.XpProgramMao;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class XpProgramMaoImpl
extends ProgramMaoBase
implements XpProgramMao {
    public static final String DO_REALLY_USE_REAL_FILE_PATH = "DoReAlLyUsErAaLfIlPaTh";
    private static final Class THIS_CLASS = XpProgramMaoImpl.class;
    public static final String USER_LABEL = "userLabel";
    private static final AbstractLogger localLogger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String PRODUCT_INFO = "productInfo";
    public static final String PRODUCT_NUMBER = "productNumber";
    public static final String PRODUCT_REVISION = "productRevision";
    private static final String UNKNOWN = "UNKNOWN";
    protected static final String NOT_SET = "NotSet";
    protected static final String DEFAULT_REVISION = "R1A";
    private boolean isRecovering = false;
    protected String lmFilePathAtCreate = "";

    public XpProgramMaoImpl(ManagedObject inputParent, AttrList inputAttributes, String inputIdentity, GenericMaoContext inputGenericMaoContext, Integer inputSoftwareRevision, Coordinator inputCoordinator, InitialMaoContext inputInitialMaoContext) throws MoAccessException {
        super(XpProgramMaoImpl.class, inputParent, inputAttributes, inputIdentity, "XpProgram", inputGenericMaoContext, inputSoftwareRevision, inputCoordinator, inputInitialMaoContext);
        ManagedObject grandParent = this.getParent().getParent();
        if (!(grandParent instanceof AuxPlugInUnitMao)) {
            String errorMsg = "An XpProgram must have an AuxPlugInUnit MO as grand parent";
            throw new MoCanNotBeCreatedException("An XpProgram must have an AuxPlugInUnit MO as grand parent");
        }
    }

    public XpProgramMaoImpl(MoDataWrapper inputRecoveredData, String inputMoType, GenericMaoContext inputGenericMaoContext, InitialMaoContext inputInitialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(XpProgramMaoImpl.class, inputRecoveredData, inputMoType, inputGenericMaoContext, inputInitialMaoContext);
    }

    public AttrList addFroParametersAtCreate(AttrList parameters, AttrList attributes, Coordinator coordinator) throws MoAccessException {
        AttrListImpl myParameters = (AttrListImpl)parameters;
        localLogger.traceEnter(this.getClass(), "addFroParametersAtCreate()");
        int index = attributes.indexOf("loadModule");
        LoadModuleMoSU_Access loadModuleMo = (LoadModuleMoSU_Access)attributes.getValue(index);
        Struct productData = loadModuleMo.getProductData(coordinator);
        String productInfo = (String)productData.getValue(PRODUCT_INFO);
        String lmUserLabel = this.getLoadModuleUserLabel(loadModuleMo, coordinator);
        this.lmFilePathAtCreate = productInfo.equalsIgnoreCase("compLstFault") ? "compLstFault/FaultyCompatibilityList" : (productInfo.equalsIgnoreCase("incompSW") ? "incompSW/NoMatchingSwFound" : ((productInfo.equalsIgnoreCase("runningSW") || productInfo.equalsIgnoreCase("RECOVERED")) && !DO_REALLY_USE_REAL_FILE_PATH.equals(lmUserLabel) ? this.getFilePath(productData, "runningSW") : (productInfo.equalsIgnoreCase("preinsSW") ? this.getFilePath(productData, "preinsSW") : (productInfo.equalsIgnoreCase("incompHW") ? "incompHW/ProductNamesIncomp" : LoadModuleHelperImpl.getLoadModuleFilePath(loadModuleMo, coordinator)))));
        if (DO_REALLY_USE_REAL_FILE_PATH.equals(lmUserLabel)) {
            this.resetLoadModuleUserLabel(loadModuleMo, coordinator);
        }
        myParameters.addAttribute("loadModuleFilePath", (Object)this.lmFilePathAtCreate);
        myParameters.addAttribute("productData", (Object)productData);
        localLogger.traceReturn(this.getClass(), "addFroParametersAtCreate()");
        return parameters;
    }

    private String getLoadModuleUserLabel(LoadModuleMoSU_Access loadModuleMoSuAccess, Coordinator coordinator) throws MoAccessException {
        String userLabel = "";
        if (loadModuleMoSuAccess instanceof LoadModuleMo) {
            LoadModuleMo loadModuleMo = (LoadModuleMo)loadModuleMoSuAccess;
            userLabel = loadModuleMo.getUserLabel(coordinator);
        }
        return userLabel;
    }

    private void resetLoadModuleUserLabel(LoadModuleMoSU_Access loadModuleMoSuAccess, Coordinator coordinator) throws MoAccessException {
        if (loadModuleMoSuAccess instanceof LoadModuleMo) {
            LoadModuleMo loadModuleMo = (LoadModuleMo)loadModuleMoSuAccess;
            Struct productData = loadModuleMo.getProductData(coordinator);
            String productNumber = productData.getValue(PRODUCT_NUMBER).toString();
            String productRevision = productData.getValue(PRODUCT_REVISION).toString();
            String identity = productNumber + "_" + productRevision;
            String userLabel = "Load module for: " + identity;
            loadModuleMo.setUserLabel(userLabel, coordinator);
            localLogger.traceGeneral(THIS_CLASS, "Reset LM userLabel to: " + userLabel);
        }
    }

    private String getFilePath(Struct productData, String fakePathPrefix) throws MoAccessException {
        String productNumber = (String)productData.getValue(PRODUCT_NUMBER);
        productNumber = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevision = (String)productData.getValue(PRODUCT_REVISION);
        productRevision = ProductNumberHelper.convertSlashToPercent(productRevision);
        String lmFilePath = fakePathPrefix + "/" + productNumber + "_" + productRevision;
        return lmFilePath;
    }

    public void postCreate(AttrList attributes, Coordinator coordinator) {
        operationalState = 0;
        this.moType = "XpProgram";
        try {
            this.setAdditionalAttribute("loadModuleFilePath", this.lmFilePathAtCreate, coordinator);
        }
        catch (MoAccessException mae) {
            localLogger.traceDebug(THIS_CLASS, "Unable to store LoadModuleFilePath for later use: " + ExceptionHelper.convertToString((Throwable)mae));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Object result = null;
        try {
            result = super.getAttribute(attributeName, coordinator);
        }
        catch (MoRemovedException mre) {
            String lmIdentity = this.getLmIdentityFromMoRemovedException(mre);
            localLogger.traceGeneral(THIS_CLASS, "isRecovering: " + this.isRecovering);
            XpProgramMaoImpl xpProgramMaoImpl = this;
            synchronized (xpProgramMaoImpl) {
                if (!this.isRecovering) {
                    try {
                        this.isRecovering = true;
                        this.recoverLoadModuleReference(lmIdentity, coordinator);
                        result = super.getAttribute(attributeName, coordinator);
                    }
                    finally {
                        this.isRecovering = false;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributes(String[] attributeNames, Coordinator coordinator) throws MoAccessException {
        Object[] result = null;
        try {
            result = super.getAttributes(attributeNames, coordinator);
        }
        catch (MoRemovedException mre) {
            String lmIdentity = this.getLmIdentityFromMoRemovedException(mre);
            XpProgramMaoImpl xpProgramMaoImpl = this;
            synchronized (xpProgramMaoImpl) {
                if (!this.isRecovering) {
                    try {
                        this.isRecovering = true;
                        this.recoverLoadModuleReference(lmIdentity, coordinator);
                        result = super.getAttributes(attributeNames, coordinator);
                    }
                    finally {
                        this.isRecovering = false;
                    }
                }
            }
        }
        return result;
    }

    protected String getLmIdentityFromMoRemovedException(MoRemovedException mre) {
        String excMsg = mre.getVariablesAsString();
        int index = excMsg.lastIndexOf("=") + 1;
        String identity = excMsg.substring(index);
        identity = StringHelper.replaceInString((String)identity, (String)"\"", (String)"").trim();
        return identity;
    }

    public void delete(Coordinator coordinator) throws ProcessingFailureException, MoAccessException {
        LoadModuleMoSU_Access loadModule = (LoadModuleMoSU_Access)this.getAttribute("loadModule", coordinator);
        String ownLdn = this.getLocalDistinguishedName();
        super.delete(coordinator);
        if (loadModule != null) {
            AuxPlugInUnitMao auxPlugInUnitMao = (AuxPlugInUnitMao)this.getParent().getParent();
            LoadModuleHelper loadModuleHelper = LoadModuleHelperFactory.getInstance().getLoadModuleHelper(auxPlugInUnitMao, this.genericMaoContext);
            loadModuleHelper.deleteOwnCreatedLoadModuleIfNotUsed(loadModule, ownLdn, coordinator);
        }
    }

    protected void recoverLoadModuleReference(String lmIdentity, Coordinator coordinator) throws MoAccessException {
        boolean createdLoadModuleMo;
        localLogger.traceEnter(THIS_CLASS, "recoverLoadModuleReference() " + lmIdentity);
        String lmFilePath = (String)this.getAdditionalAttribute("loadModuleFilePath", coordinator);
        if (lmFilePath == null) {
            lmFilePath = "preinsSW/UNKNOWN_R1A";
        }
        localLogger.traceGeneral(THIS_CLASS, "LM File path: " + StringHelper.doubleQuote((String)lmFilePath));
        String lmProductNumber = "";
        String lmProductRevision = "";
        if (lmFilePath.startsWith("preinsSW")) {
            lmProductNumber = this.getProductNumberFromLmFilePath(lmFilePath);
            lmProductRevision = this.getProductRevisionFromLmFilePath(lmFilePath);
            createdLoadModuleMo = true;
        } else if (lmFilePath.startsWith("runningSW")) {
            lmProductNumber = this.getProductNumberFromLmFilePath(lmFilePath);
            lmProductRevision = this.getProductRevisionFromLmFilePath(lmFilePath);
            createdLoadModuleMo = true;
        } else if (lmFilePath.startsWith("incompSW")) {
            lmProductNumber = "NoMatch";
            lmProductRevision = "-";
            createdLoadModuleMo = true;
        } else if (lmFilePath.startsWith("compLstFault")) {
            lmProductNumber = "FaultyCompList";
            lmProductRevision = "-";
            createdLoadModuleMo = true;
        } else if (lmFilePath.startsWith("incompHW")) {
            lmProductNumber = "ProductNamesIncomp";
            lmProductRevision = "-";
            createdLoadModuleMo = true;
        } else {
            lmProductNumber = "NoMatch";
            lmProductRevision = "-";
            createdLoadModuleMo = true;
        }
        ManagedObject loadModuleMo = this.findLoadModule(lmProductNumber, lmProductRevision, coordinator);
        if (loadModuleMo != null) {
            if (coordinator != null) {
                this.setReadOnlyAttribute("loadModule", loadModuleMo, coordinator);
            } else {
                this.setReadOnlyAttributeWithLocalTransaction("loadModule", loadModuleMo);
            }
            createdLoadModuleMo = false;
            localLogger.traceGeneral(THIS_CLASS, "Found existing LM.");
        }
        if (createdLoadModuleMo) {
            this.createParamsForLmAndCreateLm(lmIdentity, lmFilePath, lmProductNumber, lmProductRevision, coordinator);
        }
        localLogger.traceReturn(THIS_CLASS, "recoverLoadModuleReference()");
    }

    private void setReadOnlyAttributeWithLocalTransaction(String attribName, ManagedObject attribValue) throws MoAccessException {
        try {
            TransactionFactory transFact = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory();
            Control localControl = transFact.create(0);
            Coordinator localCoordinator = localControl.getCoordinator();
            this.setReadOnlyAttribute(attribName, attribValue, localCoordinator);
            localControl.getTerminator().commit();
        }
        catch (TransactionRolledBackException trbe) {
            throw new MoRemovedException("Could not set attribute: " + trbe.reason);
        }
        catch (InactiveTransactionException e) {
            throw new MoRemovedException("Could not set attribute: " + e.reason);
        }
    }

    private ManagedObject findLoadModule(String lmProductNumber, String lmProductRevision, Coordinator coordinator) {
        localLogger.traceDebug(THIS_CLASS, "findLoadModule() :" + lmProductNumber + lmProductRevision);
        AuxPlugInUnitMao auxPiu = (AuxPlugInUnitMao)this.getParent().getParent();
        LoadModuleHelper lmHelper = LoadModuleHelperFactory.getInstance().getLoadModuleHelper(auxPiu, this.genericMaoContext);
        LoadModuleMoSU_Access[] lms = null;
        try {
            lms = lmHelper.getLoadModuleMos(coordinator);
        }
        catch (MoAccessException e) {
            localLogger.traceDebug(THIS_CLASS, "Unable to get list of LMs: " + ExceptionHelper.convertToString((Throwable)e));
            return null;
        }
        String currentNumber = null;
        String currentRevision = null;
        for (int index = 0; lms != null && index < lms.length; ++index) {
            block7: {
                try {
                    if (lms[index] != null) {
                        currentNumber = lms[index].getProductNumber(coordinator);
                        currentRevision = lms[index].getProductRevision(coordinator);
                        break block7;
                    }
                    localLogger.traceDebug(THIS_CLASS, "lms[" + index + "} == null");
                }
                catch (MoAccessException e) {
                    localLogger.traceDebug(THIS_CLASS, "Unable to read product number & revision from LM: " + ExceptionHelper.convertToString((Throwable)e));
                }
                continue;
            }
            if (currentNumber != null && currentRevision != null) {
                if (!currentNumber.equals(lmProductNumber) || !currentRevision.equals(lmProductRevision)) continue;
                localLogger.traceDebug(THIS_CLASS, "Found LM: " + currentNumber + " " + currentRevision);
                return lms[index];
            }
            localLogger.traceDebug(THIS_CLASS, "Null: currentNumber=" + currentNumber + ", currentRevision=" + currentRevision);
        }
        localLogger.traceDebug(THIS_CLASS, "No LM was found for: " + lmProductNumber + " " + lmProductRevision);
        return null;
    }

    protected void createParamsForLmAndCreateLm(String lmIdentity, String lmFilePath, String lmProductNumber, String lmProductRevision, Coordinator coordinator) throws MoAccessException {
        block6: {
            ManagedObject auxPlugInUnit = this.getParent().getParent();
            Struct auxProductData = this.getAuxProductData(auxPlugInUnit, coordinator);
            String auxProductName = (String)auxProductData.getValue("productName");
            String auxProductNumber = (String)auxProductData.getValue(PRODUCT_NUMBER);
            auxProductNumber = ProductNumberHelper.convertProductNumber(auxProductNumber);
            String auxProductRevision = (String)auxProductData.getValue(PRODUCT_REVISION);
            String auxProductionDate = (String)auxProductData.getValue("productionDate");
            String auxSerialNumber = (String)auxProductData.getValue("serialNumber");
            RuDataHolder ruDataHolder = new RuDataHolder();
            ruDataHolder.setLdn(auxPlugInUnit.getLocalDistinguishedName());
            ruDataHolder.setProductName(auxProductName);
            ruDataHolder.setProductNumber(auxProductNumber);
            ruDataHolder.setProductRevision(auxProductRevision);
            ruDataHolder.setSerialNumber(auxSerialNumber);
            String[] attributeNames = new String[]{"productionDate", PRODUCT_INFO, "productName", PRODUCT_NUMBER, PRODUCT_REVISION};
            String lmProductDate = auxProductionDate;
            String lmProductName = auxProductName;
            String lmProductInfo = "RECOVERED";
            Object[] attributevalues = new String[]{lmProductDate, "RECOVERED", lmProductName, lmProductNumber, lmProductRevision};
            StructImpl lmProductData = new StructImpl(attributeNames, attributevalues);
            if (coordinator == null || !coordinator.getStatus().equals(Status.ACTIVE)) {
                try {
                    TransactionFactory transFact = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory();
                    Control localControl = transFact.create(0);
                    Coordinator localCoordinator = localControl.getCoordinator();
                    try {
                        this.createLoadModule(lmIdentity, (AuxPlugInUnitMao)auxPlugInUnit, ruDataHolder, lmFilePath, (Struct)lmProductData, localCoordinator);
                        localControl.getTerminator().commit();
                        break block6;
                    }
                    catch (MoAccessException mae) {
                        localLogger.traceDebug(THIS_CLASS, "Exception caught during create of LoadModule, rolling back transaction. Exception: " + mae.getVariablesAsString());
                        localControl.getTerminator().rollback();
                        throw mae;
                    }
                }
                catch (TransactionRolledBackException trbe) {
                    throw new MoRemovedException("Could not recreate lost reference to LoadModule MO: " + trbe.reason);
                }
                catch (InactiveTransactionException ite) {
                    throw new MoRemovedException("Could not recreate lost reference to LoadModule MO: " + ite.reason);
                }
            }
            this.createLoadModule(lmIdentity, (AuxPlugInUnitMao)auxPlugInUnit, ruDataHolder, lmFilePath, (Struct)lmProductData, coordinator);
        }
    }

    protected Struct getAuxProductData(ManagedObject auxPlugInUnit, Coordinator coordinator) throws MoAccessException {
        String auxSerialNumber;
        String auxProductionDate;
        String auxProductNumber;
        Struct auxProductData = (Struct)auxPlugInUnit.getAttribute("productData", coordinator);
        String auxProductName = (String)auxProductData.getValue("productName");
        if (auxProductName.equals("")) {
            auxProductName = NOT_SET;
        }
        auxProductNumber = (auxProductNumber = (String)auxProductData.getValue(PRODUCT_NUMBER)).equals("") ? NOT_SET : ProductNumberHelper.convertProductNumber(auxProductNumber);
        String auxProductRevision = (String)auxProductData.getValue(PRODUCT_REVISION);
        if (auxProductRevision.equals("")) {
            auxProductRevision = DEFAULT_REVISION;
        }
        if ((auxProductionDate = (String)auxProductData.getValue("productionDate")).equals("")) {
            auxProductionDate = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (SimpleDateFormat)new SimpleDateFormat("yyyyMMdd"));
        }
        if ((auxSerialNumber = (String)auxProductData.getValue("serialNumber")).equals("")) {
            auxSerialNumber = NOT_SET;
        }
        String[] structNames = new String[]{"productName", PRODUCT_NUMBER, PRODUCT_REVISION, "productionDate", "serialNumber"};
        Object[] structValues = new String[]{auxProductName, auxProductNumber, auxProductRevision, auxProductionDate, auxSerialNumber};
        return new StructImpl(structNames, structValues);
    }

    protected void createLoadModule(String lmIdentity, AuxPlugInUnitMao auxPlugInUnitMao, RuDataHolder ruDataHolder, String lmFilePath, Struct lmProductData, Coordinator coordinator) throws MoAccessException {
        LoadModuleHelper loadModuleHelper = LoadModuleHelperFactory.getInstance().getLoadModuleHelper(auxPlugInUnitMao, this.genericMaoContext);
        LoadModuleMoSU_Access loadModuleMo = loadModuleHelper.recreateLoadModuleMo(lmIdentity, ruDataHolder, lmFilePath, lmProductData, coordinator);
        this.setReadOnlyAttribute("loadModule", loadModuleMo, coordinator);
        localLogger.traceGeneral(THIS_CLASS, "LoadModule created as a result of being removed by CPP: " + loadModuleMo.getLocalDistinguishedName());
    }

    protected String getProductRevisionFromLmFilePath(String lmFilePath) {
        String tmpString = DEFAULT_REVISION;
        try {
            tmpString = lmFilePath;
            int index = tmpString.indexOf(95) + 1;
            tmpString = tmpString.substring(index);
        }
        catch (Exception e) {
            tmpString = DEFAULT_REVISION;
        }
        if (tmpString.length() < 1 || tmpString.length() > 7) {
            tmpString = DEFAULT_REVISION;
        }
        return tmpString;
    }

    protected String getProductNumberFromLmFilePath(String lmFilePath) {
        String tmpString = UNKNOWN;
        try {
            int index = lmFilePath.indexOf(47) + 1;
            tmpString = lmFilePath.substring(index);
            index = tmpString.indexOf(95);
            tmpString = tmpString.substring(0, index);
            tmpString = ProductNumberHelper.convertPercentToSlash(tmpString);
        }
        catch (Exception e) {
            tmpString = UNKNOWN;
        }
        if (tmpString.length() < 1 || tmpString.length() > 24) {
            tmpString = UNKNOWN;
        }
        return tmpString;
    }
}

