/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omfapplication;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.auxpluginunit.RadioUnitManager;
import se.ericsson.crbs.cat.mao.auxpluginunit.helper.RbsConfigurationAutoConfigHelper;
import se.ericsson.crbs.cat.mao.ima.handler.ImaSignalHandler;
import se.ericsson.crbs.cat.mao.ima.proxy.ImaProxy;
import se.ericsson.crbs.cat.mao.interfaces.AutoIntegrationStartStateMachine;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChangeInformer;
import se.ericsson.crbs.cat.mao.nodeaddresschange.MoRepositoryHelper;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeHandler;
import se.ericsson.crbs.cat.mao.pic.proxy.PicProxyImpl;
import se.ericsson.crbs.cat.omfapplication.MoMetaDataNamesCatoam;
import se.ericsson.crbs.cat.omfapplication.PmAttributeHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;
import se.ericsson.crbs.omf.omfapplication.AbstractOmfApplication;
import se.ericsson.crbs.omf.omfapplication.OmfContext;

public class CatOmfApplication
extends AbstractOmfApplication {
    private static final Class THIS_CLASS = AbstractOmfApplication.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CATOAM_LM = "catoamLm";
    private static final String CATOAM_CONTEXT_ID = "CATOAM";
    private static final String RBS_CONFIGURATION = "RbsConfiguration";
    private static final String UNIT_TEST = "UNIT_TEST";
    private static final String TRUE = "TRUE";
    private NodeAddressChangeHandler nodeAddressChangeHandler = null;

    public CatOmfApplication() {
        super(CATOAM_LM, CATOAM_CONTEXT_ID, (PmAttribute)new PmAttributeHandler(), (MoMetaDataNames)new MoMetaDataNamesCatoam());
    }

    public CatOmfApplication(OmfContext anOmfContext) {
        super(CATOAM_LM, anOmfContext);
    }

    public void start() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "start");
        super.start();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - NodeAddressChangeHandler");
        this.startNodeAddressChangeHandler();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - NodeAddressChangeInformer");
        this.initRbsConfigurationNodeAddressChangeInformer();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - RbsConfiguration");
        this.startRbsConfigurationStateHandler();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Finished - RbsConfiguration");
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - Ima sercive");
        this.startImaProxy();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Finished - Ima service started successfully");
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - Pic sercive");
        this.startPicProxy();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Finished - Pic Service started Successfully");
        logger.traceDebug(((Object)((Object)this)).getClass(), "Starting - The subscriber for the ManagedElementData attribute autoConfigurationAllowed");
        this.startAutoConfigurationSubscriber();
        logger.traceDebug(((Object)((Object)this)).getClass(), "Finished - The subscriber for the ManagedElementData attribute autoConfigurationAllowed started Successfully");
        logger.traceReturn(((Object)((Object)this)).getClass(), "start");
    }

    private void startNodeAddressChangeHandler() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "startNodeAddressChangeHandler()");
        if (this.nodeAddressChangeHandler == null) {
            this.nodeAddressChangeHandler = new NodeAddressChangeHandler(this.theOmfContext.getMoRepositoryWrapper());
        }
        this.nodeAddressChangeHandler.start();
        logger.traceReturn(((Object)((Object)this)).getClass(), "startNodeAddressChangeHandler()");
    }

    private void initRbsConfigurationNodeAddressChangeInformer() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "initRbsConfigurationNodeAddressChangeInformer()");
        NodeAddressChangeInformer nodeAddressChangeInformer = MoRepositoryHelper.getNodeAddressChangeInformer(this.theOmfContext.getMoRepositoryWrapper());
        if (TRUE.equalsIgnoreCase(System.getProperty(UNIT_TEST))) {
            logger.traceDebug(((Object)((Object)this)).getClass(), "Are not calling NodeAddressChangeInformer.init() because of UnitTest mode");
        } else {
            nodeAddressChangeInformer.init(this.nodeAddressChangeHandler);
            logger.traceDebug(((Object)((Object)this)).getClass(), "Called NodeAddressChangeInformer.init()");
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "initRbsConfigurationNodeAddressChangeInformer()");
    }

    private void startRbsConfigurationStateHandler() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "startRbsConfigurationStateHandler()");
        MoIterator moIterator = this.theOmfContext.getMoRepositoryWrapper().lookupType(RBS_CONFIGURATION);
        boolean found = false;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject mo = moIterator.nextMo();
            if (!"NodeManagementFunction".equals(mo.getParent().getType())) continue;
            if (mo instanceof AutoIntegrationStartStateMachine) {
                AutoIntegrationStartStateMachine rbsConfiguration = (AutoIntegrationStartStateMachine)mo;
                if (TRUE.equalsIgnoreCase(System.getProperty(UNIT_TEST))) {
                    logger.traceDebug(((Object)((Object)this)).getClass(), "Are not calling RbsConfiguration.getStateHandler().start() because of UnitTest mode");
                } else {
                    rbsConfiguration.startStateMachine();
                    logger.traceDebug(((Object)((Object)this)).getClass(), "Called RbsConfiguration.getStateHandler.start()");
                }
                found = true;
                break;
            }
            logger.traceError(((Object)((Object)this)).getClass(), "Found a instance of RbsConfiguration that not implement AutoIntegrationStartStateMachine");
        }
        if (!found) {
            logger.traceError(((Object)((Object)this)).getClass(), "Could not find the system created MO RbsConfiguration!. Failed to start");
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "startRbsConfigurationStateHandler()");
    }

    private void startImaProxy() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "startImaProxy()");
        if (TRUE.equalsIgnoreCase(System.getProperty(UNIT_TEST))) {
            logger.traceDebug(((Object)((Object)this)).getClass(), "Are not calling imaProxy:startService() because of UnitTest mode");
        } else {
            ImaProxy imaProxy = new ImaProxy();
            new ImaSignalHandler(imaProxy, this.theOmfContext.getMoRepositoryWrapper());
            imaProxy.startService();
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "startImaProxy()");
    }

    private void startPicProxy() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "startPicProxy()");
        if (TRUE.equalsIgnoreCase(System.getProperty(UNIT_TEST))) {
            logger.traceDebug(((Object)((Object)this)).getClass(), "Are not calling picProxy:startService() because of UnitTest mode");
        } else {
            PicProxyImpl picProxy = new PicProxyImpl();
            new RadioUnitManager(picProxy, this.theOmfContext);
            picProxy.startService();
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "startPicProxy()");
    }

    private void startAutoConfigurationSubscriber() {
        logger.traceEnter(((Object)((Object)this)).getClass(), "startAutoConfigurationSubscriber()");
        if (TRUE.equalsIgnoreCase(System.getProperty(UNIT_TEST))) {
            logger.traceDebug(((Object)((Object)this)).getClass(), "Are not calling RbsConfigurationAutoConfigHelper.start() because of UnitTest mode");
        } else {
            RbsConfigurationAutoConfigHelper.getInstance().start(this.theOmfContext);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "startAutoConfigurationSubscriber()");
    }
}

