/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omfapplication;

import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;

public class PmAttributeHandler
implements PmAttribute {
    private static final Class THIS_CLASS = PmAttributeHandler.class;
    private static AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public int[][] getCounterValues(String moLocalDistinguishedName, String[] counterNames) throws ResourceUnavailableException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "getCounterValues()");
        int[][] values = null;
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        PmAttribute pmGetCounterValues = (PmAttribute)serviceRepository.getService(PmAttribute.class);
        if (pmGetCounterValues == null) {
            throw new ResourceUnavailableException("PmAttribute", "Service not available");
        }
        try {
            logger.traceDebug(this.getClass(), "Fetch instant counters for MO: " + moLocalDistinguishedName);
            values = pmGetCounterValues.getCounterValues(moLocalDistinguishedName, counterNames);
        }
        catch (ProcessingFailureException e) {
            throw new ProcessingFailureException(e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "getCounterValues()");
        return values;
    }
}

