/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.ipoam.DhcpMoFactory;
import se.ericsson.cello.ipoam.EthernetLinkMoFactory;
import se.ericsson.cello.ipoam.FroAlarmMappings;
import se.ericsson.cello.ipoam.GeneratedAlarmDefinitions;
import se.ericsson.cello.ipoam.IpAtmLinkMoFactory;
import se.ericsson.cello.ipoam.IpHostLinkMoFactory;
import se.ericsson.cello.ipoam.IpMoFactory;
import se.ericsson.cello.ipoam.IpOamMoFactory;
import se.ericsson.cello.ipoam.IpOamMoImpl;
import se.ericsson.cello.ipoam.IpRoutingTableMoFactory;
import se.ericsson.cello.ipoam.OspfAreaMoFactory;
import se.ericsson.cello.ipoam.OspfInterfaceMoFactory;
import se.ericsson.cello.ipoam.OspfMoFactory;
import se.ericsson.cello.ipoam.fropxy.OsaDhcprFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpFroMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpLinkMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaIpSystemMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAreaMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfInterfaceMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfMgmntProxy;
import se.ericsson.cello.ipoam.ipom_dhcpmi;
import se.ericsson.cello.ipoam.ipom_dnsclient_mi;
import se.ericsson.cello.ipoam.ipom_ethlink_mi;
import se.ericsson.cello.ipoam.ipom_iphostlinkmi;
import se.ericsson.cello.ipoam.ipom_iprouting_table_mi;
import se.ericsson.cello.mao.MaRevisionWriter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.proxy.FroProxyFactoryImpl;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.PmAppPortalImpl;
import se.ericsson.cello.support.debug.MessageLog;

public class IpMgr
implements Mopplet {
    private static FroProxy dhcpProxy = null;
    private static DhcpMoFactory dhcpFactory = null;
    private static FroProxy ipHostLinkProxy = null;
    private static IpHostLinkMoFactory ipHostLinkFactory = null;
    private static FroProxy ethernetLinkProxy = null;
    private static EthernetLinkMoFactory ethernetLinkMoFactory = null;
    private static FroProxy ipRoutingTableProxy = null;
    private static IpRoutingTableMoFactory ipRoutingTableFactory = null;
    private static FroProxy dnsClientProxy = null;
    private static final String IF_PM_IPOM_IPHOSTLINK = "se.ericsson.cello.ipoam.ipom_ip_host_link";
    private static final String IF_PM_IPOM_ETHERNETLINK = "se.ericsson.cello.ipoam.ipom_ethernet_link";

    public void init() {
        dhcpProxy = FroProxyFactoryImpl.getProxy((Class)ipom_dhcpmi.class, (String)"Dhcp");
        dhcpFactory = new DhcpMoFactory(dhcpProxy);
        dhcpFactory.registerFactory();
        ipHostLinkProxy = FroProxyFactoryImpl.getProxy((Class)ipom_iphostlinkmi.class, (String)"IpHostLink");
        ipHostLinkFactory = new IpHostLinkMoFactory(ipHostLinkProxy);
        ipHostLinkFactory.registerFactory();
        ipRoutingTableProxy = FroProxyFactoryImpl.getProxy((Class)ipom_iprouting_table_mi.class, (String)"IpRoutingTable");
        ipRoutingTableFactory = new IpRoutingTableMoFactory(ipRoutingTableProxy);
        ipRoutingTableFactory.registerFactory();
        ethernetLinkProxy = FroProxyFactoryImpl.getProxy((Class)ipom_ethlink_mi.class, (String)"EthernetLink");
        ethernetLinkMoFactory = new EthernetLinkMoFactory(ethernetLinkProxy);
        ethernetLinkMoFactory.registerFactory();
        dnsClientProxy = FroProxyFactoryImpl.getProxy((Class)ipom_dnsclient_mi.class, (String)"Ip");
        IpOamMoFactory.instance().registerFactory();
        IpMoFactory.instance(ipHostLinkProxy, dnsClientProxy);
        IpAtmLinkMoFactory.instance();
        OspfMoFactory.instance().registerFactory();
        OspfAreaMoFactory.instance().registerFactory();
        OspfInterfaceMoFactory.instance().registerFactory();
        IpOamMoImpl.instance();
        GeneratedAlarmDefinitions.init(AlarmManager.getDefinitionRepository());
        FroAlarmMappings.initiate();
        PmAppPortal pmAppPortal = PmAppPortalImpl.create();
        pmAppPortal.startProxy("IpHostLink", new String[]{IF_PM_IPOM_IPHOSTLINK});
        pmAppPortal.startProxy("EthernetLink", new String[]{IF_PM_IPOM_ETHERNETLINK});
    }

    public void start() {
        MaRevisionWriter.writeRevision((Object)this);
        IpOamMoImpl.instance().registerData();
        if (MoRepository.instance().lookupType("Dhcp") == null) {
            try {
                dhcpFactory.createInitialMo(dhcpProxy);
            }
            catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
                MessageLog.traceError(this.getClass(), (String)"Create instance of Dhcp MO failed", (Throwable)moNameAlreadyTakenException);
            }
        }
        dhcpProxy.subscribeService();
        OsaIpFroMgmntProxy.instance().subscribeService();
        OsaOspfMgmntProxy.instance().subscribeService();
        OsaIpLinkMgmntProxy.getInstance().subscribeService();
        OsaIpSystemMgmntProxy.instance().subscribeService();
        OsaOspfAreaMgmntProxy.instance().subscribeService();
        OsaOspfInterfaceMgmntProxy.instance().subscribeService();
        OsaDhcprFroMgmntProxy.instance().subscribeService();
        ipHostLinkProxy.subscribeService();
        ipRoutingTableProxy.subscribeService();
        ethernetLinkProxy.subscribeService();
        dnsClientProxy.subscribeService();
    }
}

