/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.ipoam.InvalidIndexException;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.ipoam.fropxy.RoutingTableEntries;
import se.ericsson.cello.ipoam.fropxy.StaticRoute;
import se.ericsson.cello.ipoam.fropxy.StaticRoutes;
import se.ericsson.cello.ipoam.mom.StructStaticRoute;
import se.ericsson.cello.ipoam.suaccess.IpRoutingTableMoSU_Access;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpRoutingTableMoImpl
extends CelloMao
implements IpRoutingTableMo,
IpRoutingTableMoSU_Access {
    Struct[] routes = new Struct[0];
    private MoData moData;
    private FroProxy genericProxyInstance;
    static String[] staticRoutingNames = StructStaticRoute.ELEMENT_NAMES;
    private static final String RESOURCE_ID = "resourceId";
    private int FRO_NUMBER = 1;
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2"};
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;
    static /* synthetic */ Class class$java$lang$String;

    public static IpRoutingTableMoImpl create(ManagedObject managedObject, String string, FroProxy froProxy, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Ip");
        MoAttributeValidator.checkIdentity((String)"IpRoutingTable", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"IpRoutingTable", (int)1);
        return new IpRoutingTableMoImpl(managedObject, string, coordinator, froProxy);
    }

    private IpRoutingTableMoImpl(ManagedObject managedObject, String string, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "IpRoutingTable", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.moData.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
        this.moData.registerPersistentAttr((Attribute)new LongAttribute(RESOURCE_ID, false, (long)this.FRO_NUMBER));
        this.moData.setRevision(3000);
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpRoutingTableMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.moData = moData;
        this.genericProxyInstance = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.moData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.moData.delete(coordinator);
        super.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            StaticRoutes staticRoutes;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.moData.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("staticRoutes")) {
                map = this.getFroParameters(map, coordinator);
                object = (ArrayParameter)map.get("staticRoutes");
                staticRoutes = new StaticRoutes((ArrayParameter)object);
                arrayList.add(staticRoutes.toStructArray());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("indexOfDeletableStaticRoutes")) {
                object = new ArrayList();
                int n = this.actionNumberOfRoutes(coordinator);
                for (int j = 0; j < n; ++j) {
                    staticRoutes = this.actionGetRoutingTableEntry(j, coordinator);
                    String string = (String)staticRoutes.getValue("nextHopIpAddr");
                    int n2 = (Integer)staticRoutes.getValue("routeType");
                    if (string.equals("") || n2 != 2) continue;
                    ((ArrayList)object).add(new Integer(j));
                }
                int[] nArray = new int[((ArrayList)object).size()];
                for (int j = 0; j < nArray.length; ++j) {
                    Integer n3 = (Integer)((ArrayList)object).get(j);
                    nArray[j] = n3;
                }
                arrayList.add(nArray);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpRoutingTable");
        }
        return arrayList.toArray();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpRoutingTableMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpRoutingTable");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpRoutingTable", (int)128, (int)0);
                ((StringAttribute)this.moData.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("staticRoutes")) {
                if (objectArray[i] != null && !(objectArray[i] instanceof Struct[])) {
                    throw new WrongAttributeTypeException("staticRoutes", "IpRoutingTable");
                }
                StaticRoutes staticRoutes = new StaticRoutes((Struct[])objectArray[i]);
                ArrayParameter arrayParameter = staticRoutes.toParameter();
                arrayList.add(arrayParameter);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpRoutingTable");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public String getType() {
        return "IpRoutingTable";
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public Struct[] getStaticRoutes(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("staticRoutes", coordinator);
    }

    public void setStaticRoutes(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("staticRoutes", structArray, coordinator);
    }

    public int[] getIndexOfDeletableStaticRoutes(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("indexOfDeletableStaticRoutes", coordinator);
    }

    public void actionAddStaticRoute(String string, String string2, String string3, int n, boolean bl, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string.equals("0.0.0.0") && !string2.equals("0.0.0.0")) {
            throw new ValueOutOfRangeException("Invalid IP Address And Subnet Mask", "IpRoutingTable");
        }
        if (string3.startsWith("0") || string3.startsWith("::")) {
            throw new ValueOutOfRangeException("nextHopIpAddr is not allowed to start with 0 for Ipv4, or :: for Ipv6", "IpRoutingTable");
        }
        boolean bl2 = Ipv6Address.isProperIPv6Address((String)string);
        if (!bl2) {
            new IpAddress(string);
        }
        int n2 = bl2 ? NetworkMask.calculateIpV6Prefix(string2) : NetworkMask.calculateIpV4Prefix(string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new StringParameter("ipAddress", string));
        arrayList.add(new SignedIntParameter("networkMask", n2));
        arrayList.add(new StringParameter("nextHopIpAddr", string3));
        arrayList.add(new SignedIntParameter("routeMetric", n));
        arrayList.add(new SignedIntParameter("redistribute", bl));
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 1, arrayList);
        Struct[] structArray = this.getStaticRoutes(coordinator);
        this.sendNotification("staticRoutes", structArray, coordinator);
    }

    public void actionDeleteStaticRoute(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        String string = null;
        Object object = null;
        String string2 = null;
        String string3 = null;
        Integer n2 = null;
        boolean bl = false;
        object = struct.getValue("destinationIpAddr");
        if (object instanceof String) {
            string3 = (String)object;
            bl = Ipv6Address.isProperIPv6Address((String)string3);
            if (!bl) {
                new IpAddress(string3);
            }
        } else {
            throw new WrongAttributeTypeException("destinationIpAddr", "IpRoutingTable");
        }
        object = struct.getValue("destinationNetworkMask");
        if (object instanceof String) {
            string = (String)object;
            n = bl ? NetworkMask.calculateIpV6Prefix(string) : NetworkMask.calculateIpV4Prefix(string);
        } else {
            throw new WrongAttributeTypeException("destinationNetworkMask", "IpRoutingTable");
        }
        object = struct.getValue("nextHopIpAddr");
        if (object instanceof String) {
            string2 = (String)object;
            boolean bl2 = Ipv6Address.isProperIPv6Address((String)string2);
            if (!bl2) {
                new IpAddress(string2);
            }
        } else {
            throw new WrongAttributeTypeException("nextHopIpAddr", "IpRoutingTable");
        }
        object = struct.getValue("routeMetric");
        if (!(object instanceof Integer)) {
            throw new WrongAttributeTypeException("routeMetric", "IpRoutingTable");
        }
        n2 = (Integer)object;
        arrayList.add(new StringParameter("ipAddress", string3, 47));
        arrayList.add(new SignedIntParameter("networkMask", n));
        arrayList.add(new StringParameter("nextHopIpAddr", string2));
        arrayList.add(new SignedIntParameter("routeMetric", n2));
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 2, arrayList);
        Struct[] structArray = this.getStaticRoutes(coordinator);
        this.sendNotification("staticRoutes", structArray, coordinator);
    }

    public Struct actionGetRoutingTableEntry(int n, Coordinator coordinator) throws MoAccessException {
        int n2 = n;
        if (n2 < 0 || n2 > this.routes.length - 1) {
            throw new InvalidIndexException("The given index does not existIpRoutingTable");
        }
        Struct struct = this.routes[n2];
        return struct;
    }

    public String actionListRoutes(Coordinator coordinator) throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        Map map = this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 3, arrayList);
        ArrayParameter arrayParameter = (ArrayParameter)map.get("routingTableEntryList");
        stringBuffer.append(this.actionNumberOfRoutes(coordinator));
        boolean bl = false;
        for (int i = 0; i < arrayParameter.size(); ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            stringBuffer.append("\n");
            stringBuffer.append(((StringParameter)structParameter.get("ipAddress")).getValue());
            stringBuffer.append(" ");
            bl = Ipv6Address.isProperIPv6Address((String)((StringParameter)structParameter.get("ipAddress")).getValue());
            int n = ((SignedIntParameter)structParameter.get("networkMask")).getValue();
            if (bl) {
                stringBuffer.append(n);
            } else {
                stringBuffer.append(NetworkMask.calculateIpV4SubnetMask(n).toString());
            }
            stringBuffer.append(" ");
            if (((StringParameter)structParameter.get("nextHopIpAddr")).getValue().equals("")) {
                stringBuffer.append("onlink");
                stringBuffer.append(" ");
            } else {
                stringBuffer.append(((StringParameter)structParameter.get("nextHopIpAddr")).getValue());
                stringBuffer.append(" ");
            }
            stringBuffer.append(((SignedIntParameter)structParameter.get("routeMetric")).getValue());
            stringBuffer.append(" ");
            stringBuffer.append(((SignedIntParameter)structParameter.get("routeType")).getValue());
            stringBuffer.append(" ");
            stringBuffer.append(((StringParameter)structParameter.get("interfaceName")).getValue());
            stringBuffer.append(" ");
            stringBuffer.append(((SignedIntParameter)structParameter.get("redistribute")).getBoolean() ? "TRUE" : "FALSE");
            stringBuffer.append(" ");
            stringBuffer.append(((SignedIntParameter)structParameter.get("active")).getBoolean() ? "active" : "inactive");
        }
        return stringBuffer.toString();
    }

    public String[] getIfName(Coordinator coordinator) throws MoAccessException {
        int n = this.actionNumberOfRoutes(coordinator);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Struct struct = this.actionGetRoutingTableEntry(i, coordinator);
            stringArray[i] = (String)struct.getValue("interfaceName");
        }
        return stringArray;
    }

    public void actionModifyStaticRoute(Struct struct, Struct struct2, Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        StaticRoute staticRoute = new StaticRoute(struct, "oldStaticRoute");
        StaticRoute staticRoute2 = new StaticRoute(struct2, "StaticRoute");
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(staticRoute.toParameter());
        arrayList.add(staticRoute2.toParameter());
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 4, arrayList);
        this.sendNotification("staticRoutes", this.getStaticRoutes(coordinator), coordinator);
    }

    public int actionNumberOfRoutes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 3, null);
        ArrayParameter arrayParameter = (ArrayParameter)map.get("routingTableEntryList");
        RoutingTableEntries routingTableEntries = new RoutingTableEntries(arrayParameter);
        this.routes = routingTableEntries.toStructArray();
        return this.routes.length;
    }

    public boolean getValueForActive(Struct struct) throws MoAccessException {
        return (Boolean)struct.getValue("active");
    }

    public String getValueForDestinationIpAddr(Struct struct) throws MoAccessException {
        return (String)struct.getValue("destinationIpAddr");
    }

    public String getValueForDestinationNetworkMask(Struct struct) throws MoAccessException {
        return (String)struct.getValue("destinationNetworkMask");
    }

    public String getValueForInterfaceName(Struct struct) throws MoAccessException {
        return (String)struct.getValue("interfaceName");
    }

    public String getValueForNextHopIpAddr(Struct struct) throws MoAccessException {
        return (String)struct.getValue("nextHopIpAddr");
    }

    public boolean getValueForRedistribute(Struct struct) throws MoAccessException {
        return (Boolean)struct.getValue("redistribute");
    }

    public int getValueForRouteMetric(Struct struct) throws MoAccessException {
        return (Integer)struct.getValue("routeMetric");
    }

    public int getValueForRouteType(Struct struct) throws MoAccessException {
        return (Integer)struct.getValue("routeType");
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.moData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return (int)((LongAttribute)this.moData.getAttribute(RESOURCE_ID)).getValue(coordinator);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }
}

