/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.ipoam.EthernetLinkMoImpl;
import se.ericsson.cello.ipoam.IpAtmLinkMoImpl;
import se.ericsson.cello.ipoam.IpHostLinkMoImpl;
import se.ericsson.cello.ipoam.IpInterfaceBuildIF;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;

public class IpValidationUtil {
    private static final int MAPPED_PREFIXLENGTH = 8;
    private static final int IP_ADDR = 0;
    private static final int SUBNET_ADDR = 1;

    public static void checkIpAdressUniqueness(ManagedObject managedObject, String string, int n, ManagedObject managedObject2, String string2, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject3 = null;
        String string3 = null;
        String[] stringArray = IpValidationUtil.calculateSubnetandIpAddresses(string, n, coordinator);
        if (stringArray != null && !stringArray[1].equals("0.0.0.0")) {
            while (moIterator.hasMoreElements()) {
                String[] stringArray2;
                int n2;
                Object object;
                managedObject3 = moIterator.nextMo();
                if (managedObject2 != null && managedObject3 == managedObject2) continue;
                if (managedObject3.getType().equals("EthernetLink")) {
                    object = ((EthernetLinkMoImpl)managedObject3).getIpv4Addresses(coordinator);
                    if (object == null || ((Struct[])object).length <= 0) continue;
                    string3 = (String)object[0].getValue("ipAddress");
                    n2 = (Integer)object[0].getValue("prefixLength");
                    stringArray2 = IpValidationUtil.calculateSubnetandIpAddresses(string3, n2, coordinator);
                    IpValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, string2);
                    continue;
                }
                if (managedObject3.getType().equals("IpHostLink")) {
                    string3 = ((IpHostLinkMoImpl)managedObject3).getIpAddress(coordinator);
                    object = ((IpHostLinkMoImpl)managedObject3).getIpInterfaceMoRef(coordinator);
                    n2 = IpValidationUtil.getNetworkPrefixLength(object, coordinator);
                    stringArray2 = IpValidationUtil.calculateSubnetandIpAddresses(string3, n2, coordinator);
                    IpValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, string2);
                    continue;
                }
                if (!managedObject3.getType().equals("IpAtmLink")) continue;
                string3 = ((IpAtmLinkMoImpl)managedObject3).getIpAddress(coordinator);
                object = ((IpAtmLinkMoImpl)managedObject3).getSubnetMask(coordinator);
                n2 = NetworkMask.calculateIpV4Prefix((String)object);
                stringArray2 = IpValidationUtil.calculateSubnetandIpAddresses(string3, n2, coordinator);
                IpValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, string2);
            }
        }
    }

    private static String[] calculateSubnetandIpAddresses(String string, int n, Coordinator coordinator) throws MoAccessException {
        if (!string.equals("") && !string.equals("0.0.0.0")) {
            String[] stringArray = new String[2];
            IpAddress ipAddress = new IpAddress(string);
            IpAddress ipAddress2 = null;
            if (n == 0) {
                n = 8;
            }
            ipAddress2 = ipAddress.getSubnetAddress(n);
            stringArray[0] = string;
            stringArray[1] = ipAddress2.toString();
            return stringArray;
        }
        return null;
    }

    private static void compareIpandSubnetAddresses(String[] stringArray, String[] stringArray2, ManagedObject managedObject, String string) throws MoAccessException, OperationNotAllowedException {
        if (stringArray2 != null && (stringArray[0].equals(stringArray2[0]) || stringArray[1].equals(stringArray2[1]))) {
            throw new OperationNotAllowedException(string + "Mo ipAddress must not belong to the subnetwork of : " + managedObject.getFullDistinguishedName(), managedObject.getType());
        }
    }

    public static void checkIpAdressUniqueness(ManagedObject managedObject, String string, ManagedObject managedObject2, Coordinator coordinator, ManagedObject managedObject3, String string2) throws MoAccessException, OperationNotAllowedException {
        IpValidationUtil.checkIpAdressUniqueness(managedObject, string, IpValidationUtil.getNetworkPrefixLength(managedObject2, coordinator), managedObject3, string2, coordinator);
    }

    private static int getNetworkPrefixLength(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (managedObject instanceof IpInterfaceBuildIF) {
            n = ((IpInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
        }
        return n;
    }
}

