/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import enea.ose.system.Signal;
import se.ericsson.cello.ipoam.EthernetLinkMoImpl;
import se.ericsson.cello.ipoam.IpAtmLinkMoImpl;
import se.ericsson.cello.ipoam.OspfAreaMo;
import se.ericsson.cello.ipoam.OspfAreaMoImpl;
import se.ericsson.cello.ipoam.OspfInterfaceMo;
import se.ericsson.cello.ipoam.OspfMo;
import se.ericsson.cello.ipoam.OspfMoImpl;
import se.ericsson.cello.ipoam.fropxy.OsaOspfAddIfFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfDelIfFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfGetCountersRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfIfGetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfIfSetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfInterfaceMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfSetIfAreaRsp;
import se.ericsson.cello.ipoam.fropxy.Osa_OspfObjId;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class OspfInterfaceMoImpl
extends ManagedObjectBase
implements OspfInterfaceMo {
    private MoData data;
    private ReferenceAttribute relatedLinkMo;
    private ReferenceAttribute ospfAreaRelated;
    private IntegerAttribute ospfIfFroId;
    private StringAttribute userLabel;
    private static final int OSA_OSPF_IF_AREA_ID = 10;
    private static final int OSA_OSPF_IF_LSA_INTERVAL = 11;
    private static final int OSA_OSPF_IF_HELLO_INTERVAL = 12;
    private static final int OSA_OSPF_IF_DEAD_INTERVAL = 13;
    private static final int OSA_OSPF_IF_TX_DELAY = 14;
    private static final int OSA_OSPF_IF_ROUTER_PRI = 15;
    private static final int OSPF_SUCCESS = 0;
    private static final String OSPF_IF_FRO_ID = "ospfInterfaceFroId";
    private static OsaOspfInterfaceMgmntProxy froProxy = OsaOspfInterfaceMgmntProxy.instance();
    public static final int MIN_INTERFACE_PRIO = 0;
    public static final int MAX_INTERFACE_PRIO = 255;
    public static final int MAX_NUMBER_OF_OSPFINTERFACES = 32;
    public static final int MAX_OSPFINTERFACE_ASSOCIATED = 8;
    public static final int DEFAULT_INTERFACE_PRIO = 1;
    public static final String[] OSPFAREA_CLASSNAME = new String[]{"se.ericsson.cello.ipoam.OspfAreaMoImpl"};
    public static final String[] RELATEDLINK_CLASSNAME = new String[]{"se.ericsson.cello.ipoam.EthernetLinkMoImpl", "se.ericsson.cello.ipoam.IpAtmLinkMoImpl"};
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Ospf");
        MoAttributeValidator.checkIdentity((String)"OspfInterface", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"OspfInterface", (int)32);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"OspfInterface", (int)128, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ospfAreaRelated", (AttrList)attrList, (boolean)false, (String[])OSPFAREA_CLASSNAME, (String)"OspfInterface");
        int n = OspfInterfaceMoImpl.checkAndGetLsaTransmissionInterval(attrList);
        int n2 = OspfInterfaceMoImpl.checkAndGetHelloInterval(attrList);
        int n3 = OspfInterfaceMoImpl.checkAndGetRouterDeadInterval(attrList);
        int n4 = OspfInterfaceMoImpl.checkAndGetInterfaceTransitDelay(attrList);
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"interfacePriority", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)255, (String)"OspfInterface");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"relatedLink", (AttrList)attrList, (boolean)true, (String[])RELATEDLINK_CLASSNAME, (String)"OspfInterface");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"OspfInterface");
        if (n3 <= n2) {
            throw new IllegalAttributeValueException("The value of routerDeadInterval need to be greater than the value of helloInterval", "OspfInterface");
        }
        return new OspfInterfaceMoImpl(managedObject, string, string2, managedObject3, n, n2, n3, n4, n5, managedObject4, coordinator);
    }

    private OspfInterfaceMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, int n, int n2, int n3, int n4, int n5, ManagedObject managedObject3, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "OspfInterface", string, coordinator);
        int n6;
        String string3;
        Object object;
        int n7;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(3500);
        this.ospfAreaRelated = new ReferenceAttribute("ospfAreaRelated", true);
        if (managedObject2 != null) {
            this.checkOspfInterfaceAssociated(managedObject2);
            ((OspfAreaMoImpl)managedObject2).reserve(this, coordinator);
            n7 = ((OspfAreaMoImpl)managedObject2).getOspfAreaFroId(coordinator);
            this.ospfAreaRelated.setValue(managedObject2);
        } else {
            object = (OspfAreaMoImpl)((OspfMo)managedObject).findDefaultOspfAreaLDN();
            this.checkOspfInterfaceAssociated((ManagedObject)object);
            ((OspfAreaMoImpl)object).reserve(this, coordinator);
            n7 = ((OspfAreaMoImpl)object).getOspfAreaFroId(coordinator);
            this.ospfAreaRelated.setValue((ManagedObject)object);
        }
        object = new Osa_OspfObjId();
        ((Osa_OspfObjId)object).instanceId = n7;
        String string4 = "OspfArea";
        ((Osa_OspfObjId)object).className = MaoFroTypeConverter.string2byteArray((String)string4, (int)32);
        int n8 = ((OspfMoImpl)managedObject).getOspfFroId(coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = n8;
        String string5 = "Ospf";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string5, (int)32);
        if (managedObject3 instanceof IpAtmLinkMoImpl) {
            string3 = "AtmLink";
            n6 = ((IpAtmLinkMoImpl)managedObject3).getIpOverAtmFroId(coordinator);
            ((IpAtmLinkMoImpl)managedObject3).reserve(this, coordinator);
        } else {
            string3 = "EthernetLink";
            n6 = ((EthernetLinkMoImpl)managedObject3).getFroId(coordinator);
            ((EthernetLinkMoImpl)managedObject3).reserve(this, coordinator);
        }
        Osa_OspfObjId osa_OspfObjId2 = new Osa_OspfObjId();
        osa_OspfObjId2.instanceId = n6;
        osa_OspfObjId2.className = MaoFroTypeConverter.string2byteArray((String)string3, (int)32);
        OsaOspfAddIfFroRsp osaOspfAddIfFroRsp = froProxy.sendOspfAddIfFroReq(coordinator.getTransactionID(), osa_OspfObjId, osa_OspfObjId2, (Osa_OspfObjId)object, n, n2, n3, n4, n5);
        this.checkSignal((Signal)osaOspfAddIfFroRsp);
        if (osaOspfAddIfFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "CreateFroReq: " + froProxy.getResultMsg(osaOspfAddIfFroRsp.getResult()), osaOspfAddIfFroRsp.getResult());
        }
        int n9 = osaOspfAddIfFroRsp.getFroId();
        this.ospfIfFroId = new IntegerAttribute(OSPF_IF_FRO_ID, false, n9);
        this.data.registerPersistentAttr((Attribute)this.ospfIfFroId);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.data.registerPersistentAttr((Attribute)this.ospfAreaRelated);
        this.relatedLinkMo = new ReferenceAttribute("relatedLink", false);
        this.relatedLinkMo.setValue(managedObject3);
        this.data.registerPersistentAttr((Attribute)this.relatedLinkMo);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void checkOspfInterfaceAssociated(ManagedObject managedObject) throws MoAccessException {
        ManagedObject[] managedObjectArray = ((OspfAreaMo)managedObject).getReservedBy(null);
        if (managedObjectArray.length >= 8) {
            throw new MaxNumberExceededException("OspfInterface", "Max number of this MO associated with OspfArea is exceeded. Max number=8");
        }
    }

    public OspfInterfaceMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("relatedLink");
        moDataRecoveryHelper.assertAttribute(OSPF_IF_FRO_ID);
        moDataRecoveryHelper.assertAttribute("ospfAreaRelated");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.relatedLinkMo = (ReferenceAttribute)moData.getAttribute("relatedLink");
        this.ospfIfFroId = (IntegerAttribute)moData.getAttribute(OSPF_IF_FRO_ID);
        this.ospfAreaRelated = (ReferenceAttribute)moData.getAttribute("ospfAreaRelated");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.relatedLinkMo.getValue(coordinator) instanceof IpAtmLinkMoImpl) {
            ((IpAtmLinkMoImpl)this.relatedLinkMo.getValue(coordinator)).release(this, coordinator);
        } else {
            ((EthernetLinkMoImpl)this.relatedLinkMo.getValue(coordinator)).release(this, coordinator);
        }
        ((OspfAreaMoImpl)this.ospfAreaRelated.getValue(coordinator)).release(this, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = "OspfInterface";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfDelIfFroRsp osaOspfDelIfFroRsp = froProxy.sendOspfDelIfFroReq(coordinator.getTransactionID(), osa_OspfObjId);
        this.checkSignal((Signal)osaOspfDelIfFroRsp);
        if (osaOspfDelIfFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "DeleteFroReq: " + froProxy.getResultMsg(osaOspfDelIfFroRsp.getResult()), osaOspfDelIfFroRsp.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"OspfInterface", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject getOspfAreaRelated(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ospfAreaRelated.getValue(coordinator);
    }

    public void setOspfAreaRelated(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("OspfInterface", (Object)managedObject);
        }
        if (!(managedObject instanceof OspfAreaMoImpl)) {
            throw new WrongAttributeTypeException("ospfAreaRelated", "OspfInterface");
        }
        if (this.ospfAreaRelated.getValue(coordinator) != managedObject) {
            ((OspfAreaMoImpl)this.ospfAreaRelated.getValue(coordinator)).release(this, coordinator);
            ((OspfAreaMoImpl)managedObject).reserve(this, coordinator);
            this.ospfAreaRelated.setValue(managedObject);
            int n = ((OspfAreaMoImpl)managedObject).getOspfAreaFroId(coordinator);
            Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
            String string = "OspfArea";
            osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
            osa_OspfObjId.instanceId = n;
            Osa_OspfObjId osa_OspfObjId2 = new Osa_OspfObjId();
            osa_OspfObjId2.instanceId = this.ospfIfFroId.getValue(coordinator);
            String string2 = "OspfInterface";
            osa_OspfObjId2.className = MaoFroTypeConverter.string2byteArray((String)string2, (int)32);
            OsaOspfSetIfAreaRsp osaOspfSetIfAreaRsp = froProxy.sendOspfSetIfAreaReq(coordinator.getTransactionID(), osa_OspfObjId2, osa_OspfObjId);
            this.checkSignal((Signal)osaOspfSetIfAreaRsp);
            if (osaOspfSetIfAreaRsp.getResult() != 0) {
                throw new FroRequestFailedException("OspfInterface", "OspfInterface", "SetAttrReq: " + froProxy.getResultMsg(osaOspfSetIfAreaRsp.getResult()), osaOspfSetIfAreaRsp.getResult());
            }
            this.ospfAreaRelated.setValue(managedObject);
        }
    }

    public int getLsaTransmissionInterval(Coordinator coordinator) throws MoAccessException {
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = this.getOspfIfAttributes(coordinator);
        return osaOspfIfGetAttrRsp.getLsaInterval();
    }

    public void setLsaTransmissionInterval(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("lsaTransmissionInterval", "OspfInterface");
        }
        String[] stringArray = new String[]{"lsaTransmissionInterval"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfInterfaceMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = "OspfInterface";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfSetAttrRsp osaOspfIfSetAttrRsp = froProxy.sendOspfIfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 11, n);
        this.checkSignal((Signal)osaOspfIfSetAttrRsp);
        if (osaOspfIfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "DeleteFroReq: " + froProxy.getResultMsg(osaOspfIfSetAttrRsp.getResult()), osaOspfIfSetAttrRsp.getResult());
        }
    }

    public int getHelloInterval(Coordinator coordinator) throws MoAccessException {
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = this.getOspfIfAttributes(coordinator);
        return osaOspfIfGetAttrRsp.getHelloInterval();
    }

    public void setHelloInterval(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("helloInterval", "OspfInterface");
        }
        int n2 = this.getRouterDeadInterval(coordinator);
        if (n >= n2) {
            throw new IllegalAttributeValueException("The value of helloInterval need to be less than the valueof routerDeadInterval", "OspfInterface");
        }
        String[] stringArray = new String[]{"helloInterval"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfInterfaceMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = new String("OspfInterface");
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfSetAttrRsp osaOspfIfSetAttrRsp = froProxy.sendOspfIfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 12, n);
        this.checkSignal((Signal)osaOspfIfSetAttrRsp);
        if (osaOspfIfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "SetAttrReq: " + froProxy.getResultMsg(osaOspfIfSetAttrRsp.getResult()), osaOspfIfSetAttrRsp.getResult());
        }
    }

    public int getRouterDeadInterval(Coordinator coordinator) throws MoAccessException {
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = this.getOspfIfAttributes(coordinator);
        return osaOspfIfGetAttrRsp.getDeadInterval();
    }

    public void setRouterDeadInterval(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("routerDeadInterval", "OspfInterface");
        }
        int n2 = this.getHelloInterval(coordinator);
        if (n <= n2) {
            throw new IllegalAttributeValueException("The value of routerDeadInterval need to be greater than the value of helloInterval", "OspfInterface");
        }
        String[] stringArray = new String[]{"routerDeadInterval"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfInterfaceMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = new String("OspfInterface");
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfSetAttrRsp osaOspfIfSetAttrRsp = froProxy.sendOspfIfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 13, n);
        this.checkSignal((Signal)osaOspfIfSetAttrRsp);
        if (osaOspfIfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "SetAttrReq: " + froProxy.getResultMsg(osaOspfIfSetAttrRsp.getResult()), osaOspfIfSetAttrRsp.getResult());
        }
    }

    public int getInterfaceTransitDelay(Coordinator coordinator) throws MoAccessException {
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = this.getOspfIfAttributes(coordinator);
        return osaOspfIfGetAttrRsp.getTxDelay();
    }

    public void setInterfaceTransitDelay(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0) {
            throw new ValueOutOfRangeException("interfaceTransitDelay", "OspfInterface");
        }
        String[] stringArray = new String[]{"interfaceTransitDelay"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfInterfaceMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = "OspfInterface";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfSetAttrRsp osaOspfIfSetAttrRsp = froProxy.sendOspfIfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 14, n);
        this.checkSignal((Signal)osaOspfIfSetAttrRsp);
        if (osaOspfIfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "SetAttrReq: " + froProxy.getResultMsg(osaOspfIfSetAttrRsp.getResult()), osaOspfIfSetAttrRsp.getResult());
        }
    }

    public int getInterfacePriority(Coordinator coordinator) throws MoAccessException {
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = this.getOspfIfAttributes(coordinator);
        return osaOspfIfGetAttrRsp.getRouterPri();
    }

    public void setInterfacePriority(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n < 0 || n > 255) {
            throw new ValueOutOfRangeException("interfacePriority", "OspfInterface");
        }
        String[] stringArray = new String[]{"interfacePriority"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfInterfaceMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = "OspfInterface";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfSetAttrRsp osaOspfIfSetAttrRsp = froProxy.sendOspfIfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 15, n);
        this.checkSignal((Signal)osaOspfIfSetAttrRsp);
        if (osaOspfIfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "SetAttrReq: " + froProxy.getResultMsg(osaOspfIfSetAttrRsp.getResult()), osaOspfIfSetAttrRsp.getResult());
        }
    }

    public ManagedObject getRelatedLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.relatedLinkMo.getValue(coordinator);
    }

    public int getPmNoOfOspfIfEvents(Coordinator coordinator) throws MoAccessException {
        int n = 3;
        return this.getOspfInterfacePmCounters(n).getPmNoOfOspfIfEvents();
    }

    private OsaOspfGetCountersRsp getOspfInterfacePmCounters(int n) throws FroNotAccessibleException, FroRequestFailedException {
        long[] lArray = new long[]{n, 0L};
        String string = "OspfInterface";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfIfFroId.getValue(null));
        OsaOspfGetCountersRsp osaOspfGetCountersRsp = froProxy.sendOspfGetCountersReq(osa_OspfObjId, lArray);
        this.checkSignal((Signal)osaOspfGetCountersRsp);
        if (osaOspfGetCountersRsp.getStatus() == 100) {
            osaOspfGetCountersRsp.setPmCountersUnavailable();
        } else if (osaOspfGetCountersRsp.getStatus() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "GetAttrReq: " + froProxy.getResultMsg(osaOspfGetCountersRsp.getStatus()), osaOspfGetCountersRsp.getStatus());
        }
        return osaOspfGetCountersRsp;
    }

    private OsaOspfIfGetAttrRsp getOspfIfAttributes(Coordinator coordinator) throws FroNotAccessibleException, FroRequestFailedException, MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = this.ospfIfFroId.getValue(coordinator);
        String string = "OspfInterface";
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        OsaOspfIfGetAttrRsp osaOspfIfGetAttrRsp = froProxy.sendOspfIfGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), osa_OspfObjId);
        this.checkSignal((Signal)osaOspfIfGetAttrRsp);
        if (osaOspfIfGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("OspfInterface", "OspfInterface", "GetAttrReq: " + froProxy.getResultMsg(osaOspfIfGetAttrRsp.getResult()), osaOspfIfGetAttrRsp.getResult());
        }
        return osaOspfIfGetAttrRsp;
    }

    public String getType() {
        return "OspfInterface";
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("OspfInterface", "OspfInterface fro is not accessible.");
        }
    }

    private static int checkAndGetLsaTransmissionInterval(AttrList attrList) throws MoAccessException {
        int n = 5;
        int n2 = attrList.indexOf("lsaTransmissionInterval");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("lsaTransmissionInterval", "OspfInterface");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException("lsaTransmissionInterval", "OspfInterface");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetHelloInterval(AttrList attrList) throws MoAccessException {
        int n = 10;
        int n2 = attrList.indexOf("helloInterval");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("helloInterval", "OspfInterface");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException("helloInterval", "OspfInterface");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRouterDeadInterval(AttrList attrList) throws MoAccessException {
        int n = 40;
        int n2 = attrList.indexOf("routerDeadInterval");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("routerDeadInterval", "OspfInterface");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException("routerDeadInterval", "OspfInterface");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetInterfaceTransitDelay(AttrList attrList) throws MoAccessException {
        int n = 1;
        int n2 = attrList.indexOf("interfaceTransitDelay");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("interfaceTransitDelay", "OspfInterface");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException("interfaceTransitDelay", "OspfInterface");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private Osa_OspfObjId createOspfObj(String string, int n) {
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = n;
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        return osa_OspfObjId;
    }
}

