/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipoam;

import se.ericsson.cello.ipoam.IpMoImpl;
import se.ericsson.cello.ipoam.OspfAreaMo;
import se.ericsson.cello.ipoam.OspfAreaMoImpl;
import se.ericsson.cello.ipoam.OspfMo;
import se.ericsson.cello.ipoam.fropxy.OsaOspfCreateFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfDelFroRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfGetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfGetCountersRsp;
import se.ericsson.cello.ipoam.fropxy.OsaOspfMgmntProxy;
import se.ericsson.cello.ipoam.fropxy.OsaOspfSetAttrRsp;
import se.ericsson.cello.ipoam.fropxy.Osa_OspfObjId;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class OspfMoImpl
extends ManagedObjectBase
implements OspfMo {
    private MoData data;
    private ReferenceAttribute ipMo;
    private StringAttribute userLabel;
    private IntegerAttribute ospfFroId;
    private static OsaOspfMgmntProxy froProxy = OsaOspfMgmntProxy.instance();
    public static final String OSPF_FRO_ID = "OsfpFroId";
    public static final int DEFAULT_ADMIN_STATUS = 0;
    public static final boolean DEFAULT_OSPFAS_BDRRTR_STATUS = false;
    public static final boolean DEFAULT_RECOVERTOPODB = true;
    public static final int DEFAULT_TOPODBSTORE_INTERV = 60;
    public static final int OSPF_SUCCESS = 0;
    public static final String[] IPMO_CLASSNAME = new String[]{"se.ericsson.cello.ipoam.IpMoImpl"};
    private static final int MO_DATA_REVISION_3 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpOam");
        MoAttributeValidator.checkIdentity((String)"Ospf", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Ospf", (int)128, (int)0);
        int n = OspfMoImpl.checkAndGetOspfRouterId(attrList);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"ospfASBdrRtrStatus", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Ospf");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"Ospf");
        IpMoImpl ipMoImpl = (IpMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipMo", (AttrList)attrList, (boolean)true, (String[])IPMO_CLASSNAME, (String)"Ospf");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"recoverTopoDb", (AttrList)attrList, (boolean)false, (boolean)true, (String)"Ospf");
        int n3 = OspfMoImpl.checkAndGetTopoDbStoreInterv(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Ospf");
        return new OspfMoImpl(managedObject, n, bl, n2, ipMoImpl, bl2, n3, string2, string, coordinator);
    }

    private OspfMoImpl(ManagedObject managedObject, int n, boolean bl, int n2, IpMoImpl ipMoImpl, boolean bl2, int n3, String string, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Ospf", string2, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        int n4 = ipMoImpl.getIpFroId(coordinator);
        String string3 = "Ip";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string3, n4);
        ipMoImpl.reserve(this, coordinator);
        int n5 = MaoFroTypeConverter.boolean2int((boolean)bl);
        int n6 = MaoFroTypeConverter.boolean2int((boolean)bl2);
        OsaOspfCreateFroRsp osaOspfCreateFroRsp = froProxy.sendOspfCreateFroReq(coordinator.getTransactionID(), osa_OspfObjId, n, n2, n5, n6, n3);
        if (osaOspfCreateFroRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfCreateFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "CreateFroReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfCreateFroRsp.getResult()), osaOspfCreateFroRsp.getResult());
        }
        int n7 = osaOspfCreateFroRsp.getFroId();
        this.ospfFroId = new IntegerAttribute(OSPF_FRO_ID, false, n7);
        this.data.registerPersistentAttr((Attribute)this.ospfFroId);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.ipMo = new ReferenceAttribute("ipMo", false);
        this.ipMo.setValue((ManagedObject)ipMoImpl);
        this.data.registerPersistentAttr((Attribute)this.ipMo);
        froProxy.registerForNotifications(coordinator, this, this.ospfFroId.getValue(coordinator));
        this.data.setRevision(3000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        OspfAreaMoImpl.autoCreateMo(this, coordinator);
    }

    public OspfMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ipMo");
        moDataRecoveryHelper.assertAttribute(OSPF_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.ipMo = (ReferenceAttribute)moData.getAttribute("ipMo");
        this.ospfFroId = (IntegerAttribute)moData.getAttribute(OSPF_FRO_ID);
        froProxy.registerForNotifications(null, this, this.ospfFroId.getValue(null));
    }

    public OspfAreaMo findDefaultOspfAreaLDN() throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            OspfAreaMo ospfAreaMo;
            String string;
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof OspfAreaMo) || !(string = (ospfAreaMo = (OspfAreaMo)managedObject).getAreaId(null)).equals("0.0.0.0")) continue;
            return ospfAreaMo;
        }
        return null;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((IpMoImpl)this.ipMo.getValue(coordinator)).release(this, coordinator);
        OspfAreaMoImpl ospfAreaMoImpl = (OspfAreaMoImpl)this.findDefaultOspfAreaLDN();
        ospfAreaMoImpl.deleteMo(coordinator);
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        OsaOspfDelFroRsp osaOspfDelFroRsp = froProxy.sendOspfDelFroReq(coordinator.getTransactionID(), osa_OspfObjId);
        if (osaOspfDelFroRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfDelFroRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "DeleteFroReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfDelFroRsp.getResult()), osaOspfDelFroRsp.getResult());
        }
        froProxy.deregisterForNotifications(coordinator, this.ospfFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getOspfFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ospfFroId.getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Ospf", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getOspfRouterId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        int n = (int)osaOspfGetAttrRsp.getRouterId();
        String string = new IpAddress((long)n).toString();
        return string;
    }

    public void setOspfRouterId(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{"ospfRouterId"};
        Object[] objectArray = new Object[]{string};
        OspfMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string2 = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string2, this.ospfFroId.getValue(coordinator));
        int n = new IpAddress(string).toInt();
        OsaOspfSetAttrRsp osaOspfSetAttrRsp = froProxy.sendOspfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 0, n);
        if (osaOspfSetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "SetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfSetAttrRsp.getResult()), osaOspfSetAttrRsp.getResult());
        }
    }

    public boolean getOspfASBdrRtrStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        int n = (int)osaOspfGetAttrRsp.getIsAsBr();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public void setOspfASBdrRtrStatus(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{"ospfASBdrRtrStatus"};
        Object[] objectArray = new Object[]{new Boolean(bl)};
        OspfMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        OsaOspfSetAttrRsp osaOspfSetAttrRsp = froProxy.sendOspfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 2, n);
        if (osaOspfSetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "SetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfSetAttrRsp.getResult()), osaOspfSetAttrRsp.getResult());
        }
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        return (int)osaOspfGetAttrRsp.getOpState();
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        return (int)osaOspfGetAttrRsp.getAdmState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        return AvailConverter.convert((int)((int)osaOspfGetAttrRsp.getAvailState()));
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            default: {
                throw new ValueOutOfRangeException("administrativeState", "Ospf");
            }
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        OsaOspfSetAttrRsp osaOspfSetAttrRsp = froProxy.sendOspfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 1, n);
        if (osaOspfSetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "SetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfSetAttrRsp.getResult()), osaOspfSetAttrRsp.getResult());
        }
    }

    public boolean getOspfAreaBdrRtrStatus(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        int n = (int)osaOspfGetAttrRsp.getIsAreaBr();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public ManagedObject getIpMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.ipMo.getValue(coordinator);
    }

    public boolean getRecoverTopoDb(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        int n = (int)osaOspfGetAttrRsp.getTopoSave();
        boolean bl = MaoFroTypeConverter.int2boolean((int)n);
        return bl;
    }

    public void setRecoverTopoDb(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{"recoverTopoDb"};
        Object[] objectArray = new Object[]{new Boolean(bl)};
        OspfMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        OsaOspfSetAttrRsp osaOspfSetAttrRsp = froProxy.sendOspfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 3, n);
        if (osaOspfSetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "SetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfSetAttrRsp.getResult()), osaOspfSetAttrRsp.getResult());
        }
    }

    public int getTopoDbStoreInterv(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = this.getOspfAttributes(coordinator);
        return (int)osaOspfGetAttrRsp.getTopoSaveInterval();
    }

    public void setTopoDbStoreInterv(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0) {
            throw new ValueOutOfRangeException("topoDbStoreInterv", "Ospf");
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{"topoDbStoreInterv"};
        Object[] objectArray = new Object[]{new Integer(n)};
        OspfMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        if (n < 0) {
            throw new ValueOutOfRangeException("topoDbStoreInterv", "Ospf");
        }
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        OsaOspfSetAttrRsp osaOspfSetAttrRsp = froProxy.sendOspfSetAttrReq(coordinator.getTransactionID(), osa_OspfObjId, 4, n);
        if (osaOspfSetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfSetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "SetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfSetAttrRsp.getResult()), osaOspfSetAttrRsp.getResult());
        }
    }

    public int getPmNoOfOspfOriginateNewLsas(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 1;
        return this.getOspfPmCounters(n).getPmNoOfOspfOriginateNewLsas();
    }

    public int getPmNoOfOspfRxNewLsas(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 2;
        return this.getOspfPmCounters(n).getPmNoOfOspfRxNewLsas();
    }

    private OsaOspfGetCountersRsp getOspfPmCounters(int n) throws MoAccessException {
        long[] lArray = new long[]{n, 0L};
        String string = new String("Ospf");
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(null));
        OsaOspfGetCountersRsp osaOspfGetCountersRsp = froProxy.sendOspfGetCountersReq(osa_OspfObjId, lArray);
        if (osaOspfGetCountersRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfGetCountersRsp.getStatus() == 100) {
            osaOspfGetCountersRsp.setPmCountersUnavailable();
        } else if (osaOspfGetCountersRsp.getStatus() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "GetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfGetCountersRsp.getStatus()), osaOspfGetCountersRsp.getStatus());
        }
        return osaOspfGetCountersRsp;
    }

    private OsaOspfGetAttrRsp getOspfAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = "Ospf";
        Osa_OspfObjId osa_OspfObjId = this.createOspfObj(string, this.ospfFroId.getValue(coordinator));
        OsaOspfGetAttrRsp osaOspfGetAttrRsp = froProxy.sendOspfGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), osa_OspfObjId);
        if (osaOspfGetAttrRsp == null) {
            throw new FroNotAccessibleException("Ospf", "Ospf Fro");
        }
        if (osaOspfGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("Ospf", "Ospf", "GetAttrReq: " + OsaOspfMgmntProxy.getResultMsg(osaOspfGetAttrRsp.getResult()), osaOspfGetAttrRsp.getResult());
        }
        return osaOspfGetAttrRsp;
    }

    public String getType() {
        return "Ospf";
    }

    private static int checkAndGetOspfRouterId(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("ospfRouterId");
        if (n == -1) {
            throw new AttrMissingAtCreateException("ospfRouterId", "Ospf");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("ospfRouterId", "Ospf");
        }
        int n2 = new IpAddress((String)attrList.getValue(n)).toInt();
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetTopoDbStoreInterv(AttrList attrList) throws MoAccessException {
        int n = 60;
        int n2 = attrList.indexOf("topoDbStoreInterv");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("topoDbStoreInterv", "Ospf");
        }
        if ((Integer)attrList.getValue(n2) < 0) {
            throw new ValueOutOfRangeException("topoDbStoreInterv", "Ospf");
        }
        n = (Integer)attrList.getValue(n2);
        attrList.removeElementAt(n2);
        return n;
    }

    private Osa_OspfObjId createOspfObj(String string, int n) {
        Osa_OspfObjId osa_OspfObjId = new Osa_OspfObjId();
        osa_OspfObjId.instanceId = n;
        osa_OspfObjId.className = MaoFroTypeConverter.string2byteArray((String)string, (int)32);
        return osa_OspfObjId;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }
}

