/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.common.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class PauseTest {
    private static final Class THIS_CLASS = PauseTest.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private DbWrapper dbWrapper = null;

    public void pause(int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "pause()");
        try {
            this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            this.dbWrapper.openConnection();
            this.dbWrapper.executeUpdate("CREATE TABLE pausetest (PERSISTENT, frotype INTEGER PRIMARY KEY, frotypename CHAR, frodatatablename CHAR)");
            logger.traceGeneral(THIS_CLASS, "Created \"pausetest\" table! use \"sqlc drop table pausetest\" to continue!");
            logger.traceGeneral(THIS_CLASS, "Now is a good time to read your logfiles!");
            Thread.sleep(2000L);
            while (this.checkDb()) {
                Thread.sleep(2000L);
            }
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, AueUtil.appendReason((String)"The PauseTest failed!", (Throwable)exception), (Throwable)exception);
            throw new CrbsAueException("The PauseTest failed!", (Throwable)exception);
        }
        finally {
            try {
                this.dbWrapper.closeConnection(n);
            }
            catch (Exception exception) {}
        }
        logger.traceReturn(THIS_CLASS, "pause()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDb() throws SQLException {
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            resultSet = this.dbWrapper.executeQuery("SELECT name FROM tables WHERE name = 'pausetest'");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string == null || !string.equalsIgnoreCase("pausetest")) continue;
                bl = true;
                break;
            }
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        return bl;
    }
}

