/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.AbstractLastCollectorEdge;

public class NoamLastCollectorEdge
extends AbstractLastCollectorEdge {
    private static final Class THIS_CLASS = NoamLastCollectorEdge.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int RESTART_COUNTER_LIMIT_1 = 1;
    public static final String[] LTE_MANDATORY_MP_LOADMODULE_PRODUCT_NUMBERS = new String[]{"CXC1725190", "CXC1725191", "CXC1732768", "CXC1726088", "CXC1729153", "CXC1725398", "CXC1725422", "CXC1323891", "CXC1329000", "CXC1732823"};
    private final Map foundMandatoryProducts = new HashMap();
    public static final String[] LTE_OPTIONAL_MP_LOADMODULE_PRODUCT_NUMBERS = new String[]{"CXC1733306"};
    private ManagedObject programMo = null;

    public NoamLastCollectorEdge(XmlHolder xmlHolder) {
        super(xmlHolder);
        logger.traceEnter(THIS_CLASS, "NoamLastCollectorEdge()");
        logger.traceReturn(THIS_CLASS, "NoamLastCollectorEdge()");
    }

    public void aueSpecificTraverse(CollectorContext collectorContext) {
        logger.traceEnter(THIS_CLASS, "aueSpecificTraverse()");
        try {
            TransactionWrapper transactionWrapper = collectorContext.getTransactionWrapperFactory().create();
            Coordinator coordinator = transactionWrapper.getCoordinator();
            this.setRestartCounterLimitHandleExceptionAndCommit(transactionWrapper, coordinator, 1, collectorContext);
        }
        catch (AueException aueException) {
            collectorContext.getCurrentTrigger().reportProgress(new String[]{"Attribute restartCounterLimit could not be set to 1 for any LTE programs on the MP because it was not possible to get coordintor. " + aueException.toString()});
            logger.traceError(THIS_CLASS, "Attribute restartCounterLimit could not be set to 1 for any LTE programs on the MP because it was not possible to get coordintor.", (Throwable)aueException);
        }
        logger.traceReturn(THIS_CLASS, "aueSpecificTraverse()");
    }

    private void setRestartCounterLimitHandleExceptionAndCommit(TransactionWrapper transactionWrapper, Coordinator coordinator, int n, CollectorContext collectorContext) {
        logger.traceEnter(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
        try {
            this.setRestartCounterLimits(n, collectorContext, coordinator);
        }
        catch (MoAccessException moAccessException) {
            String string = "Unknown Program MO";
            if (this.programMo != null) {
                string = this.programMo.getLocalDistinguishedName();
            }
            String string2 = "Could not retrieve neccessary information from Program MO  " + string + ". Original exception: " + moAccessException.getVariablesAsString();
            collectorContext.getCurrentTrigger().reportProgress(new String[]{string2});
            logger.traceError(THIS_CLASS, string2);
        }
        try {
            transactionWrapper.commit();
        }
        catch (AueException aueException) {
            collectorContext.getCurrentTrigger().reportProgress(new String[]{"Commit failed for update of attribute restartCounterLimit of Program MOs."});
            logger.traceError(THIS_CLASS, "Commit failed for update of attribute restartCounterLimit of Program MOs.");
        }
        logger.traceReturn(THIS_CLASS, "setLteMpProgramsRestartCounterLimit()");
    }

    private void setRestartCounterLimits(int n, CollectorContext collectorContext, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("Program");
        if (moIterator != null) {
            Object object;
            int n2 = 0;
            while (moIterator.hasMoreElements()) {
                this.programMo = (ManagedObject)moIterator.nextElement();
                object = (Integer)this.programMo.getAttribute("startState", coordinator);
                if ((Integer)object != 1) continue;
                n2 += this.setRestartCounterLimitIfProductNumberLte(n, collectorContext, coordinator);
            }
            if (n2 != LTE_MANDATORY_MP_LOADMODULE_PRODUCT_NUMBERS.length) {
                object = "Attribute restartCounterLimit could not be set to 1 for all LTE programs on the MP. " + n2 + " out of " + LTE_MANDATORY_MP_LOADMODULE_PRODUCT_NUMBERS.length + " values was set.";
                collectorContext.getCurrentTrigger().reportProgress(new String[]{object});
                logger.traceError(THIS_CLASS, (String)object);
            }
        }
    }

    private int setRestartCounterLimitIfProductNumberLte(int n, CollectorContext collectorContext, Coordinator coordinator) throws MoAccessException {
        int n2;
        block4: {
            n2 = 0;
            ManagedObject managedObject = (ManagedObject)this.programMo.getAttribute("loadModule", coordinator);
            Struct struct = (Struct)managedObject.getAttribute("productData", coordinator);
            String string = (String)struct.getValue("productNumber");
            boolean bl = this.isIncludedInLteMandatoryLoadmoduleList(string);
            boolean bl2 = this.isIncludedInLteOptionalLoadmoduleList(string);
            if (bl || bl2) {
                try {
                    logger.traceDebug(THIS_CLASS, "Setting restartCounterLimit for " + string);
                    this.programMo.setAttribute("restartCounterLimit", (Object)new Integer(n), coordinator);
                    if (bl && !this.foundMandatoryProducts.containsKey(string)) {
                        this.foundMandatoryProducts.put(string, null);
                        ++n2;
                    }
                }
                catch (MoAccessException moAccessException) {
                    if (!bl) break block4;
                    String string2 = "Could not set restartCounterLimit to " + n + " for LTE Program MO connected to LoadModule " + string + ": " + moAccessException.getVariablesAsString();
                    collectorContext.getCurrentTrigger().reportProgress(new String[]{string2});
                    logger.traceError(THIS_CLASS, string2);
                }
            }
        }
        return n2;
    }

    private boolean isIncludedInLteMandatoryLoadmoduleList(String string) {
        boolean bl = false;
        for (int i = 0; i < LTE_MANDATORY_MP_LOADMODULE_PRODUCT_NUMBERS.length; ++i) {
            if (string.indexOf(LTE_MANDATORY_MP_LOADMODULE_PRODUCT_NUMBERS[i]) == -1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isIncludedInLteOptionalLoadmoduleList(String string) {
        boolean bl = false;
        for (int i = 0; i < LTE_OPTIONAL_MP_LOADMODULE_PRODUCT_NUMBERS.length && !bl; ++i) {
            if (string.indexOf(LTE_OPTIONAL_MP_LOADMODULE_PRODUCT_NUMBERS[i]) == -1) continue;
            bl = true;
        }
        return bl;
    }
}

