/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;

public class OtherFragmentUtility {
    private static final Class THIS_CLASS = OtherFragmentUtility.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int FIRST_COLUMN_1 = 1;
    private static final int SECOND_COLUMN_2 = 2;
    private DbWrapper dbWrapper;

    public boolean isMoExistingInOtherFragment(String string, String string2) throws CrbsAueException {
        boolean bl = false;
        logger.traceEnter(THIS_CLASS, "isMoExistingInOtherFragment()");
        String string3 = LdnUtil.getMoType((String)string2);
        this.initDbWrapper();
        this.openDbConnection();
        try {
            String string4 = this.getFroVersionsTableName(string, string3);
            if (string4 != null) {
                bl = this.isDataTableExisting(string4, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Could not get table data for: " + string3, (Throwable)sQLException);
        }
        finally {
            this.closeDbConnection();
        }
        logger.traceReturn(THIS_CLASS, "isMoExistingInOtherFragment()");
        return bl;
    }

    public Object getAttribute(String string, String string2, String string3) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getAttribute()");
        Object object = null;
        String string4 = LdnUtil.getMoType((String)string2);
        this.initDbWrapper();
        this.openDbConnection();
        try {
            String string5 = this.getFroVersionsTableName(string, string4);
            if (string5 != null) {
                object = this.getAttributeValue(string3, string5, string2);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Could not get table data for: " + string4, (Throwable)sQLException);
        }
        finally {
            this.closeDbConnection();
        }
        logger.traceReturn(THIS_CLASS, "getAttribute()");
        return object;
    }

    public Map getFroLdnToFroTypeAndFroIdMapping(String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroLdnToFroIdMapping()");
        Map map = new HashMap();
        this.initDbWrapper();
        this.openDbConnection();
        try {
            String string3 = this.getFroVersionsTableName(string, string2);
            if (string3 != null) {
                String string4 = this.getFroType(string, string2);
                map = this.getFroLdnToFroTypeAndIdMapping(string4, string3);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Could not get table data for: " + string2, (Throwable)sQLException);
        }
        finally {
            this.closeDbConnection();
        }
        logger.traceReturn(THIS_CLASS, "getFroLdnToFroIdMapping()");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFroVersionsTableName(String string, String string2) throws SQLException {
        String string3 = "select frodatatablename from " + string + "_fro_versions where frotypename = '" + string2 + "'";
        ResultSet resultSet = null;
        String string4 = null;
        try {
            resultSet = this.dbWrapper.executeQuery(string3);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFroType(String string, String string2) throws SQLException {
        String string3 = "select froType from " + string + "_fro_versions where frotypename = '" + string2 + "'";
        ResultSet resultSet = null;
        String string4 = null;
        try {
            resultSet = this.dbWrapper.executeQuery(string3);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDataTableExisting(String string, String string2) throws SQLException {
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            String string3 = "select ldn from " + string + " where ldn = '" + string2 + "'";
            resultSet = this.dbWrapper.executeQuery(string3);
            bl = resultSet.next();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeValue(String string, String string2, String string3) throws SQLException {
        String string4 = "select " + string + " from " + string2 + " where ldn = '" + string3 + "'";
        ResultSet resultSet = null;
        Object object = null;
        try {
            resultSet = this.dbWrapper.executeQuery(string4);
            if (resultSet.next()) {
                object = resultSet.getObject(1);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getFroLdnToFroTypeAndIdMapping(String string, String string2) throws SQLException {
        String string3 = "select ldn, froId from " + string2;
        ResultSet resultSet = null;
        HashMap<String, FroInstanceInfo> hashMap = new HashMap<String, FroInstanceInfo>();
        if (string != null) {
            try {
                resultSet = this.dbWrapper.executeQuery(string3);
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    FroInstanceInfo froInstanceInfo = new FroInstanceInfo(string, string5);
                    hashMap.put(string4, froInstanceInfo);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return hashMap;
    }

    private void openDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.openConnection();
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Failing open db connection", (Throwable)sQLException);
        }
    }

    private void closeDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.closeConnection(1);
        }
        catch (SQLException sQLException) {
            logger.traceAbnormal(THIS_CLASS, "Unable to close db connection: " + (Object)((Object)sQLException));
            throw new CrbsAueException("Unable to close db connection: " + (Object)((Object)sQLException));
        }
    }

    private void initDbWrapper() throws CrbsAueException {
        this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
    }

    public static class FroInstanceInfo {
        private String mFroType;
        private String mFroId;

        public FroInstanceInfo(String string, String string2) {
            this.setFroType(string);
            this.setFroId(string2);
        }

        public String getFroType() {
            return this.mFroType;
        }

        private void setFroType(String string) {
            this.mFroType = string;
        }

        public String getFroId() {
            return this.mFroId;
        }

        private void setFroId(String string) {
            this.mFroId = string;
        }
    }
}

