/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;

public class DelayAction
extends AbstractConversionAction {
    private static final String XML_STRING_DELAY = "delay";
    private static final Class THIS_CLASS = DelayAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        int n = 0;
        try {
            String string = this.getAndCheckParamMapString(XML_STRING_DELAY, this.paramMap, "The attribute delay is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CrbsAueException("Invalid value specified for attribute delay", (Throwable)numberFormatException);
        }
        try {
            logger.info(THIS_CLASS, "Will sleep for " + n / 1000 + " seconds as a work-around for TR HO22700 and HO22668.");
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            logger.traceAbnormal(THIS_CLASS, "Got unexpected interrupted Exception " + interruptedException);
        }
        finally {
            logger.info(THIS_CLASS, "Finished sleeping as a work-around for TR HO22700 and HO22668.");
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }
}

