/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it12;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CleanUpFroTypesAction
extends AbstractConversionAction {
    private static final Map moTypesToRemoveMap = new HashMap();
    private DbWrapper dbWrapper;
    private static final Class THIS_CLASS = CleanUpFroTypesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CleanUpFroTypesAction() {
        moTypesToRemoveMap.put("DpProgram", null);
        moTypesToRemoveMap.put("Cabinet", null);
        moTypesToRemoveMap.put("FanGroup", null);
        moTypesToRemoveMap.put("HwUnit", null);
        moTypesToRemoveMap.put("AlarmPort", null);
        moTypesToRemoveMap.put("ControlPort", null);
        moTypesToRemoveMap.put("BatteryBackup", null);
        moTypesToRemoveMap.put("EcPort", null);
        moTypesToRemoveMap.put("ExternalNode", null);
        moTypesToRemoveMap.put("PowerDistribution", null);
        moTypesToRemoveMap.put("PowerSupply", null);
        moTypesToRemoveMap.put("EquipmentSupportFunction", null);
    }

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDataArray = froVersionsTable.getDatas();
        logger.traceDebug(THIS_CLASS, "froVersionsData.length = " + froVersionsDataArray.length);
        if (froVersionsDataArray.length > 0) {
            this.cleanUp(froVersionsDataArray, froVersionsTable, tableHandler.getFroAttributesTable());
        } else {
            logger.traceDebug(THIS_CLASS, "fro_versions table is empty.");
        }
        froVersionsDataArray = null;
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void cleanUp(FroVersionsData[] froVersionsDataArray, FroVersionsTable froVersionsTable, FroAttributesTable froAttributesTable) throws CrbsAueException {
        this.initDbWrapper();
        this.openDbConnection();
        try {
            Map map = this.getTablesMap();
            for (int i = 0; i < froVersionsDataArray.length; ++i) {
                if (!moTypesToRemoveMap.containsKey(froVersionsDataArray[i].froTypeName)) continue;
                this.cleanUpOneMoType(froVersionsDataArray[i].froType, froVersionsDataArray[i].froDataTableName, map, froVersionsTable, froAttributesTable);
            }
            map = null;
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caugth SQLException", (Throwable)sQLException);
        }
        finally {
            this.closeDbConnection();
        }
    }

    private void cleanUpOneMoType(int n, String string, Map map, FroVersionsTable froVersionsTable, FroAttributesTable froAttributesTable) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "cleanUpOneMoType: " + n);
        try {
            froVersionsTable.deleteFroTypeId(n);
            this.deleteFromFroAttributesIgnoreException(n, froAttributesTable);
            String string2 = string.toLowerCase(Locale.getDefault());
            if (map.containsKey(string2)) {
                String string3 = "drop table " + string2;
                this.dbWrapper.executeUpdate(string3);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caugth SQLException", (Throwable)sQLException);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Caugth TableDataException: ", (Throwable)tableDataException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getTablesMap() throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ResultSet resultSet = null;
        try {
            resultSet = this.dbWrapper.executeQuery("select name from tables");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                if (string == null) continue;
                hashMap.put(string, null);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return hashMap;
    }

    private void deleteFromFroAttributesIgnoreException(int n, FroAttributesTable froAttributesTable) {
        try {
            froAttributesTable.deleteFromTable(n);
        }
        catch (TableDataException tableDataException) {
            logger.traceDebug(THIS_CLASS, "In fro_attributes not possible to remove frotype: " + n);
        }
    }

    private void openDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.openConnection();
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Failing open db connection", (Throwable)sQLException);
        }
    }

    private void closeDbConnection() throws CrbsAueException {
        try {
            this.dbWrapper.closeConnection(1);
        }
        catch (SQLException sQLException) {
            logger.traceAbnormal(THIS_CLASS, "Unable to close db connection: " + (Object)((Object)sQLException));
            throw new CrbsAueException("Unable to close db connection: " + (Object)((Object)sQLException));
        }
    }

    private void initDbWrapper() throws CrbsAueException {
        this.dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
    }
}

