/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it12;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemapAdmissionControlNonGbrRatioAction
extends AbstractConversionAction {
    private static final String MO_TYPE_ADMISSION_CONTROL = "AdmissionControl";
    private static final String ATTRIBUTE_UL_NON_GBR_RATIO = "ulNonGbrRatio";
    private static final String ATTRIBUTE_DL_NON_GBR_RATIO = "dlNonGbrRatio";
    private static final Class THIS_CLASS = RemapAdmissionControlNonGbrRatioAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTabledata(tableHandler, MO_TYPE_ADMISSION_CONTROL);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeValues(tableData, ATTRIBUTE_DL_NON_GBR_RATIO);
            Object[] objectArray2 = this.getAttributeValues(tableData, ATTRIBUTE_UL_NON_GBR_RATIO);
            for (int i = 0; i < objectArray2.length; ++i) {
                this.setAttributeValue(tableData, ATTRIBUTE_DL_NON_GBR_RATIO, i, 1000 - (Integer)objectArray[i]);
                this.setAttributeValue(tableData, ATTRIBUTE_UL_NON_GBR_RATIO, i, 1000 - (Integer)objectArray2[i]);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void setAttributeValue(TableData tableData, String string, int n, int n2) throws CrbsAueException {
        try {
            tableData.setAttributeValue(n, string, (Object)new Integer(n2));
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set attribute value for " + tableData.getFroTypeName() + "::" + string, (Throwable)tableDataException);
        }
    }

    private Object[] getAttributeValues(TableData tableData, String string) throws CrbsAueException {
        try {
            return tableData.getAttributeValues(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not find column data for " + tableData.getFroTypeName() + "::" + string, (Throwable)tableDataException);
        }
    }

    private TableData getTabledata(TableHandler tableHandler, String string) throws CrbsAueException {
        try {
            return tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not find table data for " + string, (Throwable)tableDataException);
        }
    }
}

