/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it14;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ChangeResolutionAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = ChangeResolutionAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getMoTypeName();
        try {
            TableData tableData = this.getTableData(aueContext, string);
            if (tableData.isNotEmpty()) {
                this.changeResolution(tableData, string);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void changeResolution(TableData tableData, String string) throws CrbsAueException {
        Object[] objectArray;
        String string2 = this.getAttributeName();
        int n = this.getNewResolution();
        int n2 = this.getMinValue();
        int n3 = this.getMaxValue();
        try {
            objectArray = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Integer n4 = null;
                if (objectArray[i] instanceof String) {
                    logger.traceDebug(THIS_CLASS, "The attribute : " + string2 + " is a String");
                    n4 = Integer.valueOf((String)objectArray[i]);
                } else if (objectArray[i] instanceof Integer) {
                    logger.traceDebug(THIS_CLASS, "The attribute : " + string2 + " is a Integer");
                    n4 = (Integer)objectArray[i];
                } else {
                    throw new CrbsAueException("Unsupported attribute value type in the db table: " + objectArray[i].getClass());
                }
                Integer n5 = this.changeResolution(n, n4, n2, n3);
                tableData.setAttributeValue(i, string2, (Object)n5);
                logger.traceGeneral(THIS_CLASS, "The new resolution \"" + n + "\"has been added to " + string + "::" + string2 + " . The old value was " + objectArray[i].toString() + "and the new value is " + n5);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private Integer changeResolution(int n, Integer n2, int n3, int n4) throws CrbsAueException {
        int n5 = n2;
        int n6 = n5 % n;
        double d = (double)n / 2.0;
        int n7 = n6 == 0 ? n5 : ((double)Math.abs(n6) < d ? n5 - n6 : (n6 > 0 ? n5 + n - n6 : n5 - n - n6));
        if (n7 < n3) {
            n7 = n3;
        } else if (n7 > n4) {
            n7 = n4;
        }
        return new Integer(n7);
    }

    private TableData getTableData(AueContext aueContext, String string) throws TableDataException {
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = tableHandler.getTableData(string);
        return tableData;
    }

    private String getMoTypeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("attribute", this.paramMap, "The attribute \"attribute\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private int getMinValue() throws CrbsAueException {
        String string = this.getAndCheckParamMapString("min", this.paramMap, "The attribute \"min\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Faulty parameter in xml string: " + string + ". The min value must be an integer.", (Throwable)exception);
        }
    }

    private int getMaxValue() throws CrbsAueException {
        String string = this.getAndCheckParamMapString("max", this.paramMap, "The attribute \"max\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Faulty parameter in xml string: " + string + ". The max value must be an integer.", (Throwable)exception);
        }
    }

    private int getNewResolution() throws CrbsAueException {
        String string = this.getAndCheckParamMapString("resolution", this.paramMap, "The attribute \"resolution\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Faulty parameter in xml string: " + string + ". The resolution value must be an integer.", (Throwable)exception);
        }
    }
}

