/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it15;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyStructMemberToStructMemberAction
extends AbstractConversionAction {
    private static final String END_OF_STRUCT = "</struct>";
    private static final Class THIS_CLASS = CopyStructMemberToStructMemberAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getMoTypeName();
        try {
            TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(string);
            if (tableData.isNotEmpty()) {
                this.copyStructMemberToStructMember(tableData, string);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private void copyStructMemberToStructMember(TableData tableData, String string) throws CrbsAueException {
        Object[] objectArray;
        Object[] objectArray2;
        String string2 = this.getFromAttributeName();
        String string3 = this.getFromStructMemberName();
        String string4 = this.getToAttributeName();
        String string5 = this.getToStructMemberName();
        try {
            objectArray2 = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        try {
            objectArray = tableData.getAttributeValues(string4);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string4, (Throwable)tableDataException);
        }
        try {
            for (int i = 0; i < objectArray2.length; ++i) {
                String string6 = objectArray2[i].toString();
                String string7 = "";
                int n = string6.indexOf("<array name=\"" + string3 + "\"");
                string7 = n < 0 ? this.getAttributeStructMember(string6, string3, string, string2) : this.getArrayStructMember(n, string6, string3, string, string2);
                string7 = AueUtil.replaceInString((String)string7, (String)string3, (String)string5);
                String string8 = objectArray[i].toString();
                if (string8.indexOf("attr name=\"" + string5 + "\"") > 0) {
                    throw new CrbsAueException("Struct member " + string5 + " already exists in struct " + string4);
                }
                String string9 = this.addMemberToStruct(string7, string8);
                tableData.setAttributeValue(i, string4, (Object)string9);
                logger.traceGeneral(THIS_CLASS, "The struct member \"" + string3 + "\" was successfully copied from " + string + "::" + string2 + ", instance " + i + " to " + string + "::" + string4 + " struct member \"" + string5 + "\"");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private String getArrayStructMember(int n, String string, String string2, String string3, String string4) throws CrbsAueException {
        int n2 = string.indexOf("</array>", n);
        if (n2 < 0) {
            throw new CrbsAueException("Could not get ending array tag for struct member " + string2 + " in " + string + " for " + string3 + "::" + string4);
        }
        return string.substring(n, n2 + "</array>".length());
    }

    private String getAttributeStructMember(String string, String string2, String string3, String string4) throws CrbsAueException {
        int n = string.indexOf("<attr name=\"" + string2 + "\"");
        if (n < 0) {
            throw new CrbsAueException("Could not get struct member " + string2 + " for " + string3 + "::" + string4);
        }
        int n2 = string.indexOf("value=\"", n);
        if (n2 < 0) {
            throw new CrbsAueException("Could not get struct member " + string2 + " value in struct " + string + " for " + string3 + "::" + string4);
        }
        int n3 = n2 + "value=\"".length();
        int n4 = string.indexOf("\"/>", n3);
        if (n4 < 0) {
            throw new CrbsAueException("Could not get struct member value due to missing end quote in " + string2 + " for " + string3 + "::" + string4);
        }
        String string5 = string.substring(n, n4 + "\"/>".length());
        logger.traceGeneral(THIS_CLASS, "STRUCT MEMBER: " + string5);
        return string5;
    }

    private String addMemberToStruct(String string, String string2) throws CrbsAueException {
        int n = string2.indexOf(END_OF_STRUCT);
        if (n < 0) {
            throw new CrbsAueException("Could not add struct member to struct, due to missing end of struct tag [</struct>]");
        }
        return string2.substring(0, n) + string + END_OF_STRUCT;
    }

    private String getMoTypeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getFromAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("fromAttr", this.paramMap, "The attribute fromAttr is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getFromStructMemberName() throws CrbsAueException {
        return this.getAndCheckParamMapString("structMember", this.paramMap, "The attribute structMember is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getToAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("toAttr", this.paramMap, "The attribute toAttr is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getToStructMemberName() throws CrbsAueException {
        return this.getAndCheckParamMapString("toStructMember", this.paramMap, "The attribute toStructMember is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }
}

