/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it17;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class MapSecurityHandlingAttributesAction
extends AbstractConversionAction {
    private static final String INTEGRITY_PROTECTION_ALGORITHMS = "integrityProtectionAlgorithms";
    private static final String CIPHERING_ALGORITHMS = "cipheringAlgorithms";
    private static final String INTEGRITY_PROTECT_ALGO_PRIO = "integrityProtectAlgoPrio";
    private static final String CIPHERING_ALGO_PRIO = "cipheringAlgoPrio";
    private static final Class THIS_CLASS = MapSecurityHandlingAttributesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        try {
            TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(string);
            if (tableData.isNotEmpty()) {
                this.checkAndSetSecurityHandlingAttributes(tableData, string);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private void checkAndSetSecurityHandlingAttributes(TableData tableData, String string) throws CrbsAueException {
        Object[] objectArray;
        Object[] objectArray2;
        String string2 = "";
        try {
            string2 = CIPHERING_ALGO_PRIO;
            tableData.getAttributeValues(string2);
            string2 = CIPHERING_ALGORITHMS;
            objectArray2 = tableData.getAttributeValues(string2);
            string2 = INTEGRITY_PROTECT_ALGO_PRIO;
            tableData.getAttributeValues(string2);
            string2 = INTEGRITY_PROTECTION_ALGORITHMS;
            objectArray = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            Integer n = (Integer)objectArray2[i];
            Integer n2 = (Integer)objectArray[i];
            String string3 = this.mapCipheringAlgorithmToCipheringAlgoPrio(n);
            String string4 = this.mapIntegrityProtectionAlgorithmToIntegrityProtectAlgoPrio(n2);
            try {
                string2 = CIPHERING_ALGO_PRIO;
                tableData.setAttributeValue(i, string2, (Object)string3);
                string2 = INTEGRITY_PROTECT_ALGO_PRIO;
                tableData.setAttributeValue(i, string2, (Object)string4);
                continue;
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
            }
        }
    }

    private String mapIntegrityProtectionAlgorithmToIntegrityProtectAlgoPrio(Integer n) throws CrbsAueException {
        String string;
        switch (n) {
            case 5: {
                string = "<array name=\"integrityProtectAlgoPrio\"><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 6: {
                string = "<array name=\"integrityProtectAlgoPrio\"><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 7: {
                string = "<array name=\"integrityProtectAlgoPrio\"><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 8: {
                string = "<array name=\"integrityProtectAlgoPrio\"><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 9: {
                string = "<array name=\"integrityProtectAlgoPrio\"><attr type=\"S32\" value=\"3\"/></array>";
                break;
            }
            default: {
                throw new CrbsAueException("IntegrityProtectionAlgorithm value " + n + " is invalid. Can not be mapped to a valid " + INTEGRITY_PROTECT_ALGO_PRIO + " value.");
            }
        }
        return string;
    }

    private String mapCipheringAlgorithmToCipheringAlgoPrio(Integer n) throws CrbsAueException {
        String string;
        switch (n) {
            case 0: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            case 1: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 2: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            case 3: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 4: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 5: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 6: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 7: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"1\"/><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            case 8: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 9: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"2\"/><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            case 10: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 11: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"0\"/><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 12: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"1\"/></array>";
                break;
            }
            case 13: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"2\"/></array>";
                break;
            }
            case 14: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            case 15: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"3\"/></array>";
                break;
            }
            case 16: {
                string = "<array name=\"cipheringAlgoPrio\"><attr type=\"S32\" value=\"3\"/><attr type=\"S32\" value=\"0\"/></array>";
                break;
            }
            default: {
                throw new CrbsAueException("CipheringAlgorithm value " + n + " is invalid. Can not be mapped to a valid " + CIPHERING_ALGO_PRIO + " value.");
            }
        }
        return string;
    }
}

