/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it18;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRef;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefArray;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefArrayParser;
import se.ericsson.lte.rbs.omf.aue.step1.util.MoRefParser;

public class ConvertFroTypeIdInReferences
extends AbstractConversionAction {
    private static final Class THIS_CLASS = ConvertFroTypeIdInReferences.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Map moTypeToCatFroTypeMap = new HashMap();

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        try {
            TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
            FroVersionsData[] froVersionsDataArray = tableHandler.getFroVersionsTable().getDatas();
            this.forceCachingOfAllLteMOTypes(tableHandler, froVersionsDataArray);
            this.readCatFroTypeIds();
            TableData[] tableDataArray = tableHandler.getAllTableDatas();
            for (int i = 0; i < tableDataArray.length; ++i) {
                logger.traceDebug(THIS_CLASS, "convert() " + tableDataArray[i].getFroTypeName());
                FroAttributesData[] froAttributesDataArray = tableDataArray[i].getFroAttributesTable().getDatas();
                for (int j = 0; j < froAttributesDataArray.length; ++j) {
                    if (tableDataArray[i].getFroTypeId() != froAttributesDataArray[j].froType || !"moref".equalsIgnoreCase(froAttributesDataArray[j].attrType) && !"ARRAY".equalsIgnoreCase(froAttributesDataArray[j].attrType)) continue;
                    this.convertAttribute(tableDataArray, i, froAttributesDataArray, j);
                }
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to read cached table data", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void forceCachingOfAllLteMOTypes(TableHandler tableHandler, FroVersionsData[] froVersionsDataArray) throws TableDataException {
        for (int i = 0; i < froVersionsDataArray.length; ++i) {
            logger.traceDebug(THIS_CLASS, "convert() caching data about " + froVersionsDataArray[i].froTypeName);
            tableHandler.getTableData(froVersionsDataArray[i].froTypeName);
        }
    }

    private void convertAttribute(TableData[] tableDataArray, int n, FroAttributesData[] froAttributesDataArray, int n2) throws TableDataException, CrbsAueException {
        logger.traceDebug(THIS_CLASS, "convert() " + froAttributesDataArray[n2].attrName);
        Object[] objectArray = tableDataArray[n].getAttributeValues(froAttributesDataArray[n2].attrName);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if ("moref".equalsIgnoreCase(froAttributesDataArray[n2].attrType)) {
                object = MoRefParser.parseMoRef(objectArray[i].toString());
                if (!this.convertMoRef((MoRef)object)) continue;
                tableDataArray[n].setAttributeValue(i, froAttributesDataArray[n2].attrName, (Object)((MoRef)object).toString());
                continue;
            }
            object = MoRefArrayParser.parseMoRefArray(objectArray[i].toString());
            if (!this.convertMoRefArray((MoRefArray)object)) continue;
            tableDataArray[n].setAttributeValue(i, froAttributesDataArray[n2].attrName, (Object)((MoRefArray)object).toString());
        }
    }

    private boolean convertMoRef(MoRef moRef) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "convertMoRef()");
        boolean bl = false;
        if (moRef.froTypeId != -1) {
            String string = moRef.ldn.substring(moRef.ldn.lastIndexOf(",") + 1, moRef.ldn.lastIndexOf("="));
            Integer n = (Integer)this.moTypeToCatFroTypeMap.get(string);
            if (n == null) {
                logger.traceDebug(THIS_CLASS, "Cannot get CAT froId for MoRef attribute " + moRef.attrName + " that refers to " + moRef.ldn);
            } else {
                logger.traceDebug(THIS_CLASS, "convertMoRef() attribute " + moRef.attrName + " which refers to type " + string + " has a new froTypeId == " + n);
                moRef.froTypeId = n;
                bl = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "convertMoRef() " + bl);
        return bl;
    }

    private void readCatFroTypeIds() {
        logger.traceEnter(THIS_CLASS, "readCatFroTypeIds()");
        this.moTypeToCatFroTypeMap.put("SectorEquipmentFunction", new Integer(0x1000009));
        this.moTypeToCatFroTypeMap.put("RbsSlot", new Integer(0x1000007));
        this.moTypeToCatFroTypeMap.put("AntennaSubunit", new Integer(0x1010001));
        this.moTypeToCatFroTypeMap.put("ResourceAllocationFunction", new Integer(0x100000F));
        this.moTypeToCatFroTypeMap.put("AntennaUnit", new Integer(0x1010002));
        this.moTypeToCatFroTypeMap.put("DeviceGroup", new Integer(0x1000001));
        this.moTypeToCatFroTypeMap.put("SubDeviceGroup", new Integer(0x100000A));
        this.moTypeToCatFroTypeMap.put("RicmDeviceSet", new Integer(0x1000004));
        this.moTypeToCatFroTypeMap.put("XpProgram", new Integer(0x1000005));
        this.moTypeToCatFroTypeMap.put("TrDeviceSet", new Integer(0x1000002));
        this.moTypeToCatFroTypeMap.put("RbsSubrack", new Integer(0x1000006));
        this.moTypeToCatFroTypeMap.put("AuPort", new Integer(0x1010004));
        this.moTypeToCatFroTypeMap.put("RfPort", new Integer(0x1010009));
        this.moTypeToCatFroTypeMap.put("RfBranch", new Integer(0x1010008));
        this.moTypeToCatFroTypeMap.put("AntennaUnitGroup", new Integer(0x1010003));
        this.moTypeToCatFroTypeMap.put("RiPort", new Integer(0x1000003));
        this.moTypeToCatFroTypeMap.put("AuxPlugInUnit", new Integer(0x1000000));
        this.moTypeToCatFroTypeMap.put("SystemConstants", new Integer(0x1000008));
        this.moTypeToCatFroTypeMap.put("CellDeviceSet", new Integer(0x100000B));
        this.moTypeToCatFroTypeMap.put("SrioTestPort", new Integer(0x100000C));
        this.moTypeToCatFroTypeMap.put("UcToolFunction", new Integer(0x100000D));
        this.moTypeToCatFroTypeMap.put("XmuDeviceSet", new Integer(0x1000010));
        this.moTypeToCatFroTypeMap.put("AntennaCtrlDevice", new Integer(0x1000011));
        this.moTypeToCatFroTypeMap.put("AntennaPath", new Integer(0x1000012));
        this.moTypeToCatFroTypeMap.put("NodeManagementFunction", new Integer(0x1000013));
        this.moTypeToCatFroTypeMap.put("AntennaNearUnit", new Integer(0x1010000));
        this.moTypeToCatFroTypeMap.put("ExternalTMA", new Integer(0x1010005));
        this.moTypeToCatFroTypeMap.put("ExtMaConnector", new Integer(0x1010006));
        this.moTypeToCatFroTypeMap.put("RetSubUnit", new Integer(0x1010007));
        this.moTypeToCatFroTypeMap.put("TmaSubUnit", new Integer(0x101000A));
        logger.traceReturn(THIS_CLASS, "readCatFroTypeIds()");
    }

    private boolean convertMoRefArray(MoRefArray moRefArray) throws CrbsAueException, TableDataException {
        logger.traceEnter(THIS_CLASS, "convertMoRef()");
        boolean bl = false;
        Iterator iterator = moRefArray.getMoRefList().iterator();
        while (iterator.hasNext()) {
            MoRef moRef = (MoRef)iterator.next();
            bl = this.convertMoRef(moRef) || bl;
        }
        logger.traceReturn(THIS_CLASS, "convertMoRef() " + bl);
        return bl;
    }
}

